/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.appserver.monitoring.rest.service;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Engine;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.SystemApplications;
import com.sun.enterprise.v3.server.ApplicationLoaderService;
import fish.payara.appserver.monitoring.rest.service.adapter.RestMonitoringAdapter;
import java.beans.PropertyVetoException;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigCode;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.TransactionFailure;

public class RestMonitoringLoader
extends Thread {
    private final Domain domain;
    private final ServerEnvironmentImpl serverEnv;
    private final String contextRoot;
    private String applicationName;
    private final RestMonitoringAdapter restMonitoringAdapter;
    private final ServiceLocator habitat;
    private static final Logger LOGGER = Logger.getLogger(RestMonitoringLoader.class.getName());
    private final List<String> vss;
    private final boolean dynamicStart;

    RestMonitoringLoader(RestMonitoringAdapter restMonitoringAdapter, ServiceLocator habitat, Domain domain, ServerEnvironmentImpl serverEnv, String contextRoot, String applicationName, List<String> vss) {
        this.restMonitoringAdapter = restMonitoringAdapter;
        this.habitat = habitat;
        this.domain = domain;
        this.serverEnv = serverEnv;
        this.contextRoot = contextRoot;
        this.applicationName = applicationName;
        this.vss = vss;
        this.dynamicStart = false;
    }

    RestMonitoringLoader(RestMonitoringAdapter restMonitoringAdapter, ServiceLocator habitat, Domain domain, ServerEnvironmentImpl serverEnv, String contextRoot, String applicationName, List<String> vss, boolean dynamicStart) {
        this.restMonitoringAdapter = restMonitoringAdapter;
        this.habitat = habitat;
        this.domain = domain;
        this.serverEnv = serverEnv;
        this.contextRoot = contextRoot;
        this.applicationName = applicationName;
        this.vss = vss;
        this.dynamicStart = dynamicStart;
    }

    @Override
    public void run() {
        try {
            if (this.dynamicStart) {
                if (this.restMonitoringAdapter.appExistsInConfig(this.contextRoot)) {
                    if (!this.restMonitoringAdapter.isAppRegistered(this.contextRoot)) {
                        this.registerApplication();
                    } else {
                        this.reconfigureSystemApplication();
                    }
                } else {
                    this.createAndRegisterApplication();
                }
            } else if (this.restMonitoringAdapter.appExistsInConfig()) {
                if (!this.restMonitoringAdapter.isAppRegistered()) {
                    this.registerApplication();
                } else if (!this.contextRoot.equals(this.restMonitoringAdapter.getSystemApplicationConfig().getContextRoot())) {
                    this.reconfigureSystemApplication();
                }
            } else {
                this.createAndRegisterApplication();
            }
            this.loadApplication();
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Problem while attempting to register or load the Rest Monitoring application!", ex);
        }
    }

    private void createAndRegisterApplication() throws Exception {
        LOGGER.log(Level.FINE, "Registering the Rest Monitoring Application...");
        ConfigCode code = new ConfigCode(){

            public Object run(ConfigBeanProxy ... proxies) throws PropertyVetoException, TransactionFailure {
                SystemApplications systemApplications = (SystemApplications)proxies[0];
                Application application = (Application)systemApplications.createChild(Application.class);
                RestMonitoringLoader.this.checkAndResolveApplicationName(systemApplications);
                systemApplications.getModules().add(application);
                application.setName(RestMonitoringLoader.this.applicationName);
                application.setEnabled(Boolean.TRUE.toString());
                application.setObjectType("system-admin");
                application.setDirectoryDeployed("true");
                application.setContextRoot(RestMonitoringLoader.this.contextRoot);
                try {
                    application.setLocation("${com.sun.aas.installRootURI}/lib/install/applications/__restmonitoring");
                }
                catch (Exception me) {
                    throw new RuntimeException(me);
                }
                Module singleModule = (Module)application.createChild(Module.class);
                application.getModule().add(singleModule);
                singleModule.setName(RestMonitoringLoader.this.applicationName);
                Engine webEngine = (Engine)singleModule.createChild(Engine.class);
                webEngine.setSniffer("web");
                Engine weldEngine = (Engine)singleModule.createChild(Engine.class);
                weldEngine.setSniffer("cdi");
                Engine securityEngine = (Engine)singleModule.createChild(Engine.class);
                securityEngine.setSniffer("security");
                singleModule.getEngines().add(webEngine);
                singleModule.getEngines().add(weldEngine);
                singleModule.getEngines().add(securityEngine);
                Server s = (Server)proxies[1];
                List arefs = s.getApplicationRef();
                ApplicationRef aref = (ApplicationRef)s.createChild(ApplicationRef.class);
                aref.setRef(application.getName());
                aref.setEnabled(Boolean.TRUE.toString());
                aref.setVirtualServers(RestMonitoringLoader.this.getVirtualServerListAsString());
                arefs.add(aref);
                return true;
            }
        };
        Server server = this.domain.getServerNamed(this.serverEnv.getInstanceName());
        ConfigSupport.apply((ConfigCode)code, (ConfigBeanProxy[])new ConfigBeanProxy[]{this.domain.getSystemApplications(), server});
        LOGGER.log(Level.FINE, "Rest Monitoring Application Registered.");
    }

    private void registerApplication() throws Exception {
        LOGGER.log(Level.FINE, "Registering the Rest Monitoring Application...");
        ConfigCode code = new ConfigCode(){

            public Object run(ConfigBeanProxy ... proxies) throws PropertyVetoException, TransactionFailure {
                SystemApplications systemApplications = (SystemApplications)proxies[0];
                Application application = null;
                for (Application systemApplication : systemApplications.getApplications()) {
                    if (!systemApplication.getName().equals(RestMonitoringLoader.this.applicationName)) continue;
                    application = systemApplication;
                    break;
                }
                if (application == null) {
                    throw new IllegalStateException("The Rest Monitoring application has no system app entry!");
                }
                Server s = (Server)proxies[1];
                List arefs = s.getApplicationRef();
                ApplicationRef aref = (ApplicationRef)s.createChild(ApplicationRef.class);
                aref.setRef(application.getName());
                aref.setEnabled(Boolean.TRUE.toString());
                aref.setVirtualServers(RestMonitoringLoader.this.getVirtualServerListAsString());
                arefs.add(aref);
                return true;
            }
        };
        Server server = this.domain.getServerNamed(this.serverEnv.getInstanceName());
        ConfigSupport.apply((ConfigCode)code, (ConfigBeanProxy[])new ConfigBeanProxy[]{this.domain.getSystemApplications(), server});
        LOGGER.log(Level.FINE, "Rest Monitoring Application Registered.");
    }

    private String getVirtualServerListAsString() {
        if (this.vss == null) {
            return "";
        }
        String virtualServers = Arrays.toString(this.vss.toArray(new String[this.vss.size()]));
        virtualServers = virtualServers.substring(1, virtualServers.length() - 1);
        return virtualServers;
    }

    private void loadApplication() {
        ApplicationRegistry appRegistry = (ApplicationRegistry)this.habitat.getService(ApplicationRegistry.class, new Annotation[0]);
        ApplicationInfo appInfo = appRegistry.get(this.applicationName);
        if (appInfo != null && appInfo.isLoaded()) {
            LOGGER.log(Level.FINE, "Rest Monitoring Application already loaded.");
            return;
        }
        Application config = null;
        config = this.dynamicStart ? this.restMonitoringAdapter.getSystemApplicationConfig(this.contextRoot) : this.restMonitoringAdapter.getSystemApplicationConfig();
        if (config == null) {
            throw new IllegalStateException("The Rest Monitoring application has no system app entry!");
        }
        String instanceName = this.serverEnv.getInstanceName();
        ApplicationRef ref = this.domain.getApplicationRefInServer(instanceName, this.applicationName);
        Deployment lifecycle = (Deployment)this.habitat.getService(Deployment.class, new Annotation[0]);
        for (Deployment.ApplicationDeployment depl : ((ApplicationLoaderService)this.habitat.getService(ApplicationLoaderService.class, new Annotation[0])).processApplication(config, ref)) {
            lifecycle.initialize(depl.appInfo, depl.appInfo.getSniffers(), depl.context);
        }
        this.restMonitoringAdapter.setAppRegistered(true);
        LOGGER.log(Level.FINE, "Rest Monitoring Application Loaded.");
    }

    private void checkAndResolveApplicationName(SystemApplications systemApplications) {
        if (this.applicationName == null || this.applicationName.equals("")) {
            LOGGER.log(Level.INFO, "No or incorrect application name detected for Rest Monitoring: reverting to default");
            this.applicationName = "__restmonitoring";
        }
        boolean validApplicationNameFound = false;
        int applicationNameSuffix = 1;
        while (!validApplicationNameFound) {
            validApplicationNameFound = this.isApplicationNameValid(systemApplications);
            if (validApplicationNameFound) continue;
            this.applicationName = this.applicationName + "-" + applicationNameSuffix;
            ++applicationNameSuffix;
        }
    }

    private boolean isApplicationNameValid(SystemApplications systemApplications) {
        boolean validApplicationNameFound = true;
        for (Application systemApplication : systemApplications.getApplications()) {
            if (!systemApplication.getName().equals(this.applicationName)) continue;
            validApplicationNameFound = false;
            break;
        }
        return validApplicationNameFound;
    }

    private void reconfigureSystemApplication() throws Exception {
        Application systemApplication = this.restMonitoringAdapter.getSystemApplicationConfig();
        LOGGER.log(Level.FINE, "Reconfiguring the Rest Monitoring Application...");
        ConfigCode code = new ConfigCode(){

            public Object run(ConfigBeanProxy ... proxies) throws PropertyVetoException, TransactionFailure {
                Application systemApplication = (Application)proxies[0];
                systemApplication.setContextRoot(RestMonitoringLoader.this.contextRoot);
                return true;
            }
        };
        ConfigSupport.apply((ConfigCode)code, (ConfigBeanProxy[])new ConfigBeanProxy[]{systemApplication});
        LOGGER.log(Level.FINE, "Rest Monitoring Application Reconfigured.");
    }
}

