/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.mbeans;

import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.config.ConfigListener;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.management.mbeans.MQMBeanReadWrite;
import com.sun.messaging.jmq.jmsserver.management.util.LogUtil;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.logging.FileHandler;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;

public class LogConfig
extends MQMBeanReadWrite
implements ConfigListener {
    private Properties brokerProps = null;
    private static final String ROLLOVER_BYTES_PROP = "java.util.logging.FileHandler.limit";
    private static final String LOGLEVEL_PROP = ".level";
    private static MBeanAttributeInfo[] attrs;
    private static String[] attrChangeTypes;
    private static MBeanNotificationInfo[] notifs;

    public LogConfig() {
        this.initProps();
        BrokerConfig cfg = Globals.getConfig();
        cfg.addListener(LOGLEVEL_PROP, this);
        cfg.addListener(ROLLOVER_BYTES_PROP, this);
        cfg.addListener("imq.log.file.rolloversecs", this);
    }

    public void setLevel(String s) throws MBeanException {
        Properties p = new Properties();
        p.setProperty(LOGLEVEL_PROP, LogUtil.toInternalLogLevel(s));
        try {
            BrokerConfig cfg = Globals.getConfig();
            cfg.updateProperties(p, true);
        }
        catch (Exception e) {
            this.handleSetterException("Level", e);
        }
    }

    public String getLevel() {
        String s = this.brokerProps.getProperty(LOGLEVEL_PROP);
        return LogUtil.toExternalLogLevel(s);
    }

    public void setRolloverBytes(Long l) throws MBeanException {
        Properties p = new Properties();
        p.setProperty(ROLLOVER_BYTES_PROP, l.toString());
        try {
            BrokerConfig cfg = Globals.getConfig();
            cfg.updateProperties(p, true);
        }
        catch (Exception e) {
            this.handleSetterException("RolloverBytes", e);
        }
    }

    public Long getRolloverBytes() throws MBeanException {
        String s = this.brokerProps.getProperty(ROLLOVER_BYTES_PROP);
        Long l = null;
        try {
            l = Long.valueOf(s);
        }
        catch (Exception e) {
            this.handleGetterException("RolloverBytes", e);
        }
        return l;
    }

    public void setRolloverSecs(Long l) throws MBeanException {
        Properties p = new Properties();
        p.setProperty("imq.log.file.rolloversecs", l.toString());
        try {
            BrokerConfig cfg = Globals.getConfig();
            cfg.updateProperties(p, true);
        }
        catch (Exception e) {
            this.handleSetterException("RolloverSecs", e);
        }
    }

    public Long getRolloverSecs() throws MBeanException {
        String s = this.brokerProps.getProperty("imq.log.file.rolloversecs");
        Long l = null;
        try {
            l = s != null && !s.trim().equals("") ? Long.valueOf(s) : Long.valueOf(0L);
        }
        catch (Exception e) {
            this.handleGetterException("RolloverSecs", e);
        }
        return l;
    }

    public String getLogDirectory() throws MBeanException {
        return this.getLogFile().getParent();
    }

    public String getLogFileName() throws MBeanException {
        return this.getLogFile().getName();
    }

    @Override
    public String getMBeanName() {
        return "LogConfig";
    }

    @Override
    public String getMBeanDescription() {
        return mbr.getString("MB1135");
    }

    @Override
    public MBeanAttributeInfo[] getMBeanAttributeInfo() {
        return attrs;
    }

    @Override
    public MBeanOperationInfo[] getMBeanOperationInfo() {
        return null;
    }

    @Override
    public MBeanNotificationInfo[] getMBeanNotificationInfo() {
        return notifs;
    }

    @Override
    public void validate(String name, String value) throws PropertyUpdateException {
    }

    @Override
    public boolean update(String name, String value) {
        if (name.equals(LOGLEVEL_PROP)) {
            String newVal = LogUtil.toExternalLogLevel(value);
            String oldVal = this.getLevel();
            this.notifyAttrChange("Level", newVal, oldVal);
        } else if (name.equals(ROLLOVER_BYTES_PROP)) {
            Long oldVal;
            Long newVal;
            try {
                newVal = Long.valueOf(value);
            }
            catch (NumberFormatException nfe) {
                this.logger.log(32, this.getMBeanName() + ": cannot parse internal value of RolloverBytes: " + nfe);
                newVal = null;
            }
            try {
                oldVal = this.getRolloverBytes();
            }
            catch (Exception e) {
                this.logProblemGettingOldVal("RolloverBytes", e);
                oldVal = null;
            }
            this.notifyAttrChange("RolloverBytes", newVal, oldVal);
        } else if (name.equals("imq.log.file.rolloversecs")) {
            Long oldVal;
            Long newVal;
            try {
                newVal = Long.valueOf(value);
            }
            catch (NumberFormatException nfe) {
                this.logger.log(32, this.getMBeanName() + ": cannot parse internal value of RolloverSecs: " + nfe);
                newVal = null;
            }
            try {
                oldVal = this.getRolloverSecs();
            }
            catch (Exception e) {
                this.logProblemGettingOldVal("RolloverSecs", e);
                oldVal = null;
            }
            this.notifyAttrChange("RolloverSecs", newVal, oldVal);
        }
        this.initProps();
        return true;
    }

    public void notifyAttrChange(String attrName, Object newVal, Object oldVal) {
        this.sendNotification(new AttributeChangeNotification(this, this.sequenceNumber++, new Date().getTime(), "Attribute change", attrName, newVal == null ? "" : newVal.getClass().getName(), oldVal, newVal));
    }

    private void initProps() {
        this.brokerProps = Globals.getConfig().toProperties();
        Version version = Globals.getVersion();
        this.brokerProps.putAll((Map<?, ?>)version.getProps());
    }

    private File getLogFile() throws MBeanException {
        try {
            String pattern = this.brokerProps.getProperty(FileHandler.class.getName() + ".pattern");
            File logFile = this.generate(pattern, 0, -1);
            return logFile;
        }
        catch (IOException e) {
            throw new MBeanException(e);
        }
    }

    private File generate(String pattern, int generation, int unique) throws IOException {
        File file = null;
        Object word = "";
        int ix = 0;
        boolean sawu = false;
        while (ix < pattern.length()) {
            char ch = pattern.charAt(ix);
            char ch2 = '\u0000';
            if (++ix < pattern.length()) {
                ch2 = Character.toLowerCase(pattern.charAt(ix));
            }
            if (ch == '/') {
                file = file == null ? new File((String)word) : new File(file, (String)word);
                word = "";
                continue;
            }
            if (ch == '%') {
                if (ch2 == 't') {
                    String tmpDir = System.getProperty("java.io.tmpdir");
                    if (tmpDir == null) {
                        tmpDir = System.getProperty("user.home");
                    }
                    file = new File(tmpDir);
                    ++ix;
                    word = "";
                    continue;
                }
                if (ch2 == 'h') {
                    file = new File(System.getProperty("user.home"));
                    if (LogConfig.isSetUID()) {
                        throw new IOException("can't use %h in set UID program");
                    }
                    ++ix;
                    word = "";
                    continue;
                }
                if (ch2 == 'g') {
                    word = (String)word + generation;
                    ++ix;
                    continue;
                }
                if (ch2 == 'u') {
                    word = (String)word + unique;
                    sawu = true;
                    ++ix;
                    continue;
                }
                if (ch2 == '%') {
                    word = (String)word + "%";
                    ++ix;
                    continue;
                }
            }
            word = (String)word + ch;
        }
        if (unique > 0 && !sawu) {
            word = (String)word + "." + unique;
        }
        if (((String)word).length() > 0) {
            file = file == null ? new File((String)word) : new File(file, (String)word);
        }
        return file;
    }

    private static native boolean isSetUID();

    static {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[5];
        mBeanAttributeInfoArray[0] = new MBeanAttributeInfo("Level", String.class.getName(), mbr.getString("MB1136"), true, true, false);
        mBeanAttributeInfoArray[1] = new MBeanAttributeInfo("RolloverBytes", Long.class.getName(), mbr.getString("MB1137"), true, true, false);
        mBeanAttributeInfoArray[2] = new MBeanAttributeInfo("RolloverSecs", Long.class.getName(), mbr.getString("MB1138"), true, true, false);
        mBeanAttributeInfoArray[3] = new MBeanAttributeInfo("LogDirectory", String.class.getName(), mbr.getString("MB1274"), true, false, false);
        mBeanAttributeInfoArray[4] = new MBeanAttributeInfo("LogFileName", String.class.getName(), mbr.getString("MB1275"), true, false, false);
        attrs = mBeanAttributeInfoArray;
        attrChangeTypes = new String[]{"jmx.attribute.change"};
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[1];
        mBeanNotificationInfoArray[0] = new MBeanNotificationInfo(attrChangeTypes, AttributeChangeNotification.class.getName(), mbr.getString("MB1025"));
        notifs = mBeanNotificationInfoArray;
    }
}

