/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusterBroadcast;
import com.sun.messaging.jmq.jmsserver.cluster.api.FileTransferCallback;
import com.sun.messaging.jmq.jmsserver.cluster.router.ClusterRouter;
import com.sun.messaging.jmq.jmsserver.cluster.router.MultibrokerRouter;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.BrokerMQAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.multibroker.ChangeRecord;
import com.sun.messaging.jmq.jmsserver.multibroker.ChangeRecordCallback;
import com.sun.messaging.jmq.jmsserver.multibroker.Cluster;
import com.sun.messaging.jmq.jmsserver.multibroker.ClusterGlobals;
import com.sun.messaging.jmq.jmsserver.multibroker.CommonProtocol;
import com.sun.messaging.jmq.jmsserver.multibroker.MessageBusCallback;
import com.sun.messaging.jmq.jmsserver.multibroker.Protocol;
import com.sun.messaging.jmq.jmsserver.multibroker.standalone.ClusterImpl;
import com.sun.messaging.jmq.jmsserver.persist.api.ChangeRecordInfo;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.service.ServiceManager;
import com.sun.messaging.jmq.jmsserver.service.ServiceRestriction;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import org.jvnet.hk2.annotations.Service;

@Service(name="com.sun.messaging.jmq.jmsserver.multibroker.ClusterBroadcaster")
@Singleton
public class ClusterBroadcaster
implements ClusterBroadcast,
MessageBusCallback,
ChangeRecordCallback {
    private static boolean DEBUG_CLUSTER_TXN = Globals.getConfig().getBooleanProperty("imq.cluster.debug.txn");
    private static boolean DEBUG = false;
    Logger logger = Globals.getLogger();
    BrokerConfig config = Globals.getConfig();
    BrokerResources br = Globals.getBrokerResources();
    private BrokerAddress selfAddress = null;
    private Cluster c = null;
    private Protocol protocol = null;
    private ChangeRecordInfo lastSyncedChangeRecord = null;
    private ChangeRecordInfo lastStoredChangeRecord = null;
    private Map<BrokerAddress, ChangeRecordInfo> lastReceivedChangeRecord = Collections.synchronizedMap(new HashMap());
    private ClusterRouter clusterRouter = null;
    private DestinationList DL = Globals.getDestinationList();

    public ClusterBroadcaster() {
    }

    public ClusterBroadcaster(Integer version) throws BrokerException {
        this((int)version);
    }

    public ClusterBroadcaster(int version) throws BrokerException {
        this.init(version);
    }

    @Override
    public void init(int version) throws BrokerException {
        String driver = this.config.getProperty("imq.topology");
        if (driver == null) {
            driver = "fullyconnected";
        }
        if (driver.equals("fullyconnected")) {
            this.c = new com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.ClusterImpl();
            this.logger.log(8, "B1041");
        } else {
            driver = "standalone";
        }
        if (driver.equals("standalone")) {
            this.c = new ClusterImpl();
            this.logger.log(8, "B1042");
        }
        this.selfAddress = this.c.getSelfAddress();
        this.protocol = new CommonProtocol(this, this.c, this.selfAddress);
        if (version != this.protocol.getHighestSupportedVersion()) {
            throw new BrokerException("The version " + version + " is not supported by the ClusterBroadcaster");
        }
        this.c.setCallback(this.protocol);
        this.clusterRouter = new MultibrokerRouter(this);
    }

    @Override
    public Object getProtocol() {
        return this.protocol;
    }

    @Override
    public int getClusterVersion() throws BrokerException {
        return this.protocol.getClusterVersion();
    }

    @Override
    public void startClusterIO() {
        this.protocol.startClusterIO();
    }

    @Override
    public void stopClusterIO(boolean requestTakeover, boolean force, BrokerAddress excludedBroker) {
        this.protocol.stopClusterIO(requestTakeover, force, excludedBroker);
        this.clusterRouter.shutdown();
    }

    @Override
    public Hashtable getAllDebugState() {
        Hashtable<String, Hashtable> ht = new Hashtable<String, Hashtable>();
        if (this.c != null) {
            ht.put("CLUSTER", this.c.getDebugState());
        }
        if (this.protocol != null) {
            ht.put("PROTOCOL", this.protocol.getDebugState());
        }
        ht.put("CLUSTER_ROUTER", this.clusterRouter.getDebugState());
        return ht;
    }

    @Override
    public void reloadCluster() {
        this.protocol.reloadCluster();
    }

    @Override
    public void pauseMessageFlow() throws IOException {
        this.protocol.stopMessageFlow();
    }

    @Override
    public void resumeMessageFlow() throws IOException {
        this.protocol.resumeMessageFlow();
    }

    @Override
    public void setMatchProps(Properties matchProps) {
        this.protocol.setMatchProps(matchProps);
    }

    @Override
    public boolean waitForConfigSync() {
        return this.protocol.waitForConfigSync();
    }

    @Override
    public BrokerAddress getMyAddress() {
        return this.selfAddress;
    }

    @Override
    public boolean lockSharedResource(String resource, Object owner) {
        if (DEBUG) {
            this.logger.log(8, "lockSharedResource : " + resource);
        }
        return this.protocol.lockSharedResource(resource, owner) == 0;
    }

    @Override
    public boolean lockExclusiveResource(String resource, Object owner) {
        if (DEBUG) {
            this.logger.log(8, "lockExclusiveResource " + resource);
        }
        return this.protocol.lockResource(resource, 0L, owner) == 0;
    }

    @Override
    public void unlockExclusiveResource(String resource, Object owner) {
        if (DEBUG) {
            this.logger.log(8, "unlockExclusiveResource " + resource);
        }
        this.protocol.unlockResource(resource);
    }

    @Override
    public boolean lockDestination(DestinationUID uid, Object owner) {
        if (DEBUG) {
            this.logger.log(8, "lockDestination " + uid);
        }
        return this.protocol.lockResource("destCreate:" + uid.toString(), 0L, owner) == 0;
    }

    @Override
    public void unlockDestination(DestinationUID uid, Object owner) {
        if (DEBUG) {
            this.logger.log(8, "unlockDestination " + uid);
        }
        this.protocol.unlockResource("destCreate:" + uid.toString());
    }

    @Override
    public int lockClientID(String clientid, Object owner, boolean shared) {
        if (DEBUG) {
            this.logger.log(8, "lockClientID " + clientid);
        }
        int status = 1;
        status = shared ? this.protocol.lockSharedResource("clientid:" + clientid, owner) : this.protocol.lockResource("clientid:" + clientid, 0L, owner);
        return this.convertToLocalLockRequestStatus(status);
    }

    @Override
    public void unlockClientID(String clientid, Object owner) {
        if (DEBUG) {
            this.logger.log(8, "unlockClientID " + clientid);
        }
        this.protocol.unlockResource("clientid:" + clientid);
    }

    @Override
    public boolean getConsumerLock(ConsumerUID uid, DestinationUID duid, int position, int maxActive, Object owner) throws BrokerException {
        if (DEBUG) {
            this.logger.log(8, "getConsumerLock " + uid);
        }
        if (maxActive > 1 && (this.c.getConfigServer() == null || this.c.getConfigServer() != null && !Globals.nowaitForMasterBroker()) && this.protocol.getClusterVersion() < 350) {
            throw new BrokerException("Feature not support in this cluster protocol");
        }
        return this.protocol.lockResource("queue:" + duid.getName() + "_" + position, 0L, owner) == 0;
    }

    @Override
    public void unlockConsumer(ConsumerUID uid, DestinationUID duid, int position) {
        if (DEBUG) {
            this.logger.log(8, "unlockConsumer " + uid);
        }
        this.protocol.unlockResource("queue:" + duid.getName() + "_" + position);
    }

    private int convertToLocalLockRequestStatus(int status) {
        switch (status) {
            case -1: {
                return -1;
            }
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        this.logger.log(16, "B3100", (Object)("Unexpected cluster lock request status: " + status));
        return 1;
    }

    private int convertToClusterAckType(int type) {
        switch (type) {
            case 0: {
                return 2;
            }
            case 1: {
                return 3;
            }
            case 5: {
                return 1;
            }
            case 6: {
                return 4;
            }
            case 7: {
                return 5;
            }
            case 8: {
                return 9;
            }
            case 9: {
                return 10;
            }
            case 2: {
                return 6;
            }
            case 3: {
                return 7;
            }
            case 4: {
                return 8;
            }
        }
        return 0;
    }

    private int convertToLocalAckType(int type) {
        switch (type) {
            case 2: {
                return 0;
            }
            case 3: {
                return 1;
            }
            case 1: {
                return 5;
            }
            case 4: {
                return 6;
            }
            case 5: {
                return 7;
            }
            case 9: {
                return 8;
            }
            case 10: {
                return 9;
            }
            case 6: {
                return 2;
            }
            case 7: {
                return 3;
            }
            case 8: {
                return 4;
            }
        }
        return -1;
    }

    @Override
    public void acknowledgeMessage(BrokerAddress address, SysMessageID sysid, ConsumerUID cuid, int ackType, Map optionalProps, boolean ackack) throws BrokerException {
        if (address == null || address == this.selfAddress) {
            this.logger.log(32, "B3100", (Object)("Invalid broker address " + address + " in acknowledge message " + sysid + " [CID=" + cuid + ", ackType=" + ClusterGlobals.getAckTypeString(this.convertToClusterAckType(ackType)) + "]"));
            return;
        }
        this.protocol.sendMessageAck(address, sysid, cuid, this.convertToClusterAckType(ackType), optionalProps, ackack);
    }

    @Override
    public void acknowledgeMessage2P(BrokerAddress address, SysMessageID[] sysids, ConsumerUID[] cuids, int ackType, Map optionalProps, Long txnID, UID txnStoreSession, boolean ackack, boolean async) throws BrokerException {
        if (address == null || address == this.selfAddress && (!Globals.getHAEnabled() || txnID == null)) {
            this.logger.log(32, "B3100", (Object)("Invalid broker address " + address + " in acknowledge message " + Arrays.toString(sysids) + " [CID=" + Arrays.toString(cuids) + ", ackType=" + ClusterGlobals.getAckTypeString(this.convertToClusterAckType(ackType)) + ", TID=" + txnID + "]"));
            throw new BrokerException(Globals.getBrokerResources().getKString("B3100", "Invalid broker address " + address), 500);
        }
        if (Globals.getHAEnabled() && address == this.selfAddress && DEBUG_CLUSTER_TXN) {
            this.logger.log(8, "Acknowledge (" + ClusterGlobals.getAckTypeString(this.convertToClusterAckType(ackType)) + ") to my address for transaction " + txnID);
        }
        this.protocol.sendMessageAck2P(address, sysids, cuids, this.convertToClusterAckType(ackType), optionalProps, txnID, txnStoreSession, ackack, async);
    }

    @Override
    public void recordUpdateDestination(Destination dest) throws BrokerException {
        if (DEBUG) {
            this.logger.log(8, "recordUpdateDestination : " + dest);
        }
        if (Globals.useSharedConfigRecord()) {
            ChangeRecord.recordUpdateDestination(dest, this);
            return;
        }
        this.protocol.recordUpdateDestination(dest);
    }

    @Override
    public void recordRemoveDestination(Destination dest) throws BrokerException {
        if (DEBUG) {
            this.logger.log(8, "recordRemoveDestination : " + dest);
        }
        if (Globals.useSharedConfigRecord()) {
            ChangeRecord.recordRemoveDestination(dest, this);
            return;
        }
        this.protocol.recordRemoveDestination(dest);
    }

    @Override
    public void createDestination(Destination dest) throws BrokerException {
        if (DEBUG) {
            this.logger.log(8, "createDestination " + dest);
        }
        this.protocol.sendNewDestination(dest);
    }

    @Override
    public void recordCreateSubscription(Subscription sub) throws BrokerException {
        if (DEBUG) {
            this.logger.log(8, "recordCreateSubscription " + sub);
        }
        if (Globals.useSharedConfigRecord()) {
            ChangeRecord.recordCreateSubscription(sub, this);
            return;
        }
        this.protocol.recordCreateSubscription(sub);
    }

    @Override
    public void recordUnsubscribe(Subscription sub) throws BrokerException {
        if (DEBUG) {
            this.logger.log(8, "recordUnsubscribe " + sub);
        }
        if (Globals.useSharedConfigRecord()) {
            ChangeRecord.recordUnsubscribe(sub, this);
            return;
        }
        this.protocol.recordUnsubscribe(sub);
    }

    @Override
    public void createSubscription(Subscription sub, Consumer cons) throws BrokerException {
        if (DEBUG) {
            this.logger.log(8, "createSubscription " + sub);
        }
        this.protocol.sendNewSubscription(sub, cons, false);
    }

    @Override
    public void createConsumer(Consumer con) throws BrokerException {
        if (DEBUG) {
            this.logger.log(8, "createConsumer " + con);
        }
        this.protocol.sendNewConsumer(con, true);
    }

    @Override
    public void updateDestination(Destination dest) throws BrokerException {
        if (DEBUG) {
            this.logger.log(8, "updateDestination " + dest);
        }
        this.protocol.sendUpdateDestination(dest);
    }

    @Override
    public void updateSubscription(Subscription sub) throws BrokerException {
    }

    @Override
    public void updateConsumer(Consumer con) throws BrokerException {
    }

    @Override
    public void destroyDestination(Destination dest) throws BrokerException {
        if (DEBUG) {
            this.logger.log(8, "destroyDestination " + dest);
        }
        this.protocol.sendRemovedDestination(dest);
    }

    @Override
    public void destroyConsumer(Consumer con, Map pendingMsgs, boolean cleanup) throws BrokerException {
        if (DEBUG) {
            this.logger.log(8, "destroyConsumer " + con + ", pendingMsgs=" + pendingMsgs + ", cleanup=" + cleanup);
        }
        this.protocol.sendRemovedConsumer(con, pendingMsgs, cleanup);
    }

    @Override
    public void connectionClosed(ConnectionUID uid, boolean admin) {
        if (DEBUG) {
            this.logger.log(8, "connectionClosed " + uid);
        }
        if (!admin) {
            this.protocol.clientClosed(uid, true);
        }
    }

    @Override
    public void messageDelivered(SysMessageID id, ConsumerUID uid, BrokerAddress address) {
        if (DEBUG) {
            this.logger.log(8, "messageDelivered - XXX not implemented");
        }
    }

    @Override
    public void forwardMessage(PacketReference ref, Collection consumers) {
        this.clusterRouter.forwardMessage(ref, consumers);
    }

    @Override
    public boolean lockUIDPrefix(short p) {
        if (DEBUG) {
            this.logger.log(8, "lockUIDPrefix " + p);
        }
        return this.protocol.lockResource("uidprefix:" + Short.toString(p), 0L, (Object)new ConnectionUID(0L)) == 0;
    }

    @Override
    public void preTakeover(String brokerID, UID storeSession, String brokerHost, UID brokerSession) throws BrokerException {
        this.protocol.preTakeover(brokerID, storeSession, brokerHost, brokerSession);
    }

    @Override
    public void postTakeover(String brokerID, UID storeSession, boolean aborted, boolean notify) {
        this.protocol.postTakeover(brokerID, storeSession, aborted, notify);
    }

    @Override
    public void configSyncComplete() {
        Random r = new Random();
        boolean uidInit = false;
        for (int i = 0; i < 5; ++i) {
            short p = (short)r.nextInt(Short.MAX_VALUE);
            if (!this.lockUIDPrefix(p)) continue;
            UID.setPrefix((short)p);
            uidInit = true;
            break;
        }
        if (!uidInit) {
            this.logger.log(16, Globals.getBrokerResources().getKString("B2220"));
        }
        ServiceManager sm = Globals.getServiceManager();
        try {
            if (Globals.nowaitForMasterBroker()) {
                this.logger.log(8, Globals.getBrokerResources().getKString("B1263"));
                sm.removeServiceRestriction(0, ServiceRestriction.NO_SYNC_WITH_MASTERBROKER);
            } else {
                sm.resumeAllActiveServices(0, true);
            }
        }
        catch (Exception e) {
            this.logger.logStack(32, "B3100", (Object)"during broker initialization", (Throwable)e);
        }
    }

    @Override
    public void interestCreated(Consumer intr) {
        try {
            this.clusterRouter.addConsumer(intr);
        }
        catch (Exception ex) {
            this.logger.log(8, this.br.getKString("B2232", "" + ex, "" + intr));
        }
    }

    @Override
    public void unsubscribe(Subscription sub) {
        if (DEBUG) {
            this.logger.log(4, "callback unsubscribe : " + sub);
        }
        assert (sub != null);
        try {
            Subscription.remoteUnsubscribe(sub.getDurableName(), sub.getClientID());
        }
        catch (Exception ex) {
            int loglevel = 32;
            if (ex instanceof BrokerException && (((BrokerException)ex).getStatusCode() == 412 || ((BrokerException)ex).getStatusCode() == 404)) {
                loglevel = 16;
            }
            Object[] args = new String[]{Subscription.getDSubLogString(sub.getClientID(), sub.getDurableName()), ex.getMessage()};
            String emsg = this.br.getKString("B3165", args);
            if (loglevel == 32 || DEBUG) {
                this.logger.logStack(loglevel, emsg, (Throwable)ex);
            }
            this.logger.log(loglevel, emsg);
        }
    }

    @Override
    public void interestRemoved(Consumer cuid, Map<TransactionUID, LinkedHashMap<SysMessageID, Integer>> pendingMsgs, boolean cleanup) {
        if (DEBUG) {
            this.logger.log(8, "callback interestRemoved " + cuid + ", pendingMsgs=" + pendingMsgs + ", cleanup=" + cleanup);
        }
        try {
            this.clusterRouter.removeConsumer(cuid.getConsumerUID(), pendingMsgs, cleanup);
        }
        catch (Exception ex) {
            this.logger.logStack(32, "Unable to remove remote consumer " + cuid, (Throwable)ex);
        }
    }

    @Override
    public void activeStateChanged(Consumer intr) {
        if (DEBUG) {
            this.logger.log(8, "callback activeStateChanged " + intr);
        }
    }

    @Override
    public void clientDown(ConnectionUID conid) {
        if (DEBUG) {
            this.logger.log(8, "clientDown " + conid);
        }
        try {
            this.clusterRouter.removeConsumers(conid);
        }
        catch (Exception ex) {
            this.logger.logStack(16, "Unable to remove remote consumers " + conid, (Throwable)ex);
        }
    }

    @Override
    public void brokerDown(BrokerAddress broker) {
        if (DEBUG) {
            this.logger.log(8, "brokerDown " + broker);
        }
        try {
            this.clusterRouter.brokerDown(broker);
        }
        catch (Exception ex) {
            this.logger.logStack(8, "unable to remove remote consumers " + broker, (Throwable)ex);
        }
    }

    @Override
    public void notifyCreateDestination(Destination d) {
        try {
            DestinationList.addDestination(null, d, true);
            d.store();
        }
        catch (Exception ex) {
            this.logger.log(4, "Received exception adding new destination is caused because the destination " + d + " is being autocreated on both sides", (Throwable)ex);
        }
    }

    @Override
    public void notifyDestroyDestination(DestinationUID uid) {
        try {
            DestinationList.removeDestination(null, uid, false, Globals.getBrokerResources().getString("B0071"));
        }
        catch (Exception ex) {
            this.logger.log(4, "Unable to remove stored destination " + uid, (Throwable)ex);
        }
    }

    @Override
    public void notifyUpdateDestination(DestinationUID uid, Map changes) {
        Destination[] ds = DestinationList.getDestination(null, uid);
        Destination d = ds[0];
        if (d != null) {
            try {
                d.setDestinationProperties(changes);
            }
            catch (Exception ex) {
                this.logger.logStack(16, "Unable to update destination " + uid.toString(), (Throwable)ex);
            }
        }
    }

    @Override
    public void processRemoteMessage(Packet msg, Map<ConsumerUID, Integer> consumers, BrokerAddress home, boolean sendMsgRedeliver) throws BrokerException {
        this.clusterRouter.handleJMSMsg(msg, consumers, home, sendMsgRedeliver);
    }

    @Override
    public void processRemoteAck(SysMessageID sysid, ConsumerUID cuid, int ackType, Map optionalProps) throws BrokerException {
        if (DEBUG) {
            this.logger.log(8, "processRemoteAck: " + sysid + ":" + cuid + ", ackType=" + ClusterGlobals.getAckTypeString(ackType));
        }
        this.clusterRouter.handleAck(this.convertToLocalAckType(ackType), sysid, cuid, optionalProps);
    }

    @Override
    public void processRemoteAck2P(SysMessageID[] sysids, ConsumerUID[] cuids, int ackType, Map optionalProps, Long txnID, BrokerAddress txnHomeBroker) throws BrokerException {
        if (DEBUG) {
            this.logger.log(8, "processRemoteAck2P: " + sysids[0] + ":" + cuids[0] + ", ackType=" + ClusterGlobals.getAckTypeString(ackType) + ",from " + txnHomeBroker);
        }
        this.clusterRouter.handleAck2P(this.convertToLocalAckType(ackType), sysids, cuids, optionalProps, txnID, txnHomeBroker);
    }

    @Override
    public void sendClusterTransactionInfo(long tid, BrokerAddress to) {
        this.protocol.sendClusterTransactionInfo(tid, to);
    }

    @Override
    public BrokerAddress lookupBrokerAddress(String brokerid) {
        return this.protocol.lookupBrokerAddress(brokerid);
    }

    @Override
    public BrokerAddress lookupBrokerAddress(BrokerMQAddress mqaddr) {
        return this.protocol.lookupBrokerAddress(mqaddr);
    }

    @Override
    public String lookupStoreSessionOwner(UID session) {
        return this.protocol.lookupStoreSessionOwner(session);
    }

    @Override
    public void syncChangeRecordOnStartup() throws BrokerException {
        ChangeRecord.storeResetRecordIfNecessary(this);
        ChangeRecord.syncChangeRecord(this, this, ((CommonProtocol)this.protocol).getRealProtocol(), true);
    }

    @Override
    public void syncChangeRecordOnJoin(BrokerAddress remote, ChangeRecordInfo cri) throws BrokerException {
        String resetUUID = null;
        if (this.lastSyncedChangeRecord != null) {
            resetUUID = this.lastSyncedChangeRecord.getResetUUID();
        }
        if (resetUUID == null) {
            String string = resetUUID = this.lastStoredChangeRecord == null ? null : this.lastStoredChangeRecord.getResetUUID();
        }
        if (resetUUID != null && !resetUUID.equals(cri.getResetUUID())) {
            throw new BrokerException(this.br.getKString("B4322", "[" + resetUUID + ", " + cri.getResetUUID() + "]", remote.toString()), 412);
        }
        ChangeRecordInfo lastr = this.lastReceivedChangeRecord.get(remote);
        if (!(lastr != null && lastr.getSeq() >= cri.getSeq() && lastr.getResetUUID().equals(cri.getResetUUID()) || this.lastSyncedChangeRecord != null && this.lastSyncedChangeRecord.getSeq() >= cri.getSeq())) {
            this.logger.log(8, this.br.getKString("B1367", remote + "[" + cri + "]"));
            ChangeRecord.syncChangeRecord(this, this, ((CommonProtocol)this.protocol).getRealProtocol(), false);
        }
    }

    @Override
    public void setLastSyncedChangeRecord(ChangeRecordInfo rec) {
        this.lastSyncedChangeRecord = rec;
    }

    @Override
    public ChangeRecordInfo getLastSyncedChangeRecord() {
        return this.lastSyncedChangeRecord;
    }

    @Override
    public ChangeRecordInfo getLastStoredChangeRecord() {
        return this.lastStoredChangeRecord;
    }

    @Override
    public void setLastStoredChangeRecord(ChangeRecordInfo rec) {
        this.lastStoredChangeRecord = rec;
    }

    @Override
    public void setLastReceivedChangeRecord(BrokerAddress remote, ChangeRecordInfo rec) {
        this.lastReceivedChangeRecord.put(remote, rec);
    }

    @Override
    public void changeMasterBroker(BrokerMQAddress newmaster, BrokerMQAddress oldmaster) throws BrokerException {
        if (DEBUG) {
            this.logger.log(8, "changeMasterBroker from " + oldmaster + " to " + newmaster);
        }
        this.protocol.changeMasterBroker(newmaster, oldmaster);
    }

    @Override
    public String sendTakeoverMEPrepare(String brokerID, byte[] token, Long syncTimeout, String uuid) throws BrokerException {
        if (DEBUG) {
            this.logger.log(8, "sendTakeoverMEPrepare to " + brokerID);
        }
        return this.protocol.sendTakeoverMEPrepare(brokerID, token, syncTimeout, uuid);
    }

    @Override
    public String sendTakeoverME(String brokerID, String uuid) throws BrokerException {
        if (DEBUG) {
            this.logger.log(8, "sendTakeoverME to " + brokerID);
        }
        return this.protocol.sendTakeoverME(brokerID, uuid);
    }

    @Override
    public void sendMigrateStoreRequest(String targetBrokerID, Long syncTimeout, String uuid, String myBrokerID) throws BrokerException {
        if (DEBUG) {
            this.logger.log(8, "sendMigrateStoreRequest to " + targetBrokerID);
        }
        this.protocol.sendMigrateStoreRequest(targetBrokerID, syncTimeout, uuid, myBrokerID);
    }

    @Override
    public void transferFiles(String[] fileNames, String targetBrokerID, Long syncTimeout, String uuid, String myBrokerID, String module, FileTransferCallback callback) throws BrokerException {
        if (DEBUG) {
            this.logger.log(8, "transferFiles to " + targetBrokerID);
        }
        this.protocol.transferFiles(fileNames, targetBrokerID, syncTimeout, uuid, myBrokerID, module, callback);
    }

    @Override
    public void notifyPartitionArrival(UID partitionID, String brokerID) throws BrokerException {
        if (DEBUG) {
            this.logger.log(8, "notifyPartitionArrival(" + partitionID + ", " + brokerID + ")");
        }
        this.protocol.notifyPartitionArrival(partitionID, brokerID);
    }
}

