/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.jmsserver.core.Subscription;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Iterator;

class SubscriptionIterator
implements Iterator {
    private int count = 0;
    private int count_read = 0;
    private DataInputStream dis = null;

    SubscriptionIterator(byte[] payload, int count) {
        ByteArrayInputStream bis = new ByteArrayInputStream(payload);
        this.dis = new DataInputStream(bis);
        this.count = count;
        this.count_read = 0;
    }

    @Override
    public boolean hasNext() {
        if (this.count_read < 0) {
            throw new IllegalStateException("SubscriptionIterator");
        }
        return this.count_read < this.count;
    }

    public Object next() throws RuntimeException {
        try {
            String dname = this.dis.readUTF();
            String clientID = this.dis.readUTF();
            if (clientID.length() == 0) {
                clientID = null;
            }
            Subscription sub = Subscription.findDurableSubscription(clientID, dname);
            ++this.count_read;
            return sub;
        }
        catch (IOException e) {
            this.count_read = -1;
            throw new RuntimeException(e);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported");
    }
}

