/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.ConnectionManager;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.MQThread;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class ConsumerInfoNotifyManager
implements Runnable {
    private static final int CONSUMER_NOT_READY = 0;
    private static final int CONSUMER_READY = 1;
    private static final int CONSUMER_ALL_EVENT = -1;
    private static boolean DEBUG = false;
    private Logger logger = Globals.getLogger();
    private MQThread notifyThread = null;
    private Vector eventQueue = new Vector();
    private ConnectionManager cm = null;
    private boolean shutdown = false;
    private boolean requested = false;

    public ConsumerInfoNotifyManager(ConnectionManager cm) {
        this.cm = cm;
        if (Globals.getLogger().getLevel() <= 4) {
            DEBUG = true;
        }
    }

    private synchronized void wakeup() {
        this.createNotifyThread();
        this.notifyAll();
    }

    private void createNotifyThread() {
        if (this.notifyThread == null) {
            this.notifyThread = new MQThread((Runnable)this, "ConsumerInfoNotifyManager");
            this.notifyThread.setDaemon(true);
            this.notifyThread.start();
        }
    }

    protected synchronized void shutdown() {
        this.shutdown = true;
        this.eventQueue.clear();
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        pendingEvents = new ArrayList<Object>();
        while (!this.shutdown) {
            dowait = true;
            list = null;
            var4_4 = this.eventQueue;
            synchronized (var4_4) {
                list = new ArrayList<E>(this.eventQueue);
            }
            if (list.size() > 0 && pendingEvents.size() > 0) {
                itr = list.iterator();
                e = null;
                while (itr.hasNext()) {
                    e = itr.next();
                    if (pendingEvents.contains(e)) continue;
                    dowait = false;
                    break;
                }
            } else if (pendingEvents.size() == 0) {
                dowait = this.eventQueue.isEmpty();
            }
            itr = this;
            synchronized (itr) {
                if (dowait || this.eventQueue.isEmpty()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
            if (this.shutdown) {
                return;
            }
            notifications = new HashMap<DestinationUID, ConsumerInfoNotification>();
            events = this.eventQueue.toArray();
            o = null;
            for (i = 0; i < events.length && !this.shutdown; ++i) {
                block35: {
                    o = events[i];
                    if (ConsumerInfoNotifyManager.DEBUG) {
                        this.logger.log(8, "Processing " + o);
                    }
                    if (!(o instanceof ConsumerAddedEvent)) break block35;
                    e = (ConsumerAddedEvent)o;
                    conn = (IMQConnection)this.cm.getConnection(e.connid);
                    if (e.dest.getAllActiveConsumerCount() <= 0) ** GOTO lbl57
                    if (conn == null || conn.isConnectionStarted()) {
                        notifications.put(e.dest.getDestinationUID(), new ConsumerInfoNotification(e.dest.getDestinationUID(), e.dest.getType(), 1));
                    } else {
                        pendingEvents.add(o);
                        continue;
lbl57:
                        // 1 sources

                        notifications.put(e.dest.getDestinationUID(), new ConsumerInfoNotification(e.dest.getDestinationUID(), e.dest.getType(), 0));
                    }
                    this.eventQueue.remove(o);
                    pendingEvents.remove(o);
                    continue;
                }
                if (o instanceof RemoteConsumerAddedEvent) {
                    e = (RemoteConsumerAddedEvent)o;
                    if (e.dest.getAllActiveConsumerCount() > 0) {
                        notifications.put(e.dest.getDestinationUID(), new ConsumerInfoNotification(e.dest.getDestinationUID(), e.dest.getType(), 1));
                    } else {
                        notifications.put(e.dest.getDestinationUID(), new ConsumerInfoNotification(e.dest.getDestinationUID(), e.dest.getType(), 0));
                    }
                    this.eventQueue.remove(o);
                    continue;
                }
                if (o instanceof ConsumerRemovedEvent) {
                    e = (ConsumerRemovedEvent)o;
                    if (e.dest.getAllActiveConsumerCount() == 0) {
                        notifications.put(e.dest.getDestinationUID(), new ConsumerInfoNotification(e.dest.getDestinationUID(), e.dest.getType(), 0));
                    }
                    this.eventQueue.remove(o);
                    continue;
                }
                if (o instanceof ConnectionStartedEvent) {
                    e = (ConnectionStartedEvent)o;
                    for (j = 0; j < events.length && !this.shutdown; ++j) {
                        oo = events[j];
                        if (!(oo instanceof ConsumerAddedEvent)) continue;
                        ee = (ConsumerAddedEvent)oo;
                        conn = (IMQConnection)this.cm.getConnection(ee.connid);
                        if (conn == null || conn != e.conn || ee.dest.getAllActiveConsumerCount() <= 0) continue;
                        notifications.put(ee.dest.getDestinationUID(), new ConsumerInfoNotification(ee.dest.getDestinationUID(), ee.dest.getType(), 1));
                        pendingEvents.remove(ee);
                    }
                    this.eventQueue.remove(e);
                    continue;
                }
                if (!(o instanceof ConsumerInfoRequestEvent)) continue;
                foundmatch = false;
                hasconsumer = false;
                notifyadded = false;
                e = (ConsumerInfoRequestEvent)o;
                itrs = DestinationList.getAllDestinations(null);
                itr = itrs[0];
                block12: while (itr.hasNext()) {
                    d = (Destination)itr.next();
                    if (d.isInternal()) continue;
                    if (!e.duid.isWildcard() && d.getDestinationUID().equals(e.duid)) {
                        foundmatch = true;
                        if (d.getAllActiveConsumerCount() == 0) {
                            notifications.put(d.getDestinationUID(), new ConsumerInfoNotification(d.getDestinationUID(), d.getType(), 0, ((ConsumerInfoRequestEvent)o).infoType, true));
                            notifyadded = true;
                            break;
                        }
                        hasconsumer = true;
                        for (Consumer c : d.getAllActiveConsumers()) {
                            conn = (IMQConnection)this.cm.getConnection(c.getConnectionUID());
                            ba = c.getConsumerUID().getBrokerAddress();
                            if ((conn == null || !conn.isConnectionStarted()) && (ba == null || ba == Globals.getMyAddress())) continue;
                            notifications.put(d.getDestinationUID(), new ConsumerInfoNotification(d.getDestinationUID(), d.getType(), 1, ((ConsumerInfoRequestEvent)o).infoType, true));
                            notifyadded = true;
                            break block12;
                        }
                        break;
                    }
                    if (!e.duid.isWildcard() || !DestinationUID.match(d.getDestinationUID(), e.duid)) continue;
                    foundmatch = true;
                    if (d.getAllActiveConsumerCount() == 0) continue;
                    hasconsumer = true;
                    for (Consumer c : d.getAllActiveConsumers()) {
                        conn = (IMQConnection)this.cm.getConnection(c.getConnectionUID());
                        ba = c.getConsumerUID().getBrokerAddress();
                        if ((conn == null || !conn.isConnectionStarted()) && (ba == null || ba == Globals.getMyAddress())) continue;
                        notifications.put(d.getDestinationUID(), new ConsumerInfoNotification(d.getDestinationUID(), e.destType, 1, ((ConsumerInfoRequestEvent)o).infoType, true));
                        notifyadded = true;
                        break;
                    }
                    if (!notifyadded) continue;
                    break;
                }
                if (!foundmatch || !hasconsumer && !notifyadded) {
                    notifications.put(e.duid, new ConsumerInfoNotification(e.duid, e.destType, 0, ((ConsumerInfoRequestEvent)o).infoType, true));
                }
                this.eventQueue.remove(o);
            }
            itr = notifications.values().iterator();
            cin = null;
            while (itr.hasNext()) {
                cin = (ConsumerInfoNotification)itr.next();
                if (ConsumerInfoNotifyManager.DEBUG) {
                    this.logger.log(8, "Sending " + cin);
                }
                if (!cin.shouldNotify()) continue;
                this.cm.sendConsumerInfo(3, cin.duid, cin.destType, cin.infoType, cin.sendToWildcard);
            }
            notifications.clear();
        }
    }

    public void remoteConsumerAdded(Destination dest) {
        if (!this.requested) {
            return;
        }
        this.eventQueue.add(new RemoteConsumerAddedEvent(dest));
        this.wakeup();
    }

    public void consumerAdded(Destination dest, Connection conn) {
        if (!this.requested) {
            return;
        }
        this.eventQueue.add(new ConsumerAddedEvent(dest, conn == null ? null : conn.getConnectionUID()));
        this.wakeup();
    }

    public void consumerRemoved(Destination dest) {
        if (!this.requested) {
            return;
        }
        this.eventQueue.add(new ConsumerRemovedEvent(dest));
        this.wakeup();
    }

    public void connectionStarted(Connection conn) {
        if (!this.requested) {
            return;
        }
        this.eventQueue.add(new ConnectionStartedEvent(conn));
        this.wakeup();
    }

    public void consumerInfoRequested(Connection conn, DestinationUID duid, int destType) {
        this.consumerInfoRequested(conn, duid, destType, -1);
    }

    public void consumerInfoRequested(Connection conn, DestinationUID duid, int destType, int infoType) {
        this.requested = true;
        this.eventQueue.add(new ConsumerInfoRequestEvent(conn, duid, destType, infoType));
        this.wakeup();
    }

    protected static String toString(int infoType) {
        switch (infoType) {
            case 0: {
                return "CONSUMER_NOT_READY";
            }
            case 1: {
                return "CONSUMER_READY";
            }
            case -1: {
                return "CONSUMER_ALL_EVENT";
            }
        }
        return "UNKNOWN";
    }

    static class ConsumerInfoNotification {
        DestinationUID duid = null;
        int destType;
        int infoType;
        int requestInfoType = -1;
        boolean sendToWildcard = false;

        ConsumerInfoNotification(DestinationUID duid, int destType, int infoType) {
            this.duid = duid;
            this.destType = destType;
            this.infoType = infoType;
            if (infoType != 0) {
                this.sendToWildcard = true;
            }
        }

        ConsumerInfoNotification(DestinationUID duid, int destType, int infoType, int requestInfoType, boolean sendToWildcard) {
            this.duid = duid;
            this.destType = destType;
            this.infoType = infoType;
            this.requestInfoType = requestInfoType;
            this.sendToWildcard = sendToWildcard;
        }

        public boolean shouldNotify() {
            if (this.requestInfoType == -1) {
                return true;
            }
            return this.requestInfoType == this.infoType;
        }

        public String toString() {
            return "ConsumerInfoNotification: duid=" + this.duid + ", destType=" + DestType.toString((int)this.destType) + ", infoType=" + ConsumerInfoNotifyManager.toString(this.infoType);
        }
    }

    static class ConsumerInfoRequestEvent {
        Connection conn = null;
        DestinationUID duid = null;
        int destType;
        int infoType;

        ConsumerInfoRequestEvent(Connection conn, DestinationUID duid, int destType, int infoType) {
            this.conn = conn;
            this.duid = duid;
            this.destType = destType;
            this.infoType = infoType;
        }

        public String toString() {
            return "ConsumerInfoRequestEvent: conn=" + this.conn + ", duid=" + this.duid + ", destType=" + DestType.toString((int)this.destType) + ", infoType=" + ConsumerInfoNotifyManager.toString(this.infoType);
        }
    }

    static class ConnectionStartedEvent {
        Connection conn = null;

        ConnectionStartedEvent(Connection conn) {
            this.conn = conn;
        }

        public String toString() {
            return "ConnectionStartedEvent: conn=" + this.conn;
        }
    }

    static class ConsumerRemovedEvent {
        Destination dest = null;

        ConsumerRemovedEvent(Destination dest) {
            this.dest = dest;
        }

        public String toString() {
            return "ConsumerRemovedEvent: dest=" + this.dest;
        }
    }

    static class ConsumerAddedEvent {
        Destination dest = null;
        ConnectionUID connid = null;

        ConsumerAddedEvent(Destination dest, ConnectionUID connid) {
            this.dest = dest;
            this.connid = connid;
        }

        public String toString() {
            return "ConsumerAddedEvent: dest=" + this.dest + ", conn=" + this.connid;
        }
    }

    static class RemoteConsumerAddedEvent {
        Destination dest = null;

        RemoteConsumerAddedEvent(Destination dest) {
            this.dest = dest;
        }

        public String toString() {
            return "RemoteConsumerAddedEvent: dest=" + this.dest;
        }
    }
}

