/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.admin.report.XMLActionReporter;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.v3.admin.CommandRunnerImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.config.ApplicationName;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.InternalSystemAdministrator;
import org.glassfish.kernel.KernelLoggerInfo;

public class DynamicReloader
implements Runnable {
    private static final String RELOAD_FILE_NAME = ".reload";
    private static final String DEV_MODE = "devMode";
    private final SyncBoolean inProgress;
    private Map<String, AppReloadInfo> appReloadInfo;
    private final AtomicBoolean cancelRequested = new AtomicBoolean(false);
    private final Applications applications;
    private static final Logger logger = KernelLoggerInfo.getLogger();
    private final ServiceLocator habitat;
    private final Subject kernelSubject;
    private final Set<AppReloadInfo> failedReloads;

    DynamicReloader(Applications applications, ServiceLocator habitat) throws URISyntaxException {
        this.applications = applications;
        this.habitat = habitat;
        this.initAppReloadInfo(applications);
        this.inProgress = new SyncBoolean(false);
        InternalSystemAdministrator kernelIdentity = (InternalSystemAdministrator)habitat.getService(InternalSystemAdministrator.class, new Annotation[0]);
        this.kernelSubject = kernelIdentity.getSubject();
        this.failedReloads = new HashSet<AppReloadInfo>();
    }

    private synchronized void initAppReloadInfo(Applications applications) throws URISyntaxException {
        this.appReloadInfo = new HashMap<String, AppReloadInfo>();
        logger.fine("[Reloader] Preparing list of apps to monitor:");
        for (ApplicationName m : applications.getModules()) {
            Application app;
            if (!(m instanceof Application) || Boolean.parseBoolean((app = (Application)m).getDeployProperties().getProperty("isLifecycle"))) continue;
            AppReloadInfo info = new AppReloadInfo(app);
            this.appReloadInfo.put(app.getName(), info);
            logger.log(Level.FINE, "[Reloader] Monitoring {0} at {1}", new Object[]{app.getName(), app.getLocation()});
        }
    }

    @Override
    public void run() {
        this.markInProgress();
        try {
            this.reloadApps();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.clearInProgress();
        }
    }

    void cancel() {
        this.cancelRequested.set(true);
    }

    void init() {
        this.cancelRequested.set(false);
    }

    private void reloadApps() throws URISyntaxException, IOException {
        List<AppReloadInfo> appsToReload = this.chooseAppsToReload();
        for (AppReloadInfo appInfo : appsToReload) {
            if (this.cancelRequested.get()) break;
            this.reloadApp(appInfo);
        }
    }

    private synchronized List<AppReloadInfo> chooseAppsToReload() throws URISyntaxException {
        ArrayList<AppReloadInfo> result = new ArrayList<AppReloadInfo>();
        HashSet<AppReloadInfo> possiblyUndeployedApps = new HashSet<AppReloadInfo>(this.appReloadInfo.values());
        for (ApplicationName m : this.applications.getModules()) {
            Application app;
            if (!(m instanceof Application) || (app = (Application)m).getLocation() == null || Boolean.parseBoolean(app.getDeployProperties().getProperty("isLifecycle"))) continue;
            AppReloadInfo reloadInfo = this.findOrCreateAppReloadInfo(app);
            if (reloadInfo.needsReload()) {
                logger.log(Level.FINE, "[Reloader] Selecting app {0} to reload", reloadInfo.getApplicationName());
                result.add(reloadInfo);
            }
            possiblyUndeployedApps.remove(reloadInfo);
        }
        for (AppReloadInfo reloadInfo : this.failedReloads) {
            if (reloadInfo.needsReload()) {
                logger.log(Level.FINE, "[Reloader] Selecting app {0} to reload", reloadInfo.getApplicationName());
                result.add(reloadInfo);
            }
            possiblyUndeployedApps.remove(reloadInfo);
        }
        for (AppReloadInfo info : possiblyUndeployedApps) {
            logger.log(Level.FINE, "[Reloader] Removing undeployed app {0} from reload info", info.getApplicationName());
            this.appReloadInfo.remove(info.getApplicationName());
        }
        return result;
    }

    private synchronized AppReloadInfo findOrCreateAppReloadInfo(Application app) throws URISyntaxException {
        AppReloadInfo result = this.appReloadInfo.get(app.getName());
        if (result == null) {
            logger.log(Level.FINE, "[Reloader] Recording info for new app {0} at {1}", new Object[]{app.getName(), app.getLocation()});
            result = new AppReloadInfo(app);
            this.appReloadInfo.put(app.getName(), result);
        }
        return result;
    }

    private void reloadApp(AppReloadInfo appInfo) throws IOException {
        logger.log(Level.FINE, "[Reloader] Reloading {0}", appInfo.getApplicationName());
        CommandRunnerImpl commandRunner = (CommandRunnerImpl)this.habitat.getService(CommandRunnerImpl.class, new Annotation[0]);
        ParameterMap deployParam = new ParameterMap();
        deployParam.set("force", Boolean.TRUE.toString());
        deployParam.set("path", appInfo.getApplicationDirectory().getCanonicalPath());
        deployParam.set("name", appInfo.getApplicationName());
        deployParam.set("keepreposdir", "true");
        Properties reloadFile = appInfo.readReloadFile();
        boolean devMode = Boolean.parseBoolean(reloadFile.getProperty(DEV_MODE));
        String contextRoot = reloadFile.getProperty("contextroot");
        boolean keepState = Boolean.parseBoolean(reloadFile.getProperty("keepState"));
        boolean hotDeploy = Boolean.parseBoolean(reloadFile.getProperty("hotdeploy"));
        if (hotDeploy) {
            String sourcesChanged;
            deployParam.set("hotdeploy", "true");
            boolean metadataChanged = Boolean.parseBoolean(reloadFile.getProperty("metadatachanged"));
            if (metadataChanged) {
                deployParam.set("metadatachanged", "true");
            }
            if ((sourcesChanged = reloadFile.getProperty("sourceschanged")) != null && !sourcesChanged.isEmpty()) {
                deployParam.set("sourceschanged", sourcesChanged);
            }
        }
        if (contextRoot != null && !contextRoot.isEmpty()) {
            deployParam.set("contextroot", contextRoot);
        }
        if (keepState) {
            deployParam.set("keepState", "true");
        }
        XMLActionReporter actionReporter = new XMLActionReporter();
        commandRunner.getCommandInvocation("deploy", (ActionReport)actionReporter, this.kernelSubject).parameters(deployParam).execute();
        if (actionReporter.getActionExitCode() == ActionReport.ExitCode.FAILURE && devMode) {
            this.failedReloads.add(appInfo);
        } else if (actionReporter.getActionExitCode() == ActionReport.ExitCode.SUCCESS) {
            this.failedReloads.remove(appInfo);
        }
        appInfo.recordLoad();
    }

    private void markInProgress() {
        this.inProgress.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearInProgress() {
        SyncBoolean syncBoolean = this.inProgress;
        synchronized (syncBoolean) {
            this.inProgress.set(false);
            this.inProgress.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilIdle() throws InterruptedException {
        SyncBoolean syncBoolean = this.inProgress;
        synchronized (syncBoolean) {
            while (this.inProgress.get()) {
                this.inProgress.wait();
            }
        }
    }

    private final class AppReloadInfo {
        private final File reloadFile;
        private long latestRecordedLoad;
        private final String name;
        private final Application app;
        private final File appDir;

        private AppReloadInfo(Application app) throws URISyntaxException {
            this.app = app;
            this.name = app.getName();
            this.appDir = new File(new URI(app.getLocation()));
            this.reloadFile = new File(this.appDir, DynamicReloader.RELOAD_FILE_NAME);
            this.recordLoad();
        }

        public Application getApp() {
            return this.app;
        }

        String getApplicationName() {
            return this.name;
        }

        boolean needsReload() {
            boolean answer = this.reloadFile.lastModified() > this.latestRecordedLoad;
            return answer;
        }

        private Properties readReloadFile() {
            Properties prop = new Properties();
            try (FileInputStream istream = new FileInputStream(this.reloadFile);){
                prop.load(istream);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return prop;
        }

        private void recordLoad() {
            this.latestRecordedLoad = System.currentTimeMillis();
        }

        private File getApplicationDirectory() {
            return this.appDir;
        }

        public int hashCode() {
            return Objects.hash(this.name, this.appDir);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            AppReloadInfo other = (AppReloadInfo)obj;
            return Objects.equals(this.name, other.name) && Objects.equals(this.appDir, other.appDir);
        }
    }

    private static class SyncBoolean {
        private boolean b = false;

        private SyncBoolean(boolean initialValue) {
            this.b = initialValue;
        }

        private synchronized void set(boolean value) {
            this.b = value;
        }

        private synchronized boolean get() {
            return this.b;
        }
    }
}

