/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.appserv.server.util.Version;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.JavaConfig;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.universal.process.ProcessUtils;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.net.NetUtils;
import com.sun.enterprise.v3.server.SystemTasks;
import fish.payara.enterprise.config.serverbeans.DeploymentGroup;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glassfish.config.support.TranslatedConfigView;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.kernel.KernelLoggerInfo;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.types.Property;

@Service
@RunLevel(value=1, mode=0)
public class SystemTasksImpl
implements SystemTasks,
PostConstruct {
    @Inject
    @Named(value="default-instance-name")
    @Optional
    JavaConfig javaConfig;
    @Inject
    @Named(value="default-instance-name")
    Server server;
    @Inject
    Domain domain;
    Logger _logger = KernelLoggerInfo.getLogger();
    private static final LocalStringsImpl strings = new LocalStringsImpl(SystemTasks.class);

    public void postConstruct() {
        this.setVersion();
        this.setSystemPropertiesFromEnv();
        this.setSystemPropertiesFromDomainXml();
        this.resolveJavaConfig();
        this._logger.log(Level.FINE, "SystemTasks: loaded server named: {0}", this.server.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writePidFile() {
        File pidFile = null;
        try {
            pidFile = SmartFile.sanitize((File)this.getPidFile());
            File pidFileCopy = new File(pidFile.getPath() + ".prev");
            String pidString = this.getPidString();
            FileUtils.writeStringToFile((String)pidString, (File)pidFile);
            FileUtils.writeStringToFile((String)pidString, (File)pidFileCopy);
        }
        catch (PidException pe) {
            this._logger.warning(pe.getMessage());
        }
        catch (Exception e) {
            this._logger.warning(strings.get("internal_error", new Object[]{e}));
        }
        finally {
            if (pidFile != null) {
                FileUtils.deleteOnExit((File)pidFile);
            }
        }
    }

    private void setVersion() {
        System.setProperty("glassfish.version", Version.getFullVersion());
    }

    private void setSystemProperty(String name, String value) {
        System.setProperty(name, value);
    }

    private void setSystemPropertiesFromEnv() {
        String hostname;
        block3: {
            this.setSystemProperty("com.sun.aas.javaRoot", System.getProperty("java.home"));
            hostname = "localhost";
            try {
                hostname = NetUtils.getCanonicalHostName();
            }
            catch (Exception ex) {
                if (this._logger == null) break block3;
                this._logger.log(Level.SEVERE, "NCLS-CORE-00089", ex);
            }
        }
        if (hostname != null) {
            this.setSystemProperty("com.sun.aas.hostName", hostname);
        }
    }

    private void setSystemPropertiesFromDomainXml() {
        List domainSPList = this.domain.getSystemProperty();
        List<SystemProperty> configSPList = this.getConfigSystemProperties();
        Cluster cluster = this.server.getCluster();
        List clusterSPList = null;
        List depGroups = this.server.getDeploymentGroup();
        ArrayList<Property> depGroupProperties = new ArrayList<Property>();
        for (DeploymentGroup group : depGroups) {
            depGroupProperties.addAll(group.getProperty());
        }
        if (cluster != null) {
            clusterSPList = cluster.getSystemProperty();
        }
        List serverSPList = this.server.getSystemProperty();
        this.setSystemProperties(domainSPList);
        this.setProperties(depGroupProperties);
        this.setSystemProperties(configSPList);
        if (clusterSPList != null) {
            this.setSystemProperties(clusterSPList);
        }
        this.setSystemProperties(serverSPList);
    }

    private List<SystemProperty> getConfigSystemProperties() {
        try {
            String configName = this.server.getConfigRef();
            Configs configs = this.domain.getConfigs();
            List configsList = configs.getConfig();
            Config config = null;
            for (Config c : configsList) {
                if (!c.getName().equals(configName)) continue;
                config = c;
                break;
            }
            return config != null ? config.getSystemProperty() : Collections.emptyList();
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    private void resolveJavaConfig() {
        if (this.javaConfig != null) {
            Pattern p = Pattern.compile("-D([^=]*)=(.*)");
            for (String jvmOption : this.javaConfig.getJvmOptions()) {
                Matcher m = p.matcher(jvmOption);
                if (!m.matches()) continue;
                String value = TranslatedConfigView.expandConfigValue((String)m.group(2));
                this.setSystemProperty(m.group(1), value);
                if (!this._logger.isLoggable(Level.FINE)) continue;
                this._logger.log(Level.FINE, "Setting {0} = {1}", new Object[]{m.group(1), value});
            }
        }
    }

    private void setSystemProperties(List<SystemProperty> spList) {
        for (SystemProperty sp : spList) {
            String name = sp.getName();
            String value = sp.getValue();
            if (!SystemTasksImpl.ok(name)) continue;
            this.setSystemProperty(name, value);
        }
    }

    private void setProperties(List<Property> propList) {
        for (Property prop : propList) {
            String name = prop.getName();
            if (!SystemTasksImpl.ok(name)) continue;
            this.setSystemProperty(name, prop.getValue());
        }
    }

    private String getPidString() {
        return "" + ProcessUtils.getPid();
    }

    private File getPidFile() throws PidException {
        try {
            String configDirString = System.getProperty("com.sun.aas.instanceRoot");
            if (!SystemTasksImpl.ok(configDirString)) {
                throw new PidException(strings.get("internal_error", new Object[]{"Null or empty value for the System Property: com.sun.aas.instanceRoot"}));
            }
            File configDir = new File(new File(configDirString), "config");
            if (!configDir.isDirectory()) {
                throw new PidException(strings.get("bad_config_dir", new Object[]{configDir}));
            }
            File pidFile = new File(configDir, "pid");
            if (pidFile.exists() && (!pidFile.delete() || pidFile.exists())) {
                throw new PidException(strings.get("cant_delete_pid_file", new Object[]{pidFile}));
            }
            return pidFile;
        }
        catch (PidException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new PidException(e.getMessage());
        }
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    private static class PidException
    extends Exception {
        public PidException(String s) {
            super(s);
        }
    }
}

