/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.microprofile.config.spi;

import fish.payara.nucleus.microprofile.config.spi.ConfigProviderResolverImpl;
import fish.payara.nucleus.microprofile.config.spi.PayaraConfig;
import jakarta.annotation.Priority;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigBuilder;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.Converter;

public class PayaraConfigBuilder
implements ConfigBuilder {
    private final LinkedList<ConfigSource> sources = new LinkedList();
    private final Map<Class<?>, Converter<?>> converters = new HashMap();
    private final ConfigProviderResolverImpl resolver;
    private ClassLoader loader;

    public PayaraConfigBuilder(ConfigProviderResolverImpl resolver, ClassLoader loader) {
        this.resolver = resolver;
        this.loader = loader;
    }

    public PayaraConfigBuilder(ConfigProviderResolverImpl resolver) {
        this(resolver, Thread.currentThread().getContextClassLoader());
    }

    public ConfigBuilder addDefaultSources() {
        this.sources.addAll(this.resolver.getDefaultSources());
        return this;
    }

    public ConfigBuilder addDiscoveredSources() {
        this.sources.addAll(this.resolver.getDiscoveredSources(this.resolver.getAppInfo(this.loader)));
        return this;
    }

    public ConfigBuilder addDiscoveredConverters() {
        Map<Class<?>, Converter<?>> discoveredConverters = this.resolver.getDiscoveredConverters(this.resolver.getAppInfo(this.loader));
        this.converters.putAll(discoveredConverters);
        return this;
    }

    public ConfigBuilder forClassLoader(ClassLoader loader) {
        this.loader = loader;
        return this;
    }

    public ConfigBuilder withSources(ConfigSource ... sources) {
        this.sources.addAll(Arrays.asList(sources));
        return this;
    }

    public ConfigBuilder withConverters(Converter<?> ... converters) {
        this.addConvertersToMap(Arrays.asList(converters));
        return this;
    }

    public Config build() {
        this.converters.putAll(this.resolver.getDefaultConverters());
        return new PayaraConfig(this.sources, this.converters, TimeUnit.SECONDS.toMillis(this.resolver.getCacheDurationSeconds()));
    }

    public <T> ConfigBuilder withConverter(Class<T> type, int i, Converter<T> cnvrtr) {
        Converter<?> old = this.converters.get(type);
        if (old != null) {
            if (i > PayaraConfigBuilder.getPriority(old)) {
                this.converters.put(type, cnvrtr);
            }
        } else {
            this.converters.put(type, cnvrtr);
        }
        return this;
    }

    public static Class<?> getTypeForConverter(Converter<?> converter) {
        return PayaraConfigBuilder.getTypeForConverter(converter.getClass());
    }

    public static Class<?> getTypeForConverter(Class<?> converter) {
        Type[] types;
        for (Type type : types = converter.getGenericInterfaces()) {
            ParameterizedType parameterizedType;
            if (!(type instanceof ParameterizedType) || (parameterizedType = (ParameterizedType)type).getRawType() != Converter.class) continue;
            Type forType = parameterizedType.getActualTypeArguments()[0];
            if (forType instanceof Class) {
                return (Class)forType;
            }
            if (!(forType instanceof ParameterizedType)) continue;
            return (Class)((ParameterizedType)forType).getRawType();
        }
        return null;
    }

    private static int getPriority(Converter<?> converter) {
        int result = 100;
        Priority annotation = converter.getClass().getAnnotation(Priority.class);
        if (annotation != null) {
            result = annotation.value();
        }
        return result;
    }

    private void addConvertersToMap(List<Converter<?>> convertersList) {
        for (Converter<?> converter : convertersList) {
            Class<?> type = PayaraConfigBuilder.getTypeForConverter(converter);
            if (type == null) continue;
            Converter<?> old = this.converters.get(type);
            if (old != null) {
                if (PayaraConfigBuilder.getPriority(converter) <= PayaraConfigBuilder.getPriority(old)) continue;
                this.converters.put(type, converter);
                continue;
            }
            this.converters.put(type, converter);
        }
    }
}

