/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.docker.instance.admin;

import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import fish.payara.docker.instance.admin.SetDockerContainerIdCommand;
import jakarta.inject.Inject;
import java.util.logging.Logger;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="_get-docker-container-id")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Server.class, opType=RestEndpoint.OpType.GET, path="_get-docker-container-id", description="Gets the Docker Container ID for an Instance")})
public class GetDockerContainerIdCommand
implements AdminCommand {
    private static final Logger logger = Logger.getLogger(SetDockerContainerIdCommand.class.getName());
    @Param(name="instanceName", alias="instance")
    private String instanceName;
    @Inject
    Servers servers;

    public void execute(AdminCommandContext adminCommandContext) {
        if (this.servers == null) {
            adminCommandContext.getActionReport().failure(logger, "Could not retrieve Servers");
            return;
        }
        if (this.instanceName == null || this.instanceName.isEmpty()) {
            adminCommandContext.getActionReport().failure(logger, "No instance name provided");
            return;
        }
        Server server = this.servers.getServer(this.instanceName);
        if (server == null) {
            adminCommandContext.getActionReport().failure(logger, "Could not find instance with name: " + this.instanceName);
            return;
        }
        adminCommandContext.getActionReport().setMessage(server.getDockerContainerId());
    }
}

