/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.docker.instance.admin;

import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import jakarta.inject.Inject;
import java.util.logging.Logger;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="_set-docker-container-id")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Server.class, opType=RestEndpoint.OpType.POST, path="_set-docker-container-id", description="Sets the Docker Container ID for an Instance")})
public class SetDockerContainerIdCommand
implements AdminCommand {
    private static final Logger logger = Logger.getLogger(SetDockerContainerIdCommand.class.getName());
    @Param(name="instanceName", alias="instance")
    private String instanceName;
    @Param(name="containerId", alias="id")
    private String containerId;
    @Inject
    Servers servers;

    public void execute(AdminCommandContext adminCommandContext) {
        if (this.servers == null) {
            adminCommandContext.getActionReport().failure(logger, "Could not retrieve Servers");
            return;
        }
        if (this.instanceName == null || this.instanceName.isEmpty() || this.containerId == null || this.containerId.isEmpty()) {
            adminCommandContext.getActionReport().failure(logger, "Instance Name or Container ID empty");
            return;
        }
        Server server = this.servers.getServer(this.instanceName);
        if (server == null) {
            adminCommandContext.getActionReport().failure(logger, "Could not find instance with name: " + this.instanceName);
            return;
        }
        try {
            ConfigSupport.apply(serverProxy -> {
                serverProxy.setDockerContainerId(this.containerId);
                return serverProxy;
            }, (ConfigBeanProxy)server);
        }
        catch (TransactionFailure transactionFailure) {
            adminCommandContext.getActionReport().failure(logger, "Could not set Docker Container ID", (Throwable)transactionFailure);
        }
    }
}

