/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.spi;

import com.sun.gjc.spi.ManagedConnectionImpl;
import com.sun.logging.LogDomains;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.LocalTransaction;
import jakarta.resource.spi.LocalTransactionException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LocalTransactionImpl
implements LocalTransaction {
    private ManagedConnectionImpl mc;
    protected static final Logger _logger = LogDomains.getLogger(LocalTransactionImpl.class, (String)"javax.enterprise.resource.resourceadapter");

    public LocalTransactionImpl(ManagedConnectionImpl mc) {
        this.mc = mc;
    }

    public void begin() throws ResourceException {
        this.mc.transactionStarted();
        try {
            this.mc.getActualConnection().setAutoCommit(false);
        }
        catch (SQLException sqle) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Exception during begin() : " + sqle);
            }
            throw new LocalTransactionException(sqle.getMessage(), (Throwable)sqle);
        }
    }

    public void commit() throws ResourceException {
        try {
            this.mc.getActualConnection().commit();
            this.mc.getActualConnection().setAutoCommit(true);
        }
        catch (SQLException sqle) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Exception during commit() : " + sqle);
            }
            throw new LocalTransactionException(sqle.getMessage(), (Throwable)sqle);
        }
        finally {
            this.mc.transactionCompleted();
        }
    }

    public void rollback() throws ResourceException {
        try {
            this.mc.getActualConnection().rollback();
            this.mc.getActualConnection().setAutoCommit(true);
        }
        catch (SQLException sqle) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Exception during rollback() : " + sqle);
            }
            throw new LocalTransactionException(sqle.getMessage(), (Throwable)sqle);
        }
        finally {
            this.mc.transactionCompleted();
        }
    }
}

