/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.micro.cdi.extension.cluster;

import fish.payara.micro.cdi.extension.cluster.annotations.ClusterScoped;
import fish.payara.micro.cdi.extension.cluster.annotations.ClusterScopedIntercepted;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.spi.AnnotatedConstructor;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.util.AnnotationLiteral;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;

class ClusteredAnnotatedType<TT>
implements AnnotatedType<TT> {
    private static final ApplicationScopedFilter appScopedFilter = new ApplicationScopedFilter();
    private static final ClusteredAnnotationLiteral clusteredScopedLiteral = new ClusteredAnnotationLiteral();
    private static final ClusteredInterceptorAnnotationLiteral clusteredScopedInterceptorLiteral = new ClusteredInterceptorAnnotationLiteral();
    private final AnnotatedType<TT> wrapped;

    public ClusteredAnnotatedType(AnnotatedType<TT> wrapped) {
        this.wrapped = wrapped;
    }

    public Set<Annotation> getAnnotations() {
        HashSet<Annotation> annotations = new HashSet<Annotation>(this.wrapped.getAnnotations());
        annotations.removeIf(appScopedFilter);
        annotations.add(clusteredScopedLiteral);
        annotations.add(clusteredScopedInterceptorLiteral);
        return annotations;
    }

    public Type getBaseType() {
        return this.wrapped.getBaseType();
    }

    public Set<Type> getTypeClosure() {
        return this.wrapped.getTypeClosure();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        return (T)this.wrapped.getAnnotation(annotationType);
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.wrapped.isAnnotationPresent(annotationType);
    }

    public Class<TT> getJavaClass() {
        return this.wrapped.getJavaClass();
    }

    public Set<AnnotatedConstructor<TT>> getConstructors() {
        return this.wrapped.getConstructors();
    }

    public Set<AnnotatedMethod<? super TT>> getMethods() {
        return this.wrapped.getMethods();
    }

    public Set<AnnotatedField<? super TT>> getFields() {
        return this.wrapped.getFields();
    }

    private static class ApplicationScopedFilter
    implements Predicate<Annotation> {
        private ApplicationScopedFilter() {
        }

        @Override
        public boolean test(Annotation input) {
            return input.annotationType().equals(ApplicationScoped.class);
        }
    }

    private static class ClusteredInterceptorAnnotationLiteral
    extends AnnotationLiteral<ClusterScopedIntercepted>
    implements ClusterScopedIntercepted {
        private ClusteredInterceptorAnnotationLiteral() {
        }
    }

    private static class ClusteredAnnotationLiteral
    extends AnnotationLiteral<ClusterScoped>
    implements ClusterScoped {
        private ClusteredAnnotationLiteral() {
        }
    }
}

