/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging;

import com.sun.common.util.logging.GFLogRecord;
import com.sun.common.util.logging.LoggingConfig;
import com.sun.common.util.logging.LoggingConfigFactory;
import com.sun.common.util.logging.LoggingXMLNames;
import com.sun.enterprise.admin.monitor.callflow.Agent;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.module.bootstrap.EarlyLogHandler;
import com.sun.enterprise.server.logging.GFFileHandler;
import com.sun.enterprise.server.logging.LogFacade;
import com.sun.enterprise.server.logging.ODLLogFormatter;
import com.sun.enterprise.server.logging.SyslogHandler;
import com.sun.enterprise.server.logging.UniformLogFormatter;
import com.sun.enterprise.util.EarlyLogger;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.v3.logging.AgentFormatterDelegate;
import fish.payara.enterprise.server.logging.JSONLogFormatter;
import fish.payara.enterprise.server.logging.PayaraNotificationFileHandler;
import jakarta.inject.Inject;
import jakarta.validation.ValidationException;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.glassfish.api.admin.FileMonitoring;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.PreDestroy;
import org.glassfish.hk2.api.Rank;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.internal.config.UnprocessedConfigListener;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.UnprocessedChangeEvent;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service
@RunLevel(value=1)
@Rank(value=50)
public class LogManagerService
implements PostConstruct,
PreDestroy,
org.glassfish.internal.api.LogManager {
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    ServiceLocator habitat;
    @Inject
    @Optional
    Agent agent = null;
    @Inject
    FileMonitoring fileMonitoring;
    @Inject
    LoggingConfigFactory loggingConfigFactory;
    @Inject
    UnprocessedConfigListener ucl;
    @Inject
    Domain domain;
    final Map<String, Handler> gfHandlers = new HashMap<String, Handler>();
    private static final Logger LOGGER = LogFacade.LOGGING_LOGGER;
    PrintStream oStdOutBackup = System.out;
    PrintStream oStdErrBackup = System.err;
    String serverLogFileDetail = "";
    String handlerDetail = "";
    String handlerServices = "";
    String consoleHandlerFormatterDetail = "";
    String gffileHandlerFormatterDetail = "";
    String rotationOnTimeLimitInMinutesDetail = "";
    String flushFrequencyDetail = "";
    String filterHandlerDetails = "";
    String logToFileDetail = "";
    String logToConsoleDetail = "";
    String rotationInTimeLimitInBytesDetail = "";
    String useSystemLoggingDetail = "";
    String fileHandlerCountDetail = "";
    String retainErrorsStaticticsDetail = "";
    String log4jVersionDetail = "";
    String maxHistoryFilesDetail = "";
    String rotationOnDateChangeDetail = "";
    String fileHandlerPatternDetail = "";
    String fileHandlerFormatterDetail = "";
    String logFormatDateFormatDetail = "";
    String compressOnRotationDetail = "";
    String logStandardStreamsDetail = "";
    String fastLoggingDetail = "";
    String payaraNotificationLogFileDetail = "";
    String payaraNotificationlogToFileDetail = "";
    String payaraNotificationLogRotationOnTimeLimitInMinutesDetail = "";
    String payaraNotificationLogRotationOnDateChangeDetail = "";
    String payaraNotificationLogRotationLimitInBytesDetail = "";
    String payaraNotificationLogmaxHistoryFilesDetail = "";
    String payaraNotificationLogCompressOnRotationDetail = "";
    String payaraNotificationLogFormatterDetail = "";
    String payaraJsonUnderscorePrefix = "";
    private static final String SERVER_LOG_FILE_PROPERTY = "com.sun.enterprise.server.logging.GFFileHandler.file";
    private static final String HANDLER_PROPERTY = "handlers";
    private static final String HANDLER_SERVICES_PROPERTY = "handlerServices";
    private static final String CONSOLEHANDLER_FORMATTER_PROPERTY = "java.util.logging.ConsoleHandler.formatter";
    private static final String GFFILEHANDLER_FORMATTER_PROPERTY = "com.sun.enterprise.server.logging.GFFileHandler.formatter";
    private static final String ROTATIONTIMELIMITINMINUTES_PROPERTY = "com.sun.enterprise.server.logging.GFFileHandler.rotationTimelimitInMinutes";
    private static final String FLUSHFREQUENCY_PROPERTY = "com.sun.enterprise.server.logging.GFFileHandler.flushFrequency";
    private static final String FILEHANDLER_LIMIT_PROPERTY = "java.util.logging.FileHandler.limit";
    private static final String LOGTOFILE_PROPERTY = "com.sun.enterprise.server.logging.GFFileHandler.logtoFile";
    private static final String LOGTOCONSOLE_PROPERTY = "com.sun.enterprise.server.logging.GFFileHandler.logtoConsole";
    private static final String ROTATIONLIMITINBYTES_PROPERTY = "com.sun.enterprise.server.logging.GFFileHandler.rotationLimitInBytes";
    private static final String USESYSTEMLOGGING_PROPERTY = "com.sun.enterprise.server.logging.SyslogHandler.useSystemLogging";
    private static final String FILEHANDLER_COUNT_PROPERTY = "java.util.logging.FileHandler.count";
    private static final String RETAINERRORSSTATICTICS_PROPERTY = "com.sun.enterprise.server.logging.GFFileHandler.retainErrorsStasticsForHours";
    private static final String LOG4J_VERSION_PROPERTY = "log4j.logger.org.hibernate.validator.util.Version";
    private static final String MAXHISTORY_FILES_PROPERTY = "com.sun.enterprise.server.logging.GFFileHandler.maxHistoryFiles";
    private static final String ROTATIONONDATECHANGE_PROPERTY = "com.sun.enterprise.server.logging.GFFileHandler.rotationOnDateChange";
    private static final String FILEHANDLER_PATTERN_PROPERTY = "java.util.logging.FileHandler.pattern";
    private static final String FILEHANDLER_FORMATTER_PROPERTY = "java.util.logging.FileHandler.formatter";
    private static final String LOGFORMAT_DATEFORMAT_PROPERTY = "com.sun.enterprise.server.logging.GFFileHandler.logFormatDateFormat";
    private static final String COMPRESS_ON_ROTATION_PROPERTY = "com.sun.enterprise.server.logging.GFFileHandler.compressOnRotation";
    private static final String LOG_STANDARD_STREAMS_PROPERTY = "com.sun.enterprise.server.logging.GFFileHandler.logStandardStreams";
    private static final String FAST_LOGGER_PROPERTY = "com.sun.enterprise.server.logging.GFFileHandler.fastLogging";
    private static final String PAYARA_NOTIFICATION_LOG_FILE_PROPERTY = "fish.payara.enterprise.server.logging.PayaraNotificationFileHandler.file";
    private static final String PAYARA_NOTIFICATION_LOGTOFILE_PROPERTY = "fish.payara.enterprise.server.logging.PayaraNotificationFileHandler.logtoFile";
    private static final String PAYARA_NOTIFICATION_LOG_ROTATIONONDATECHANGE_PROPERTY = "fish.payara.enterprise.server.logging.PayaraNotificationFileHandler.rotationOnDateChange";
    private static final String PAYARA_NOTIFICATION_LOG_ROTATIONTIMELIMITINMINUTES_PROPERTY = "fish.payara.enterprise.server.logging.PayaraNotificationFileHandler.rotationTimelimitInMinutes";
    private static final String PAYARA_NOTIFICATION_LOG_ROTATIONLIMITINBYTES_PROPERTY = "fish.payara.enterprise.server.logging.PayaraNotificationFileHandler.rotationLimitInBytes";
    private static final String PAYARA_NOTIFICATION_LOG_MAXHISTORY_FILES_PROPERTY = "fish.payara.enterprise.server.logging.PayaraNotificationFileHandler.maxHistoryFiles";
    private static final String PAYARA_NOTIFICATION_LOG_COMPRESS_ON_ROTATION_PROPERTY = "fish.payara.enterprise.server.logging.PayaraNotificationFileHandler.compressOnRotation";
    private static final String PAYARA_NOTIFICATION_LOG_FORMATTER_PROPERTY = "fish.payara.enterprise.server.logging.PayaraNotificationFileHandler.formatter";
    private static final String PAYARA_NOTIFICATION_NOT_USING_SEPARATE_LOG = "Payara Notification Service isn't using a separate Log File";
    @Deprecated
    private static final String PAYARA_JSONLOGFORMATTER_UNDERSCORE = "fish.payara.deprecated.jsonlogformatter.underscoreprefix";
    static final String EXCLUDE_FIELDS_PROPERTY = "com.sun.enterprise.server.logging.GFFileHandler.excludeFields";
    static final String MULTI_LINE_MODE_PROPERTY = "com.sun.enterprise.server.logging.GFFileHandler.multiLineMode";
    private String RECORD_BEGIN_MARKER = "[#|";
    private String RECORD_END_MARKER = "|#]";
    private String RECORD_FIELD_SEPARATOR = "|";
    private String RECORD_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    String recordBeginMarker;
    String recordEndMarker;
    String recordFieldSeparator;
    String recordDateFormat;
    Vector<Logger> loggerReference = new Vector();
    private String excludeFields;
    private boolean multiLineMode = false;
    private GFFileHandler gfFileHandler = null;
    private PayaraNotificationFileHandler pyFileHandler = null;
    private String payaraNotificationLogger = "fish.payara.nucleus.notification.log.LogNotifier";

    public Map<String, String> getLoggingProperties() throws IOException {
        Map props;
        Map<String, String> invalidProps;
        Server targetServer = this.domain.getServerNamed(this.env.getInstanceName());
        LoggingConfig loggingConfig = this.loggingConfigFactory.provide();
        if (targetServer != null && !targetServer.isDas()) {
            if (targetServer.getCluster() != null) {
                loggingConfig = this.loggingConfigFactory.provide(targetServer.getCluster().getConfigRef());
            } else if (targetServer.isInstance()) {
                loggingConfig = this.loggingConfigFactory.provide(targetServer.getConfigRef());
            }
        }
        if (!(invalidProps = this.validateProps(props = loggingConfig.getLoggingProperties())).isEmpty()) {
            loggingConfig.deleteLoggingProperties(invalidProps);
            props = loggingConfig.getLoggingProperties();
        }
        return props;
    }

    public Map<String, String> validateProps(Map<String, String> props) {
        HashMap<String, String> invalidProps = new HashMap<String, String>();
        Iterator<Map.Entry<String, String>> propertyIterator = props.entrySet().iterator();
        while (propertyIterator.hasNext()) {
            Map.Entry<String, String> propertyEntry = propertyIterator.next();
            try {
                this.validateProp(propertyEntry.getKey(), propertyEntry.getValue());
            }
            catch (ValidationException ex) {
                LOGGER.log(Level.WARNING, "Error validating log property.", ex);
                propertyIterator.remove();
                invalidProps.put(propertyEntry.getKey(), propertyEntry.getValue());
            }
        }
        return invalidProps;
    }

    public void validateProp(String key, String value) {
        int PayaraNotificationRotationTimeLimit;
        if (key.equals(ROTATIONLIMITINBYTES_PROPERTY)) {
            int rotationSizeLimit = Integer.parseInt(value);
            if (rotationSizeLimit != 0 && rotationSizeLimit < 500000) {
                throw new ValidationException(String.format("'%s' value must be greater than %d, but was %d.", ROTATIONLIMITINBYTES_PROPERTY, 500000, rotationSizeLimit));
            }
        } else if (key.equals(ROTATIONTIMELIMITINMINUTES_PROPERTY)) {
            int rotationTimeLimit = Integer.parseInt(value);
            if (rotationTimeLimit < 0) {
                throw new ValidationException(String.format("'%s' value must be greater than %d, but was %d.", ROTATIONTIMELIMITINMINUTES_PROPERTY, 0, rotationTimeLimit));
            }
        } else if (key.equals(PAYARA_NOTIFICATION_LOG_ROTATIONTIMELIMITINMINUTES_PROPERTY) && (PayaraNotificationRotationTimeLimit = Integer.parseInt(value)) < 0) {
            throw new ValidationException(String.format("'%s' value must be greater than %d, but was %d.", PAYARA_NOTIFICATION_LOG_ROTATIONTIMELIMITINMINUTES_PROPERTY, 0, PayaraNotificationRotationTimeLimit));
        }
    }

    public File getLoggingFile() throws IOException {
        File file = null;
        Server targetServer = this.domain.getServerNamed(this.env.getInstanceName());
        if (targetServer != null) {
            if (targetServer.isDas()) {
                file = new File(this.env.getConfigDirPath(), "logging.properties");
            } else if (targetServer.getCluster() != null) {
                String pathForLogging = this.env.getConfigDirPath() + File.separator + targetServer.getCluster().getConfigRef();
                File dirForLogging = new File(pathForLogging);
                file = new File(dirForLogging, "logging.properties");
            } else if (targetServer.isInstance()) {
                String pathForLogging = this.env.getConfigDirPath() + File.separator + targetServer.getConfigRef();
                File dirForLogging = new File(pathForLogging);
                file = new File(dirForLogging, "logging.properties");
            } else {
                file = new File(this.env.getConfigDirPath(), "logging.properties");
            }
        } else {
            file = new File(this.env.getConfigDirPath(), "logging.properties");
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postConstruct() {
        Iterator handlers;
        if (System.getProperty("java.util.logging.config.file") != null) {
            System.out.println("\n\n\n#!## LogManagerService.postConstruct : java.util.logging.config.file=" + System.getProperty("java.util.logging.config.file"));
            return;
        }
        LogManager logMgr = LogManager.getLogManager();
        File loggingPropertiesFile = null;
        try {
            loggingPropertiesFile = this.getLoggingFile();
            System.setProperty("java.util.logging.config.file", loggingPropertiesFile.getAbsolutePath());
            String rootFolder = (String)this.env.getProps().get("com.sun.aas.installRoot");
            String templateDir = rootFolder + File.separator + "lib" + File.separator + "templates";
            File src = new File(templateDir, "logging.properties");
            File dest = new File(this.env.getConfigDirPath(), "logging.properties");
            System.out.println("\n\n\n#!## LogManagerService.postConstruct : rootFolder=" + rootFolder);
            System.out.println("#!## LogManagerService.postConstruct : templateDir=" + templateDir);
            System.out.println("#!## LogManagerService.postConstruct : src=" + src);
            System.out.println("#!## LogManagerService.postConstruct : dest=" + dest);
            if (!loggingPropertiesFile.exists()) {
                LOGGER.log(Level.FINE, "{0} not found, creating new file from template.", loggingPropertiesFile.getAbsolutePath());
                FileUtils.copy((File)src, (File)dest);
                loggingPropertiesFile = new File(this.env.getConfigDirPath(), "logging.properties");
            }
            logMgr.readConfiguration();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "NCLS-LOGGING-00001", e);
        }
        AgentFormatterDelegate agentDelegate = null;
        if (this.agent != null) {
            agentDelegate = new AgentFormatterDelegate(this.agent);
        }
        String formatterClassName = null;
        try {
            String filterClassName;
            Map<String, String> props = this.getLoggingProperties();
            formatterClassName = props.get(CONSOLEHANDLER_FORMATTER_PROPERTY);
            this.setConsoleHandlerLogFormat(formatterClassName, props, logMgr);
            this.setDefaultLoggingProperties(props);
            handlers = this.getHandlerServices(props);
            if (handlers != null && handlers.size() > 0) {
                Iterator iterator = handlers.iterator();
                while (iterator.hasNext()) {
                    Handler handler = (Handler)iterator.next();
                    this.addHandler(handler);
                }
            }
            if ((filterClassName = props.get(LoggingXMLNames.xmltoPropsMap.get("log-filter"))) != null) {
                java.util.logging.Filter filterClass = (java.util.logging.Filter)this.habitat.getService(java.util.logging.Filter.class, filterClassName, new Annotation[0]);
                Logger rootLogger = Logger.getLogger("");
                if (rootLogger != null) {
                    rootLogger.setFilter(filterClass);
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NCLS-LOGGING-00002", e);
        }
        Class<Logger> e = Logger.class;
        synchronized (Logger.class) {
            handlers = logMgr;
            synchronized (handlers) {
                Enumeration<String> loggerNames = logMgr.getLoggerNames();
                while (loggerNames.hasMoreElements()) {
                    String loggerName = loggerNames.nextElement();
                    Logger logger = logMgr.getLogger(loggerName);
                    if (logger == null) continue;
                    for (Handler handler : logger.getHandlers()) {
                        Formatter formatter = handler.getFormatter();
                        if (formatter == null || !(formatter instanceof UniformLogFormatter)) continue;
                        ((UniformLogFormatter)formatter).setDelegate(agentDelegate);
                    }
                }
            }
            // ** MonitorExit[e] (shouldn't be in output)
            this.listenToChangesOnloggingPropsFile(loggingPropertiesFile, logMgr);
            List catchUp = EarlyLogger.getEarlyMessages();
            if (!catchUp.isEmpty()) {
                for (EarlyLogger.LevelAndMessage levelAndMessage : catchUp) {
                    LOGGER.log(levelAndMessage.getLevel(), levelAndMessage.getMessage());
                }
                catchUp.clear();
            }
            ArrayBlockingQueue catchEarlyMessage = EarlyLogHandler.earlyMessages;
            while (!catchEarlyMessage.isEmpty()) {
                LogRecord logRecord = (LogRecord)catchEarlyMessage.poll();
                if (logRecord == null) continue;
                LOGGER.log(logRecord);
            }
            return;
        }
    }

    public void listenToChangesOnloggingPropsFile(File loggingPropertiesFile, final LogManager logMgr) {
        if (loggingPropertiesFile != null) {
            this.fileMonitoring.monitors(loggingPropertiesFile, new FileMonitoring.FileChangeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void changed(File changedFile) {
                    Map<String, Handler> map = LogManagerService.this.gfHandlers;
                    synchronized (map) {
                        try {
                            Map<String, String> props = LogManagerService.this.getLoggingProperties();
                            LogManagerService.this.loggerReference = new Vector();
                            if (props == null) {
                                return;
                            }
                            block5: for (Map.Entry<String, String> entry : props.entrySet()) {
                                Handler[] payaraNotificationLogFileHandlers;
                                String a = entry.getKey();
                                String val = entry.getValue();
                                if (a.endsWith(".level")) {
                                    Handler[] n = a.substring(0, a.lastIndexOf(".level"));
                                    Level l = Level.parse(val);
                                    if (LogManagerService.this.gfHandlers.containsKey(n)) {
                                        Handler h = LogManagerService.this.gfHandlers.get(n);
                                        h.setLevel(l);
                                        continue;
                                    }
                                    if (n.equals("java.util.logging.ConsoleHandler")) {
                                        Logger logger = Logger.getLogger("");
                                        Handler[] h = logger.getHandlers();
                                        for (int i = 0; i < h.length; ++i) {
                                            String name = h[i].toString();
                                            if (!name.contains("java.util.logging.ConsoleHandler")) continue;
                                            h[i].setLevel(l);
                                        }
                                        continue;
                                    }
                                    Logger appLogger = Logger.getLogger((String)n);
                                    appLogger.setLevel(l);
                                    LogManagerService.this.loggerReference.add(appLogger);
                                    continue;
                                }
                                if (a.equals(LogManagerService.SERVER_LOG_FILE_PROPERTY)) {
                                    if (val.equals(LogManagerService.this.serverLogFileDetail)) continue;
                                    LogManagerService.this.serverLogFileDetail = val;
                                    for (Handler handler : logMgr.getLogger("").getHandlers()) {
                                        if (!handler.getClass().equals(GFFileHandler.class)) continue;
                                        LogManagerService.this.gfFileHandler = (GFFileHandler)handler;
                                        LogManagerService.this.gfFileHandler.setLogFile(LogManagerService.this.serverLogFileDetail);
                                        continue block5;
                                    }
                                    continue;
                                }
                                if (a.equals(LogManagerService.HANDLER_PROPERTY)) {
                                    if (val.equals(LogManagerService.this.handlerDetail)) continue;
                                    LogManagerService.this.generateAttributeChangeEvent(LogManagerService.HANDLER_PROPERTY, LogManagerService.this.handlerDetail, props);
                                    continue;
                                }
                                if (a.equals(LogManagerService.HANDLER_SERVICES_PROPERTY)) {
                                    if (val.equals(LogManagerService.this.handlerServices)) continue;
                                    LogManagerService.this.generateAttributeChangeEvent(LogManagerService.HANDLER_SERVICES_PROPERTY, LogManagerService.this.handlerServices, props);
                                    continue;
                                }
                                if (a.equals(LogManagerService.CONSOLEHANDLER_FORMATTER_PROPERTY)) {
                                    if (val.equals(LogManagerService.this.consoleHandlerFormatterDetail)) continue;
                                    LogManagerService.this.consoleHandlerFormatterDetail = val;
                                    LogManagerService.this.setConsoleHandlerLogFormat(LogManagerService.this.consoleHandlerFormatterDetail, props, logMgr);
                                    continue;
                                }
                                if (a.equals(LogManagerService.GFFILEHANDLER_FORMATTER_PROPERTY)) {
                                    if (val.equals(LogManagerService.this.gffileHandlerFormatterDetail)) continue;
                                    LogManagerService.this.gffileHandlerFormatterDetail = val;
                                    for (Handler handler : logMgr.getLogger("").getHandlers()) {
                                        if (!handler.getClass().equals(GFFileHandler.class)) continue;
                                        LogManagerService.this.gfFileHandler = (GFFileHandler)handler;
                                        LogManagerService.this.gfFileHandler.setFileHandlerFormatter(LogManagerService.this.gffileHandlerFormatterDetail);
                                        continue block5;
                                    }
                                    continue;
                                }
                                if (a.equals(LogManagerService.PAYARA_NOTIFICATION_LOG_FORMATTER_PROPERTY)) {
                                    if (val.equals(LogManagerService.this.payaraNotificationLogFormatterDetail)) continue;
                                    payaraNotificationLogFileHandlers = logMgr.getLogger(LogManagerService.this.payaraNotificationLogger).getHandlers();
                                    if (payaraNotificationLogFileHandlers.length > 0) {
                                        LogManagerService.this.payaraNotificationLogFormatterDetail = val;
                                        for (Handler handler : payaraNotificationLogFileHandlers) {
                                            if (!handler.getClass().equals(PayaraNotificationFileHandler.class)) continue;
                                            LogManagerService.this.pyFileHandler = (PayaraNotificationFileHandler)handler;
                                            LogManagerService.this.pyFileHandler.setFileHandlerFormatter(LogManagerService.this.payaraNotificationLogFormatterDetail);
                                            continue block5;
                                        }
                                        continue;
                                    }
                                    LOGGER.log(Level.INFO, LogManagerService.PAYARA_NOTIFICATION_NOT_USING_SEPARATE_LOG);
                                    continue;
                                }
                                if (a.equals(LogManagerService.ROTATIONTIMELIMITINMINUTES_PROPERTY)) {
                                    if (val.equals(LogManagerService.this.rotationOnTimeLimitInMinutesDetail)) continue;
                                    LogManagerService.this.rotationOnTimeLimitInMinutesDetail = val;
                                    for (Handler handler : logMgr.getLogger("").getHandlers()) {
                                        if (!handler.getClass().equals(GFFileHandler.class)) continue;
                                        LogManagerService.this.gfFileHandler = (GFFileHandler)handler;
                                        LogManagerService.this.gfFileHandler.setRotationTimeLimitValue(Long.parseLong(LogManagerService.this.rotationOnTimeLimitInMinutesDetail));
                                        continue block5;
                                    }
                                    continue;
                                }
                                if (a.equals(LogManagerService.FLUSHFREQUENCY_PROPERTY)) {
                                    if (val.equals(LogManagerService.this.flushFrequencyDetail)) continue;
                                    LogManagerService.this.flushFrequencyDetail = val;
                                    for (Handler handler : logMgr.getLogger("").getHandlers()) {
                                        if (!handler.getClass().equals(GFFileHandler.class)) continue;
                                        LogManagerService.this.gfFileHandler = (GFFileHandler)handler;
                                        LogManagerService.this.gfFileHandler.setFlushFrequency(Integer.parseInt(LogManagerService.this.flushFrequencyDetail));
                                        continue block5;
                                    }
                                    continue;
                                }
                                if (a.equals(LogManagerService.FILEHANDLER_LIMIT_PROPERTY)) {
                                    if (val.equals(LogManagerService.this.filterHandlerDetails)) continue;
                                    LogManagerService.this.generateAttributeChangeEvent(LogManagerService.FILEHANDLER_LIMIT_PROPERTY, LogManagerService.this.filterHandlerDetails, props);
                                    continue;
                                }
                                if (a.equals(LogManagerService.LOGTOFILE_PROPERTY)) {
                                    if (val.equals(LogManagerService.this.logToFileDetail)) continue;
                                    LogManagerService.this.logToFileDetail = val;
                                    for (Handler handler : logMgr.getLogger("").getHandlers()) {
                                        if (!handler.getClass().equals(GFFileHandler.class)) continue;
                                        LogManagerService.this.gfFileHandler = (GFFileHandler)handler;
                                        LogManagerService.this.gfFileHandler.setLogToFile(Boolean.parseBoolean(LogManagerService.this.logToFileDetail));
                                        continue block5;
                                    }
                                    continue;
                                }
                                if (a.equals(LogManagerService.LOGTOCONSOLE_PROPERTY)) {
                                    if (val.equals(LogManagerService.this.logToConsoleDetail)) continue;
                                    continue;
                                }
                                if (a.equals(LogManagerService.ROTATIONLIMITINBYTES_PROPERTY)) {
                                    if (val.equals(LogManagerService.this.rotationInTimeLimitInBytesDetail)) continue;
                                    LogManagerService.this.rotationInTimeLimitInBytesDetail = val;
                                    for (Handler handler : logMgr.getLogger("").getHandlers()) {
                                        if (!handler.getClass().equals(GFFileHandler.class)) continue;
                                        LogManagerService.this.gfFileHandler = (GFFileHandler)handler;
                                        LogManagerService.this.gfFileHandler.setRotationLimitAttrValue(Integer.valueOf(LogManagerService.this.rotationInTimeLimitInBytesDetail));
                                        continue block5;
                                    }
                                    continue;
                                }
                                if (a.equals(LogManagerService.USESYSTEMLOGGING_PROPERTY)) {
                                    if (val.equals(LogManagerService.this.useSystemLoggingDetail)) continue;
                                    LogManagerService.this.useSystemLoggingDetail = val;
                                    Object syslogHandler = null;
                                    for (Handler handler : logMgr.getLogger("").getHandlers()) {
                                        if (!handler.getClass().equals(SyslogHandler.class)) continue;
                                        syslogHandler = (SyslogHandler)handler;
                                        ((SyslogHandler)syslogHandler).setSystemLogging(Boolean.parseBoolean(LogManagerService.this.useSystemLoggingDetail));
                                        continue block5;
                                    }
                                    continue;
                                }
                                if (a.equals(LogManagerService.FILEHANDLER_COUNT_PROPERTY)) {
                                    if (val.equals(LogManagerService.this.fileHandlerCountDetail)) continue;
                                    LogManagerService.this.generateAttributeChangeEvent(LogManagerService.FILEHANDLER_COUNT_PROPERTY, LogManagerService.this.fileHandlerCountDetail, props);
                                    continue;
                                }
                                if (a.equals(LogManagerService.RETAINERRORSSTATICTICS_PROPERTY)) {
                                    if (val.equals(LogManagerService.this.retainErrorsStaticticsDetail)) continue;
                                    LogManagerService.this.generateAttributeChangeEvent(LogManagerService.RETAINERRORSSTATICTICS_PROPERTY, LogManagerService.this.retainErrorsStaticticsDetail, props);
                                    continue;
                                }
                                if (a.equals(LogManagerService.LOG4J_VERSION_PROPERTY)) {
                                    if (val.equals(LogManagerService.this.log4jVersionDetail)) continue;
                                    LogManagerService.this.generateAttributeChangeEvent(LogManagerService.LOG4J_VERSION_PROPERTY, LogManagerService.this.log4jVersionDetail, props);
                                    continue;
                                }
                                if (a.equals(LogManagerService.MAXHISTORY_FILES_PROPERTY)) {
                                    if (val.equals(LogManagerService.this.maxHistoryFilesDetail)) continue;
                                    LogManagerService.this.maxHistoryFilesDetail = val;
                                    for (Handler handler : logMgr.getLogger("").getHandlers()) {
                                        if (!handler.getClass().equals(GFFileHandler.class)) continue;
                                        LogManagerService.this.gfFileHandler = (GFFileHandler)handler;
                                        LogManagerService.this.gfFileHandler.setMaxHistoryFiles(Integer.parseInt(LogManagerService.this.maxHistoryFilesDetail));
                                        continue block5;
                                    }
                                    continue;
                                }
                                if (a.equals(LogManagerService.ROTATIONONDATECHANGE_PROPERTY)) {
                                    if (val.equals(LogManagerService.this.rotationOnDateChangeDetail)) continue;
                                    LogManagerService.this.rotationOnDateChangeDetail = val;
                                    for (Handler handler : logMgr.getLogger("").getHandlers()) {
                                        if (!handler.getClass().equals(GFFileHandler.class)) continue;
                                        LogManagerService.this.gfFileHandler = (GFFileHandler)handler;
                                        LogManagerService.this.gfFileHandler.setRotationOnDateChange(Boolean.parseBoolean(LogManagerService.this.rotationOnDateChangeDetail));
                                        continue block5;
                                    }
                                    continue;
                                }
                                if (a.equals(LogManagerService.FILEHANDLER_PATTERN_PROPERTY)) {
                                    if (val.equals(LogManagerService.this.fileHandlerPatternDetail)) continue;
                                    LogManagerService.this.generateAttributeChangeEvent(LogManagerService.FILEHANDLER_PATTERN_PROPERTY, LogManagerService.this.fileHandlerPatternDetail, props);
                                    continue;
                                }
                                if (a.equals(LogManagerService.FILEHANDLER_FORMATTER_PROPERTY)) {
                                    if (val.equals(LogManagerService.this.fileHandlerFormatterDetail)) continue;
                                    LogManagerService.this.generateAttributeChangeEvent(LogManagerService.FILEHANDLER_FORMATTER_PROPERTY, LogManagerService.this.fileHandlerFormatterDetail, props);
                                    continue;
                                }
                                if (a.equals(LogManagerService.LOGFORMAT_DATEFORMAT_PROPERTY)) {
                                    if (val.equals(LogManagerService.this.logFormatDateFormatDetail)) continue;
                                    LogManagerService.this.generateAttributeChangeEvent(LogManagerService.LOGFORMAT_DATEFORMAT_PROPERTY, LogManagerService.this.logFormatDateFormatDetail, props);
                                    continue;
                                }
                                if (a.equals(LogManagerService.EXCLUDE_FIELDS_PROPERTY)) {
                                    val = val == null ? "" : val;
                                    String string = LogManagerService.this.excludeFields = LogManagerService.this.excludeFields == null ? "" : LogManagerService.this.excludeFields;
                                    if (val.equals(LogManagerService.this.excludeFields)) continue;
                                    LogManagerService.this.excludeFields = val;
                                    for (Handler handler : logMgr.getLogger("").getHandlers()) {
                                        if (!handler.getClass().equals(GFFileHandler.class)) continue;
                                        LogManagerService.this.gfFileHandler = (GFFileHandler)handler;
                                        LogManagerService.this.gfFileHandler.setExcludeFields(LogManagerService.this.excludeFields);
                                        continue block5;
                                    }
                                    continue;
                                }
                                if (a.equals(LogManagerService.MULTI_LINE_MODE_PROPERTY)) {
                                    Handler[] oldVal = Boolean.toString(LogManagerService.this.multiLineMode);
                                    if (val.equalsIgnoreCase((String)oldVal)) continue;
                                    LogManagerService.this.multiLineMode = Boolean.parseBoolean(val);
                                    for (Handler handler : logMgr.getLogger("").getHandlers()) {
                                        if (!handler.getClass().equals(GFFileHandler.class)) continue;
                                        LogManagerService.this.gfFileHandler = (GFFileHandler)handler;
                                        LogManagerService.this.gfFileHandler.setMultiLineMode(LogManagerService.this.multiLineMode);
                                        continue block5;
                                    }
                                    continue;
                                }
                                if (a.equals(LogManagerService.FAST_LOGGER_PROPERTY)) {
                                    if (val.equals(LogManagerService.this.fastLoggingDetail)) continue;
                                    LogManagerService.this.fastLoggingDetail = val;
                                    GFLogRecord.fastLogging = Boolean.parseBoolean(LogManagerService.this.fastLoggingDetail);
                                    continue;
                                }
                                if (a.equals(LogManagerService.COMPRESS_ON_ROTATION_PROPERTY)) {
                                    if (val.equals(LogManagerService.this.compressOnRotationDetail)) continue;
                                    LogManagerService.this.compressOnRotationDetail = val;
                                    for (Handler handler : logMgr.getLogger("").getHandlers()) {
                                        if (!handler.getClass().equals(GFFileHandler.class)) continue;
                                        LogManagerService.this.gfFileHandler = (GFFileHandler)handler;
                                        LogManagerService.this.gfFileHandler.setCompressionOnRotation(Boolean.parseBoolean(LogManagerService.this.compressOnRotationDetail));
                                        continue block5;
                                    }
                                    continue;
                                }
                                if (a.equals(LogManagerService.LOG_STANDARD_STREAMS_PROPERTY)) {
                                    if (val.equals(LogManagerService.this.logStandardStreamsDetail)) continue;
                                    LogManagerService.this.logStandardStreamsDetail = val;
                                    for (Handler handler : logMgr.getLogger("").getHandlers()) {
                                        if (!handler.getClass().equals(GFFileHandler.class)) continue;
                                        LogManagerService.this.gfFileHandler = (GFFileHandler)handler;
                                        LogManagerService.this.gfFileHandler.setLogStandardStreams(Boolean.parseBoolean(LogManagerService.this.logStandardStreamsDetail));
                                        continue block5;
                                    }
                                    continue;
                                }
                                if (a.equals(LogManagerService.PAYARA_NOTIFICATION_LOG_FILE_PROPERTY)) {
                                    if (val.equals(LogManagerService.this.payaraNotificationLogFileDetail)) continue;
                                    payaraNotificationLogFileHandlers = logMgr.getLogger(LogManagerService.this.payaraNotificationLogger).getHandlers();
                                    if (payaraNotificationLogFileHandlers.length > 0) {
                                        LogManagerService.this.payaraNotificationLogFileDetail = val;
                                        for (Handler handler : payaraNotificationLogFileHandlers) {
                                            if (!handler.getClass().equals(PayaraNotificationFileHandler.class)) continue;
                                            LogManagerService.this.pyFileHandler = (PayaraNotificationFileHandler)handler;
                                            LogManagerService.this.pyFileHandler.setLogFile(LogManagerService.this.payaraNotificationLogFileDetail);
                                            continue block5;
                                        }
                                        continue;
                                    }
                                    LOGGER.log(Level.INFO, LogManagerService.PAYARA_NOTIFICATION_NOT_USING_SEPARATE_LOG);
                                    continue;
                                }
                                if (a.equals(LogManagerService.PAYARA_NOTIFICATION_LOGTOFILE_PROPERTY)) {
                                    if (val.equals(LogManagerService.this.payaraNotificationlogToFileDetail)) continue;
                                    payaraNotificationLogFileHandlers = logMgr.getLogger(LogManagerService.this.payaraNotificationLogger).getHandlers();
                                    if (payaraNotificationLogFileHandlers.length > 0) {
                                        LogManagerService.this.payaraNotificationlogToFileDetail = val;
                                        for (Handler handler : payaraNotificationLogFileHandlers) {
                                            if (!handler.getClass().equals(PayaraNotificationFileHandler.class)) continue;
                                            LogManagerService.this.pyFileHandler = (PayaraNotificationFileHandler)handler;
                                            LogManagerService.this.pyFileHandler.setLogToFile(Boolean.parseBoolean(val));
                                            continue block5;
                                        }
                                        continue;
                                    }
                                    LOGGER.log(Level.INFO, LogManagerService.PAYARA_NOTIFICATION_NOT_USING_SEPARATE_LOG);
                                    continue;
                                }
                                if (a.equals(LogManagerService.PAYARA_NOTIFICATION_LOG_ROTATIONTIMELIMITINMINUTES_PROPERTY)) {
                                    if (val.equals(LogManagerService.this.payaraNotificationLogRotationOnTimeLimitInMinutesDetail)) continue;
                                    payaraNotificationLogFileHandlers = logMgr.getLogger(LogManagerService.this.payaraNotificationLogger).getHandlers();
                                    if (payaraNotificationLogFileHandlers.length > 0) {
                                        LogManagerService.this.payaraNotificationLogRotationOnTimeLimitInMinutesDetail = val;
                                        for (Handler handler : payaraNotificationLogFileHandlers) {
                                            if (!handler.getClass().equals(PayaraNotificationFileHandler.class)) continue;
                                            LogManagerService.this.pyFileHandler = (PayaraNotificationFileHandler)handler;
                                            LogManagerService.this.pyFileHandler.setRotationTimeLimitValue(Long.parseLong(val));
                                            continue block5;
                                        }
                                        continue;
                                    }
                                    LOGGER.log(Level.INFO, LogManagerService.PAYARA_NOTIFICATION_NOT_USING_SEPARATE_LOG);
                                    continue;
                                }
                                if (a.equals(LogManagerService.PAYARA_NOTIFICATION_LOG_ROTATIONLIMITINBYTES_PROPERTY)) {
                                    if (val.equals(LogManagerService.this.payaraNotificationLogRotationLimitInBytesDetail)) continue;
                                    payaraNotificationLogFileHandlers = logMgr.getLogger(LogManagerService.this.payaraNotificationLogger).getHandlers();
                                    if (payaraNotificationLogFileHandlers.length > 0) {
                                        LogManagerService.this.payaraNotificationLogRotationLimitInBytesDetail = val;
                                        for (Handler handler : payaraNotificationLogFileHandlers) {
                                            if (!handler.getClass().equals(PayaraNotificationFileHandler.class)) continue;
                                            LogManagerService.this.pyFileHandler = (PayaraNotificationFileHandler)handler;
                                            LogManagerService.this.pyFileHandler.setRotationLimitAttrValue(Integer.valueOf(val));
                                            continue block5;
                                        }
                                        continue;
                                    }
                                    LOGGER.log(Level.INFO, LogManagerService.PAYARA_NOTIFICATION_NOT_USING_SEPARATE_LOG);
                                    continue;
                                }
                                if (a.equals(LogManagerService.PAYARA_NOTIFICATION_LOG_ROTATIONONDATECHANGE_PROPERTY)) {
                                    if (val.equals(LogManagerService.this.payaraNotificationLogRotationOnDateChangeDetail)) continue;
                                    payaraNotificationLogFileHandlers = logMgr.getLogger(LogManagerService.this.payaraNotificationLogger).getHandlers();
                                    if (payaraNotificationLogFileHandlers.length > 0) {
                                        LogManagerService.this.payaraNotificationLogRotationOnDateChangeDetail = val;
                                        for (Handler handler : payaraNotificationLogFileHandlers) {
                                            if (!handler.getClass().equals(PayaraNotificationFileHandler.class)) continue;
                                            LogManagerService.this.pyFileHandler = (PayaraNotificationFileHandler)handler;
                                            LogManagerService.this.pyFileHandler.setRotationOnDateChange(Boolean.parseBoolean(val));
                                            continue block5;
                                        }
                                        continue;
                                    }
                                    LOGGER.log(Level.INFO, LogManagerService.PAYARA_NOTIFICATION_NOT_USING_SEPARATE_LOG);
                                    continue;
                                }
                                if (a.equals(LogManagerService.PAYARA_NOTIFICATION_LOG_MAXHISTORY_FILES_PROPERTY)) {
                                    if (val.equals(LogManagerService.this.payaraNotificationLogmaxHistoryFilesDetail)) continue;
                                    payaraNotificationLogFileHandlers = logMgr.getLogger(LogManagerService.this.payaraNotificationLogger).getHandlers();
                                    if (payaraNotificationLogFileHandlers.length > 0) {
                                        LogManagerService.this.payaraNotificationLogmaxHistoryFilesDetail = val;
                                        for (Handler handler : payaraNotificationLogFileHandlers) {
                                            if (!handler.getClass().equals(PayaraNotificationFileHandler.class)) continue;
                                            LogManagerService.this.pyFileHandler = (PayaraNotificationFileHandler)handler;
                                            LogManagerService.this.pyFileHandler.setMaxHistoryFiles(Integer.parseInt(val));
                                            continue block5;
                                        }
                                        continue;
                                    }
                                    LOGGER.log(Level.INFO, LogManagerService.PAYARA_NOTIFICATION_NOT_USING_SEPARATE_LOG);
                                    continue;
                                }
                                if (!a.equals(LogManagerService.PAYARA_NOTIFICATION_LOG_COMPRESS_ON_ROTATION_PROPERTY) || val.equals(LogManagerService.this.payaraNotificationLogCompressOnRotationDetail)) continue;
                                payaraNotificationLogFileHandlers = logMgr.getLogger(LogManagerService.this.payaraNotificationLogger).getHandlers();
                                if (payaraNotificationLogFileHandlers.length > 0) {
                                    LogManagerService.this.payaraNotificationLogCompressOnRotationDetail = val;
                                    for (Handler handler : payaraNotificationLogFileHandlers) {
                                        if (!handler.getClass().equals(PayaraNotificationFileHandler.class)) continue;
                                        LogManagerService.this.pyFileHandler = (PayaraNotificationFileHandler)handler;
                                        LogManagerService.this.pyFileHandler.setCompressionOnRotation(Boolean.parseBoolean(val));
                                        continue block5;
                                    }
                                    continue;
                                }
                                LOGGER.log(Level.INFO, LogManagerService.PAYARA_NOTIFICATION_NOT_USING_SEPARATE_LOG);
                            }
                            LOGGER.log(Level.INFO, "NCLS-LOGGING-00003");
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.SEVERE, "NCLS-LOGGING-00002", e);
                        }
                    }
                }

                @Override
                public void deleted(File deletedFile) {
                    LOGGER.log(Level.WARNING, "NCLS-LOGGING-00004", deletedFile.getAbsolutePath());
                }
            });
        }
    }

    private void setConsoleHandlerLogFormat(String formatterClassName, Map<String, String> props, LogManager logMgr) {
        block11: {
            block13: {
                block12: {
                    if (formatterClassName == null || formatterClassName.isEmpty()) {
                        formatterClassName = UniformLogFormatter.class.getName();
                    }
                    this.consoleHandlerFormatterDetail = formatterClassName;
                    this.excludeFields = props.get(EXCLUDE_FIELDS_PROPERTY);
                    this.multiLineMode = Boolean.parseBoolean(props.get(MULTI_LINE_MODE_PROPERTY));
                    if (!formatterClassName.equals(UniformLogFormatter.class.getName())) break block12;
                    UniformLogFormatter formatter = new UniformLogFormatter(this.excludeFields);
                    String cname = "com.sun.enterprise.server.logging.GFFileHandler";
                    this.recordBeginMarker = props.get(cname + ".logFormatBeginMarker");
                    if (this.recordBeginMarker == null || "".equals(this.recordBeginMarker)) {
                        LOGGER.log(Level.FINE, "Record begin marker is not a proper value so using default.");
                        this.recordBeginMarker = this.RECORD_BEGIN_MARKER;
                    }
                    this.recordEndMarker = props.get(cname + ".logFormatEndMarker");
                    if (this.recordEndMarker == null || "".equals(this.recordEndMarker)) {
                        LOGGER.log(Level.FINE, "Record end marker is not a proper value so using default.");
                        this.recordEndMarker = this.RECORD_END_MARKER;
                    }
                    this.recordFieldSeparator = props.get(cname + ".logFormatFieldSeparator");
                    if (this.recordFieldSeparator == null || "".equals(this.recordFieldSeparator) || this.recordFieldSeparator.length() > 1) {
                        LOGGER.log(Level.FINE, "Log Format field separator is not a proper value so using default.");
                        this.recordFieldSeparator = this.RECORD_FIELD_SEPARATOR;
                    }
                    this.recordDateFormat = props.get(cname + ".logFormatDateFormat");
                    if (this.recordDateFormat != null && !"".equals(this.recordDateFormat)) {
                        SimpleDateFormat sdf = new SimpleDateFormat(this.recordDateFormat);
                        try {
                            sdf.format(new Date());
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.FINE, "Date Format specified is wrong so using default.");
                            this.recordDateFormat = this.RECORD_DATE_FORMAT;
                        }
                    } else {
                        LOGGER.log(Level.FINE, "Date Format specified is wrong so using default.");
                        this.recordDateFormat = this.RECORD_DATE_FORMAT;
                    }
                    formatter.setRecordBeginMarker(this.recordBeginMarker);
                    formatter.setRecordEndMarker(this.recordEndMarker);
                    formatter.setRecordDateFormat(this.recordDateFormat);
                    formatter.setRecordFieldSeparator(this.recordFieldSeparator);
                    formatter.setMultiLineMode(this.multiLineMode);
                    for (Handler handler : logMgr.getLogger("").getHandlers()) {
                        if (!handler.getClass().equals(ConsoleHandler.class)) continue;
                        handler.setFormatter(formatter);
                        break block11;
                    }
                    break block11;
                }
                if (!formatterClassName.equals(ODLLogFormatter.class.getName())) break block13;
                ODLLogFormatter formatter = new ODLLogFormatter(this.excludeFields);
                formatter.setMultiLineMode(this.multiLineMode);
                for (Handler handler : logMgr.getLogger("").getHandlers()) {
                    if (!handler.getClass().equals(ConsoleHandler.class)) continue;
                    handler.setFormatter(formatter);
                    break block11;
                }
                break block11;
            }
            if (!formatterClassName.equals(JSONLogFormatter.class.getName())) break block11;
            JSONLogFormatter formatter = new JSONLogFormatter(this.excludeFields);
            for (Handler handler : logMgr.getLogger("").getHandlers()) {
                if (!handler.getClass().equals(ConsoleHandler.class)) continue;
                handler.setFormatter(formatter);
                break;
            }
        }
    }

    private void setDefaultLoggingProperties(Map<String, String> props) {
        this.serverLogFileDetail = props.get(SERVER_LOG_FILE_PROPERTY);
        this.handlerDetail = props.get(HANDLER_PROPERTY);
        this.handlerServices = props.get(HANDLER_SERVICES_PROPERTY);
        if (this.handlerServices == null) {
            this.handlerServices = "";
        }
        this.consoleHandlerFormatterDetail = props.get(CONSOLEHANDLER_FORMATTER_PROPERTY);
        this.gffileHandlerFormatterDetail = props.get(GFFILEHANDLER_FORMATTER_PROPERTY);
        this.rotationOnTimeLimitInMinutesDetail = props.get(ROTATIONTIMELIMITINMINUTES_PROPERTY);
        this.flushFrequencyDetail = props.get(FLUSHFREQUENCY_PROPERTY);
        this.filterHandlerDetails = props.get(FILEHANDLER_LIMIT_PROPERTY);
        this.logToFileDetail = props.get(LOGTOFILE_PROPERTY);
        this.logToConsoleDetail = props.get(LOGTOCONSOLE_PROPERTY);
        this.rotationInTimeLimitInBytesDetail = props.get(ROTATIONLIMITINBYTES_PROPERTY);
        this.useSystemLoggingDetail = props.get(USESYSTEMLOGGING_PROPERTY);
        this.fileHandlerCountDetail = props.get(FILEHANDLER_COUNT_PROPERTY);
        this.retainErrorsStaticticsDetail = props.get(RETAINERRORSSTATICTICS_PROPERTY);
        this.log4jVersionDetail = props.get(LOG4J_VERSION_PROPERTY);
        this.maxHistoryFilesDetail = props.get(MAXHISTORY_FILES_PROPERTY);
        this.rotationOnDateChangeDetail = props.get(ROTATIONONDATECHANGE_PROPERTY);
        this.fileHandlerPatternDetail = props.get(FILEHANDLER_PATTERN_PROPERTY);
        this.fileHandlerFormatterDetail = props.get(FILEHANDLER_FORMATTER_PROPERTY);
        this.logFormatDateFormatDetail = props.get(LOGFORMAT_DATEFORMAT_PROPERTY);
        this.compressOnRotationDetail = props.get(COMPRESS_ON_ROTATION_PROPERTY);
        this.logStandardStreamsDetail = props.get(LOG_STANDARD_STREAMS_PROPERTY);
        this.fastLoggingDetail = props.get(FAST_LOGGER_PROPERTY);
        this.payaraNotificationLogFileDetail = props.get(PAYARA_NOTIFICATION_LOG_FILE_PROPERTY);
        this.payaraNotificationlogToFileDetail = props.get(PAYARA_NOTIFICATION_LOGTOFILE_PROPERTY);
        this.payaraNotificationLogRotationOnDateChangeDetail = props.get(PAYARA_NOTIFICATION_LOG_ROTATIONONDATECHANGE_PROPERTY);
        this.payaraNotificationLogRotationOnTimeLimitInMinutesDetail = props.get(PAYARA_NOTIFICATION_LOG_ROTATIONTIMELIMITINMINUTES_PROPERTY);
        this.payaraNotificationLogRotationLimitInBytesDetail = props.get(PAYARA_NOTIFICATION_LOG_ROTATIONLIMITINBYTES_PROPERTY);
        this.payaraNotificationLogmaxHistoryFilesDetail = props.get(PAYARA_NOTIFICATION_LOG_MAXHISTORY_FILES_PROPERTY);
        this.payaraNotificationLogCompressOnRotationDetail = props.get(PAYARA_NOTIFICATION_LOG_COMPRESS_ON_ROTATION_PROPERTY);
        this.payaraNotificationLogFormatterDetail = props.get(PAYARA_NOTIFICATION_LOG_FORMATTER_PROPERTY);
        this.payaraJsonUnderscorePrefix = props.get(PAYARA_JSONLOGFORMATTER_UNDERSCORE);
    }

    private Collection<Handler> getHandlerServices(Map<String, String> props) {
        String handlerClassName;
        String[] handlerServicesArray;
        HashSet<String> handlerServicesSet = new HashSet<String>();
        handlerServicesSet.add(GFFileHandler.class.getName());
        for (String handlerService : handlerServicesArray = this.handlerServices.split(",")) {
            handlerServicesSet.add(handlerService);
        }
        List handlers = this.habitat.getAllServices(Handler.class, new Annotation[0]);
        ArrayList<Handler> result = new ArrayList<Handler>();
        ArrayList<Handler> customHandlers = new ArrayList<Handler>();
        GFFileHandler gfFileHandler = null;
        for (Handler handler : handlers) {
            handlerClassName = handler.getClass().getName();
            if (handlerServicesSet.contains(handlerClassName)) {
                result.add(handler);
            }
            if (handlerClassName.equals(GFFileHandler.class.getName())) {
                gfFileHandler = (GFFileHandler)handler;
                continue;
            }
            if (handlerClassName.equals(PayaraNotificationFileHandler.class.getName())) continue;
            customHandlers.add(handler);
        }
        for (Handler handler : customHandlers) {
            handlerClassName = handler.getClass().getName();
            String formatterClassName = props.get(handlerClassName + ".formatter");
            Formatter formatter = this.getCustomFormatter(formatterClassName, gfFileHandler);
            if (formatter == null) continue;
            handler.setFormatter(formatter);
        }
        return result;
    }

    private Formatter getCustomFormatter(String formatterClassName, GFFileHandler gfFileHandler) {
        try {
            Class<?> customFormatterClass = ClassLoader.getSystemClassLoader().loadClass(formatterClassName);
            return (Formatter)customFormatterClass.newInstance();
        }
        catch (Exception e) {
            return gfFileHandler.findFormatterService(formatterClassName);
        }
    }

    public void generateAttributeChangeEvent(String property, String propertyDetail, Map props) {
        PropertyChangeEvent pce = new PropertyChangeEvent(this, property, propertyDetail, props.get(property));
        UnprocessedChangeEvents ucel = new UnprocessedChangeEvents(new UnprocessedChangeEvent(pce, "server log file attribute " + property + " changed."));
        ArrayList<UnprocessedChangeEvents> b = new ArrayList<UnprocessedChangeEvents>();
        b.add(ucel);
        this.ucl.unprocessedTransactedEvents(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHandler(Handler handler) {
        Logger rootLogger = Logger.getLogger("");
        if (rootLogger != null) {
            Map<String, Handler> map = this.gfHandlers;
            synchronized (map) {
                rootLogger.addHandler(handler);
                String handlerName = handler.toString();
                this.gfHandlers.put(handlerName.substring(0, handlerName.indexOf(64)), handler);
            }
        }
    }

    public void preDestroy() {
        for (ServiceHandle i : this.habitat.getAllServiceHandles((Filter)BuilderHelper.createContractFilter((String)Handler.class.getName()))) {
            i.destroy();
        }
        System.setOut(this.oStdOutBackup);
        System.setErr(this.oStdErrBackup);
        System.out.println("Completed shutdown of Log manager service");
    }

    public PrintStream getErrStream() {
        return this.oStdErrBackup;
    }

    public PrintStream getOutStream() {
        return this.oStdOutBackup;
    }
}

