/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.work;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.corba.ee.spi.threadpool.WorkQueue;
import com.sun.enterprise.connectors.work.LogFacade;
import com.sun.enterprise.connectors.work.OneWork;
import com.sun.enterprise.connectors.work.context.WorkContextHandlerImpl;
import com.sun.enterprise.connectors.work.monitor.WorkManagementProbeProvider;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ResourceAdapterAssociation;
import jakarta.resource.spi.work.ExecutionContext;
import jakarta.resource.spi.work.Work;
import jakarta.resource.spi.work.WorkCompletedException;
import jakarta.resource.spi.work.WorkEvent;
import jakarta.resource.spi.work.WorkException;
import jakarta.resource.spi.work.WorkListener;
import jakarta.resource.spi.work.WorkRejectedException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.logging.annotation.LogMessageInfo;

public final class WorkCoordinator {
    static final int WAIT_UNTIL_START = 1;
    static final int WAIT_UNTIL_FINISH = 2;
    static final int NO_WAIT = 3;
    static final int CREATED = 1;
    static final int STARTED = 2;
    static final int COMPLETED = 3;
    static final int TIMEDOUT = 4;
    private volatile int waitMode;
    private volatile int state = 1;
    private final Work work;
    private final long timeout;
    private long startTime;
    private final ExecutionContext ec;
    private final WorkQueue queue;
    private final WorkListener listener;
    private volatile WorkException exception;
    private final Object lock;
    private static int seed;
    private final int id;
    private static final Logger logger;
    private WorkManagementProbeProvider probeProvider = null;
    private final ConnectorRuntime runtime;
    private String raName = null;
    private final WorkContextHandlerImpl contextHandler;
    @LogMessageInfo(message="Resource adapter association failed.", comment="Failed to associate Resource Adapter bean to Work instance.", level="SEVERE", cause="Resource Adapter throws exception during ManagedConnectionFactory.setResourceAdapter().", action="[1] If you are using third party resource adapter, contact resource adapter vendor.[2] If you are a resource adapter developer, please check the resource adapter code.", publish=true)
    private static final String RAR_RA_ASSOCIATE_ERROR = "AS-RAR-05005";

    public WorkCoordinator(Work work, long timeout, ExecutionContext ec, WorkQueue queue, WorkListener listener, WorkManagementProbeProvider probeProvider, ConnectorRuntime runtime, String raName, WorkContextHandlerImpl handler) {
        this.work = work;
        this.timeout = timeout;
        this.ec = ec;
        this.queue = queue;
        this.listener = listener;
        this.id = WorkCoordinator.increaseSeed();
        this.runtime = runtime;
        this.lock = new Object();
        this.probeProvider = probeProvider;
        this.raName = raName;
        this.contextHandler = handler;
    }

    public String getRAName() {
        return this.raName;
    }

    public void submitWork(int waitModeValue) {
        this.waitMode = waitModeValue;
        this.startTime = System.currentTimeMillis();
        if (this.listener != null) {
            this.listener.workAccepted(new WorkEvent(this, 1, this.work, null));
        }
        if (this.probeProvider != null) {
            this.probeProvider.workSubmitted(this.raName);
            this.probeProvider.workQueued(this.raName);
        }
        this.queue.addWork((com.sun.corba.ee.spi.threadpool.Work)new OneWork(this.work, this, Thread.currentThread().getContextClassLoader()));
    }

    public void preInvoke() {
        if (this.waitMode == 3 && this.timeout > -1L) {
            long elapsedTime = System.currentTimeMillis() - this.startTime;
            if (this.probeProvider != null) {
                this.probeProvider.workWaitedFor(this.raName, elapsedTime);
            }
            if (elapsedTime > this.timeout) {
                this.workTimedOut();
            }
        }
        if (!this.proceed()) {
            if (this.probeProvider != null) {
                this.probeProvider.workDequeued(this.raName);
            }
            return;
        }
        if (this.probeProvider != null) {
            this.probeProvider.workProcessingStarted(this.raName);
            this.probeProvider.workDequeued(this.raName);
        }
        if (this.work instanceof ResourceAdapterAssociation) {
            try {
                this.runtime.associateResourceAdapter(this.raName, (ResourceAdapterAssociation)((Object)this.work));
            }
            catch (ResourceException re) {
                logger.log(Level.SEVERE, RAR_RA_ASSOCIATE_ERROR, re);
            }
        }
        this.setState(2);
        if (this.waitMode == 1) {
            this.unLock();
        }
        if (this.listener != null) {
            this.listener.workStarted(new WorkEvent(this, 3, this.work, null));
        }
        SecurityContext.setUnauthenticatedContext();
    }

    public void setupContext(OneWork oneWork) throws WorkException {
        this.contextHandler.setupContext(WorkCoordinator.getExecutionContext(this.ec, this.work), this, oneWork);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void postInvoke() {
        boolean txImported = WorkCoordinator.getExecutionContext(this.ec, this.work) != null && WorkCoordinator.getExecutionContext(this.ec, this.work).getXid() != null;
        try {
            JavaEETransactionManager tm = this.getTransactionManager();
            if (txImported) {
                tm.release(WorkCoordinator.getExecutionContext(this.ec, this.work).getXid());
            }
        }
        catch (WorkException ex) {
            this.setException(ex);
        }
        finally {
            try {
                if (!this.isTimedOut()) {
                    if (this.probeProvider != null) {
                        this.probeProvider.workProcessingCompleted(this.raName);
                        this.probeProvider.workProcessed(this.raName);
                    }
                    if (this.listener != null) {
                        this.listener.workCompleted(new WorkEvent(this, 4, this.work, this.getException()));
                    }
                }
                if (txImported) {
                    this.getTransactionManager().clearThreadTx();
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage());
            }
            finally {
                SecurityContext.setUnauthenticatedContext();
            }
        }
        this.setState(3);
        if (this.waitMode == 2) {
            this.unLock();
        }
    }

    private void workTimedOut() {
        this.setState(4);
        this.exception = new WorkRejectedException();
        this.exception.setErrorCode("1");
        if (this.listener != null) {
            this.listener.workRejected(new WorkEvent(this, 2, this.work, this.exception));
        }
        if (this.probeProvider != null) {
            this.probeProvider.workTimedOut(this.raName);
        }
    }

    public boolean proceed() {
        return !this.isTimedOut() && this.exception == null;
    }

    public boolean isTimedOut() {
        return this.getState() == 4;
    }

    public WorkException getException() {
        return this.exception;
    }

    public void setException(Throwable e) {
        if (this.getState() < 2) {
            if (e instanceof WorkRejectedException) {
                this.exception = (WorkException)e;
            } else if (e instanceof WorkException) {
                WorkException we = (WorkException)e;
                this.exception = new WorkRejectedException(we);
                this.exception.setErrorCode(we.getErrorCode());
            } else {
                this.exception = new WorkRejectedException(e);
                this.exception.setErrorCode("0");
            }
        } else if (e instanceof WorkCompletedException) {
            this.exception = (WorkException)e;
        } else if (e instanceof WorkException) {
            WorkException we = (WorkException)e;
            this.exception = new WorkCompletedException(we);
            this.exception.setErrorCode(we.getErrorCode());
        } else {
            this.exception = new WorkCompletedException(e);
            this.exception.setErrorCode("0");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() {
        block13: {
            if (!this.lockRequired()) {
                return;
            }
            try {
                Object object = this.lock;
                synchronized (object) {
                    while (this.checkStateBeforeLocking()) {
                        if (this.timeout != -1L) {
                            this.lock.wait(this.timeout);
                            continue;
                        }
                        this.lock.wait();
                    }
                }
                if (this.getState() < 2) {
                    this.workTimedOut();
                }
                if (!this.lockRequired()) break block13;
                object = this.lock;
                synchronized (object) {
                    if (this.checkStateBeforeLocking()) {
                        this.lock.wait();
                    }
                }
            }
            catch (Exception e) {
                this.setException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unLock() {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
        catch (Exception e) {
            this.setException(e);
        }
    }

    public String toString() {
        return this.id + ":" + this.work;
    }

    public synchronized void setState(int state) {
        logger.finest(() -> String.format("setState(state=%s)", state));
        this.state = state;
    }

    public synchronized int getState() {
        return this.state;
    }

    private boolean lockRequired() {
        if (!this.proceed()) {
            return false;
        }
        if (this.waitMode == 3) {
            return false;
        }
        if (this.waitMode == 2) {
            return this.getState() < 3;
        }
        if (this.waitMode == 1) {
            return this.getState() < 2;
        }
        return false;
    }

    private boolean checkStateBeforeLocking() {
        if (this.waitMode == 2) {
            return this.state < 3;
        }
        if (this.waitMode == 1) {
            return this.state < 2;
        }
        return false;
    }

    private JavaEETransactionManager getTransactionManager() {
        return this.runtime.getTransactionManager();
    }

    public static ExecutionContext getExecutionContext(ExecutionContext ec, Work work) {
        if (ec == null) {
            return WorkContextHandlerImpl.getExecutionContext(work);
        }
        return ec;
    }

    public static synchronized int increaseSeed() {
        return ++seed;
    }

    static {
        logger = LogFacade.getLogger();
    }
}

