/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.jms.system;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.connectors.jms.config.JmsHost;
import com.sun.enterprise.connectors.jms.config.JmsService;
import com.sun.enterprise.connectors.jms.system.ActiveJmsResourceAdapter;
import com.sun.enterprise.connectors.jms.system.JMSConfigListener;
import com.sun.enterprise.connectors.jms.system.JmsInitialisationException;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Service;

@Service
@RunLevel(value=20, mode=0)
public class JmsProviderLifecycle
implements PostConstruct {
    private static final String JMS_INITIALIZE_ON_DEMAND = "org.glassfish.jms.InitializeOnDemand";
    public static final String JMS_SERVICE = "jms-service";
    BROKER_TYPE brokerType;
    @Inject
    @Named(value="default-instance-name")
    Config config;
    @Inject
    private Provider<JMSConfigListener> jmsConfigListenerProvider;
    @Inject
    private Provider<ConnectorRuntime> connectorRuntimeProvider;
    @Inject
    private ActiveJmsResourceAdapter activeJmsResourceAdapter;

    public void postConstruct() {
        JmsService jmsService = (JmsService)this.config.getExtensionByType(JmsService.class);
        this.brokerType = BROKER_TYPE.valueOf(jmsService.getType());
        this.configureConfigListener();
        if (this.brokerType == BROKER_TYPE.DISABLED) {
            return;
        }
        if (this.eagerStartupRequired()) {
            try {
                this.initializeBroker();
            }
            catch (ConnectorRuntimeException e) {
                e.printStackTrace();
                e.printStackTrace();
            }
        }
        try {
            this.activeJmsResourceAdapter.initializeLazyListener(jmsService);
        }
        catch (JmsInitialisationException ex) {
            Logger.getLogger(JmsProviderLifecycle.class.getName()).log(Level.SEVERE, null, ex);
            throw new IllegalStateException(ex);
        }
    }

    private void configureConfigListener() {
        this.jmsConfigListenerProvider.get();
    }

    public void initializeBroker() throws ConnectorRuntimeException {
        if (this.brokerType != BROKER_TYPE.DISABLED) {
            String module = "jmsra";
            String loc = ConnectorsUtil.getSystemModuleLocation((String)module);
            ConnectorRuntime connectorRuntime = (ConnectorRuntime)this.connectorRuntimeProvider.get();
            connectorRuntime.createActiveResourceAdapter(loc, module, null);
        }
    }

    private boolean eagerStartupRequired() {
        JmsService jmsService = this.getJmsService();
        if (jmsService == null) {
            return false;
        }
        List<JmsHost> jmsHostList = jmsService.getJmsHost();
        if (jmsHostList == null) {
            return false;
        }
        String defaultJmsHostName = jmsService.getDefaultJmsHost();
        JmsHost defaultJmsHost = null;
        for (JmsHost host : jmsHostList) {
            if (defaultJmsHostName == null || !defaultJmsHostName.equals(host.getName())) continue;
            defaultJmsHost = host;
            break;
        }
        if (defaultJmsHost == null && jmsHostList.size() > 0) {
            defaultJmsHost = jmsHostList.get(0);
        }
        boolean lazyInit = false;
        if (defaultJmsHost != null) {
            lazyInit = Boolean.parseBoolean(defaultJmsHost.getLazyInit());
        }
        if (this.brokerType == BROKER_TYPE.REMOTE) {
            return false;
        }
        String jmsInitializeOnDemand = System.getProperty(JMS_INITIALIZE_ON_DEMAND);
        if ("true".equals(jmsInitializeOnDemand)) {
            return false;
        }
        if (this.brokerType == BROKER_TYPE.EMBEDDED && !lazyInit) {
            return true;
        }
        return this.brokerType == BROKER_TYPE.LOCAL;
    }

    private JmsService getJmsService() {
        return (JmsService)this.config.getExtensionByType(JmsService.class);
    }

    static enum BROKER_TYPE {
        DISABLED,
        EMBEDDED,
        LOCAL,
        REMOTE;

    }
}

