/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsft.component;

import com.sun.jsft.component.DeferredFragment;
import com.sun.jsft.tasks.TaskManager;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIComponentBase;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.ComponentSystemEvent;
import jakarta.faces.event.ComponentSystemEventListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class FragmentRenderer
extends UIComponentBase
implements ComponentSystemEventListener {
    private transient int fragsToRender = 1;
    private transient List<DeferredFragment> fragments = new ArrayList<DeferredFragment>();
    private transient Queue<DeferredFragment> renderQueue = new ConcurrentLinkedQueue<DeferredFragment>();
    public static final String FAMILY = FragmentRenderer.class.getName();

    @Override
    public String getFamily() {
        return FAMILY;
    }

    @Override
    public boolean getRendersChildren() {
        return true;
    }

    @Override
    public void encodeBegin(FacesContext context) throws IOException {
        System.out.println("Starting FragmentRenderer...");
        TaskManager.getInstance().start();
    }

    @Override
    public void encodeChildren(FacesContext context) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encodeEnd(FacesContext context) throws IOException {
        this.fragsToRender = this.getFragmentCount();
        DeferredFragment comp = null;
        while (this.fragsToRender > 0) {
            Queue<DeferredFragment> queue = this.renderQueue;
            synchronized (queue) {
                if (this.renderQueue.isEmpty()) {
                    try {
                        this.renderQueue.wait(30000L);
                        if (this.renderQueue.isEmpty()) {
                            System.out.println("EMPTY QUEUE!");
                            return;
                        }
                    }
                    catch (InterruptedException ex) {
                        System.out.println("Interrupted!");
                        return;
                    }
                }
                comp = this.renderQueue.poll();
            }
            if (comp == null) continue;
            --this.fragsToRender;
            try {
                System.out.println("Encoding: " + comp.getId());
                comp.encodeAll(FacesContext.getCurrentInstance());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        System.out.println("Ending FragmentRenderer..." + this.fragsToRender);
    }

    public int getFragmentCount() {
        return this.fragments.size();
    }

    public void addDeferredFragment(DeferredFragment fragment) {
        this.fragments.add(fragment);
    }

    @Override
    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        this.processDeferredFragment((DeferredFragment)event.getComponent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDeferredFragment(DeferredFragment comp) {
        String key = ":" + comp.getPlaceHolderId();
        UIComponent placeHolder = comp.findComponent(key);
        if (placeHolder != null) {
            List<UIComponent> peers = placeHolder.getParent().getChildren();
            int index = peers.indexOf(placeHolder);
            peers.set(index, comp);
        }
        Queue<DeferredFragment> queue = this.renderQueue;
        synchronized (queue) {
            this.renderQueue.add(comp);
            this.renderQueue.notifyAll();
        }
    }
}

