/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.remote;

import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.remote.ExceptionAnalyzer;
import com.sun.enterprise.admin.cli.remote.RemoteCLICommand;
import java.io.IOException;
import java.net.ConnectException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.AuthenticationException;
import org.glassfish.api.admin.CommandException;

public class DASUtils {
    private static final Logger logger = Logger.getLogger("jakarta.enterprise.admin.cli.remote");

    private DASUtils() {
    }

    public static boolean pingDASQuietly(ProgramOptions programOpts, Environment env) {
        try {
            RemoteCLICommand cmd = new RemoteCLICommand("version", programOpts, env);
            cmd.executeAndReturnOutput("version");
            return true;
        }
        catch (AuthenticationException aex) {
            return true;
        }
        catch (Exception ex) {
            ExceptionAnalyzer ea = new ExceptionAnalyzer(ex);
            if (ea.getFirstInstanceOf(ConnectException.class) != null) {
                logger.log(Level.FINER, "Got java.net.ConnectException");
                return false;
            }
            if (ea.getFirstInstanceOf(IOException.class) != null) {
                logger.log(Level.FINER, "It appears that server has started, but for some reason this exception was thrown: {0}", ex.getMessage());
                return true;
            }
            return false;
        }
    }

    public static Error pingDASWithAuth(ProgramOptions programOpts, Environment env) throws CommandException {
        try {
            RemoteCLICommand cmd = new RemoteCLICommand("version", programOpts, env);
            cmd.executeAndReturnOutput("version");
        }
        catch (AuthenticationException aex) {
            return Error.AUTHENTICATION;
        }
        catch (Exception ex) {
            ExceptionAnalyzer ea = new ExceptionAnalyzer(ex);
            if (ea.getFirstInstanceOf(ConnectException.class) != null) {
                logger.log(Level.FINER, "Got java.net.ConnectException");
                return Error.CONNECTION;
            }
            if (ea.getFirstInstanceOf(IOException.class) != null) {
                logger.log(Level.FINER, "It appears that server has started, but for some reason this exception was thrown: {0}", ex.getMessage());
                return Error.IO;
            }
            return Error.UNKNOWN;
        }
        return Error.NONE;
    }

    public static enum Error {
        NONE,
        AUTHENTICATION,
        CONNECTION,
        IO,
        UNKNOWN;

    }
}

