/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util;

import com.sun.enterprise.admin.util.AdminLoggerInfo;
import com.sun.enterprise.admin.util.AsadminTrustManager;
import com.sun.enterprise.admin.util.AuthenticationInfo;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public final class HttpConnectorAddress {
    static final String HTTP_CONNECTOR = "http";
    static final String HTTPS_CONNECTOR = "https";
    public static final String AUTHORIZATION_KEY = "Authorization";
    private static final String AUTHORIZATION_TYPE = "Basic ";
    private static final String DEFAULT_PROTOCOL = "TLSv1.3";
    private String host;
    private int port;
    private String path;
    private boolean secure;
    private AuthenticationInfo authInfo;
    private boolean interactive = true;
    private SSLSocketFactory sslSocketFactory;
    private static final Logger logger = AdminLoggerInfo.getLogger();

    public HttpConnectorAddress() {
    }

    public HttpConnectorAddress(String host, int port) {
        this(host, port, false);
    }

    public HttpConnectorAddress(String host, int port, boolean secure) {
        this(host, port, secure, null);
    }

    public HttpConnectorAddress(String host, int port, boolean secure, String path) {
        this(host, port, secure, path, null);
    }

    public HttpConnectorAddress(String host, int port, SSLSocketFactory sslSocketFactory) {
        this(host, port, true, null, sslSocketFactory);
    }

    public HttpConnectorAddress(String host, int port, boolean secure, String path, SSLSocketFactory sslSocketFactory) {
        this.host = host;
        this.port = port;
        this.secure = secure;
        this.path = path;
        this.sslSocketFactory = sslSocketFactory;
    }

    public URLConnection openConnection(String path) throws IOException {
        URLConnection cnx;
        if (path == null || path.trim().length() == 0) {
            path = this.path;
        }
        if (!((cnx = this.openConnection(this.toURL(path))) instanceof HttpsURLConnection)) {
            return cnx;
        }
        this.configureSSL((HttpsURLConnection)cnx);
        return cnx;
    }

    private void configureSSL(HttpsURLConnection httpsCnx) throws IOException {
        httpsCnx.setHostnameVerifier(new BasicHostnameVerifier(this.host));
        httpsCnx.setSSLSocketFactory(this.getOrCreateSSLSocketFactory());
    }

    private synchronized SSLSocketFactory getOrCreateSSLSocketFactory() {
        if (this.sslSocketFactory == null) {
            this.sslSocketFactory = this.createAdminSSLSocketFactory(null, null);
        }
        return this.sslSocketFactory;
    }

    private SSLSocketFactory createAdminSSLSocketFactory(String alias, String protocol) {
        try {
            if (protocol == null) {
                String clientHttpsProtocol = System.getProperty("fish.payara.clientHttpsProtocol");
                if (clientHttpsProtocol != null) {
                    switch (clientHttpsProtocol) {
                        case "TLSv1.2": {
                            protocol = "TLSv1.2";
                            logger.log(Level.FINE, "NCLS-ADMIN-00021", protocol);
                            break;
                        }
                        case "TLSv1.3": {
                            protocol = DEFAULT_PROTOCOL;
                            logger.log(Level.FINE, "NCLS-ADMIN-00021", protocol);
                            break;
                        }
                        default: {
                            protocol = DEFAULT_PROTOCOL;
                            Object[] logParams = new String[]{protocol, clientHttpsProtocol};
                            logger.log(Level.INFO, "NCLS-ADMIN-00019", logParams);
                            break;
                        }
                    }
                } else {
                    protocol = DEFAULT_PROTOCOL;
                    logger.log(Level.FINE, "NCLS-ADMIN-00020", protocol);
                }
            }
            SSLContext cntxt = SSLContext.getInstance(protocol);
            AsadminTrustManager atm = new AsadminTrustManager();
            atm.setInteractive(this.interactive);
            cntxt.init(null, new TrustManager[]{atm}, null);
            return cntxt.getSocketFactory();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getConnectorType() {
        return this.isSecure() ? HTTPS_CONNECTOR : HTTP_CONNECTOR;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getPath() {
        return this.path == null ? "/" : this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public AuthenticationInfo getAuthenticationInfo() {
        return this.authInfo;
    }

    public void setAuthenticationInfo(AuthenticationInfo authInfo) {
        this.authInfo = authInfo;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setInteractive(boolean mode) {
        this.interactive = mode;
    }

    public URL toURL(String path) throws MalformedURLException {
        return new URL(this.getConnectorType(), this.getHost(), this.getPort(), path == null ? "" : path);
    }

    public synchronized SSLSocketFactory getSSLSocketFactory() {
        return this.sslSocketFactory;
    }

    private String getUser() {
        return this.authInfo != null ? this.authInfo.getUser() : "";
    }

    private char[] getPassword() {
        String password = this.authInfo != null ? this.authInfo.getPassword() : "";
        return password != null ? password.toCharArray() : null;
    }

    private URLConnection openConnection(URL url) throws IOException {
        return this.setOptions(this.makeConnection(url));
    }

    private URLConnection makeConnection(URL url) throws IOException {
        return url.openConnection();
    }

    private URLConnection setOptions(URLConnection uc) {
        uc.setDoOutput(true);
        uc.setUseCaches(false);
        uc.setRequestProperty("Connection", "Keep-Alive");
        return this.setAuthentication(uc);
    }

    private URLConnection setAuthentication(URLConnection uc) {
        if (this.authInfo != null) {
            uc.setRequestProperty(AUTHORIZATION_KEY, this.getBasicAuthString());
        }
        return uc;
    }

    public final String getBasicAuthString() {
        String user = this.getUser();
        char[] password = this.getPassword();
        return AUTHORIZATION_TYPE + this.getBase64Encoded((user == null ? "" : user) + ":" + (password == null ? "" : new String(password))).replaceAll(System.getProperty("line.separator"), "");
    }

    private String getBase64Encoded(String clearString) {
        return new String(Base64.getMimeEncoder().encode(clearString.getBytes()), StandardCharsets.UTF_8);
    }

    public static class BasicHostnameVerifier
    implements HostnameVerifier {
        private final String host;

        public BasicHostnameVerifier(String host) {
            if (host == null) {
                throw new IllegalArgumentException("null host");
            }
            this.host = host;
        }

        @Override
        public boolean verify(String s, SSLSession sslSession) {
            return this.host.equals(s);
        }
    }
}

