/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util.cache;

import com.sun.enterprise.admin.util.CachedCommandModel;
import com.sun.enterprise.admin.util.CommandModelData;
import com.sun.enterprise.admin.util.cache.DataProvider;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandModel;
import org.jvnet.hk2.annotations.Service;

@Service
public class CommandModelDataProvider
implements DataProvider {
    private static final String ADDEDUPLOADOPTIONS_ELEMENT = "added-upload-options";
    private static final String ALIAS_ELEMENT = "alias";
    private static final String CLASS_ELEMENT = "class";
    private static final String DEFAULT_VALUE_ELEMENT = "default-value";
    private static final String PROMPT_ELEMENT = "prompt";
    private static final String PROMPT_AGAIN_ELEMENT = "prompt-again";
    private static final String ETAG_ELEMENT = "e-tag";
    private static final String NAME_ELEMENT = "name";
    private static final String OBSOLETE_ELEMENT = "obsolete";
    private static final String OPTIONAL_ELEMENT = "optional";
    private static final String PASSWORD_ELEMENT = "password";
    private static final String SHORTNAME_ELEMENT = "short-name";
    private static final String UNKNOWN_ARE_OPERANDS_ELEMENT = "unknown-are-operands";
    private static final String ROOT_ELEMENT = "command-model";
    private static final String PRIMARY_ELEMENT = "primary";
    private static final String MULTIPLE_ELEMENT = "multiple";
    private static final String USAGE_ELEMENT = "usage";
    private Charset charset;

    public CommandModelDataProvider() {
        try {
            this.charset = Charset.forName("UTF-8");
        }
        catch (Exception ex) {
            this.charset = Charset.defaultCharset();
        }
    }

    @Override
    public boolean accept(Class clazz) {
        return clazz == CommandModel.class || clazz == CachedCommandModel.class || clazz == CommandModelData.class;
    }

    @Override
    public void writeToStream(Object o, OutputStream stream) throws IOException {
        if (o == null) {
            return;
        }
        this.writeToStreamSimpleFormat((CommandModel)o, stream);
    }

    public void writeToStreamSimpleFormat(CommandModel cm, OutputStream stream) throws IOException {
        if (cm == null) {
            return;
        }
        try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(stream, this.charset));){
            String str = cm.getCommandName();
            if (str != null && !str.isEmpty()) {
                bw.write(ROOT_ELEMENT);
                bw.write(": ");
                bw.write(str);
                bw.newLine();
            }
            bw.write(ETAG_ELEMENT);
            bw.write(": ");
            bw.write(CachedCommandModel.computeETag(cm));
            bw.newLine();
            if (cm.unknownOptionsAreOperands()) {
                bw.write(UNKNOWN_ARE_OPERANDS_ELEMENT);
                bw.write(": true");
                bw.newLine();
            }
            if (cm instanceof CachedCommandModel) {
                CachedCommandModel ccm = (CachedCommandModel)cm;
                if (ccm.isAddedUploadOption()) {
                    bw.write(ADDEDUPLOADOPTIONS_ELEMENT);
                    bw.write(": true");
                    bw.newLine();
                }
                if ((str = ccm.getUsage()) != null && !str.isEmpty()) {
                    bw.write(USAGE_ELEMENT);
                    bw.write(": ");
                    bw.write(this.escapeEndLines(str));
                    bw.newLine();
                }
            }
            for (CommandModel.ParamModel paramModel : cm.getParameters()) {
                Param param;
                bw.newLine();
                bw.write(NAME_ELEMENT);
                bw.write(": ");
                bw.write(paramModel.getName());
                bw.newLine();
                if (paramModel.getType() != null) {
                    bw.write(CLASS_ELEMENT);
                    bw.write(": ");
                    bw.write(paramModel.getType().getName());
                    bw.newLine();
                }
                if ((str = (param = paramModel.getParam()).shortName()) != null && !str.isEmpty()) {
                    bw.write(SHORTNAME_ELEMENT);
                    bw.write(": ");
                    bw.write(str);
                    bw.newLine();
                }
                if ((str = param.alias()) != null && !str.isEmpty()) {
                    bw.write(ALIAS_ELEMENT);
                    bw.write(": ");
                    bw.write(str);
                    bw.newLine();
                }
                if (param.optional()) {
                    bw.write(OPTIONAL_ELEMENT);
                    bw.write(": true");
                    bw.newLine();
                }
                if (param.obsolete()) {
                    bw.write(OBSOLETE_ELEMENT);
                    bw.write(": true");
                    bw.newLine();
                }
                if ((str = param.defaultValue()) != null && !str.isEmpty()) {
                    bw.write(DEFAULT_VALUE_ELEMENT);
                    bw.write(": ");
                    bw.write(str);
                    bw.newLine();
                }
                if (param.primary()) {
                    bw.write(PRIMARY_ELEMENT);
                    bw.write(": true");
                    bw.newLine();
                }
                if (param.multiple()) {
                    bw.write(MULTIPLE_ELEMENT);
                    bw.write(": true");
                    bw.newLine();
                }
                if (param.password()) {
                    bw.write(PASSWORD_ELEMENT);
                    bw.write(": true");
                    bw.newLine();
                }
                if (!(paramModel instanceof CommandModelData.ParamModelData)) continue;
                str = ((CommandModelData.ParamModelData)paramModel).getPrompt();
                if (str != null && !str.isEmpty()) {
                    bw.write(PROMPT_ELEMENT);
                    bw.write(": ");
                    bw.write(this.escapeEndLines(str));
                    bw.newLine();
                }
                if ((str = ((CommandModelData.ParamModelData)paramModel).getPromptAgain()) == null || str.isEmpty()) continue;
                bw.write(PROMPT_AGAIN_ELEMENT);
                bw.write(": ");
                bw.write(this.escapeEndLines(str));
                bw.newLine();
            }
        }
    }

    private String escapeEndLines(String str) {
        if (str == null) {
            return null;
        }
        return str.replace("\n", "${NL}").replace("\r", "${RC}");
    }

    private String resolveEndLines(String str) {
        if (str == null) {
            return null;
        }
        return str.replace("${NL}", "\n").replace("${RC}", "\r");
    }

    @Override
    public Object toInstance(InputStream stream, Class clazz) throws IOException {
        return this.toInstanceSimpleFormat(stream);
    }

    private CommandModel toInstanceSimpleFormat(InputStream stream) throws IOException {
        CachedCommandModel result = null;
        boolean inParam = false;
        String name = null;
        String eTag = null;
        boolean unknownAreOperands = false;
        String usage = null;
        boolean addedUploadOption = false;
        String pName = null;
        Class<?> pCls = null;
        boolean pOptional = false;
        String pDefaultValue = null;
        String pShortName = null;
        boolean pObsolete = false;
        String pAlias = null;
        boolean pPrimary = false;
        boolean pMultiple = false;
        boolean pPassword = false;
        String pPrompt = null;
        String pPromptAgain = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, this.charset));){
            String line;
            while ((line = reader.readLine()) != null) {
                int ind = line.indexOf(58);
                if (ind <= 0) continue;
                String key = line.substring(0, ind);
                String value = line.substring(ind + 1).trim();
                if (inParam) {
                    switch (key) {
                        case "name": {
                            CommandModelData.ParamModelData pmd = new CommandModelData.ParamModelData(pName, pCls, pOptional, pDefaultValue, pShortName, pObsolete, pAlias);
                            pmd.param._primary = pPrimary;
                            pmd.param._multiple = pMultiple;
                            pmd.param._password = pPassword;
                            pmd.prompt = pPrompt;
                            pmd.promptAgain = pPromptAgain;
                            result.add(pmd);
                            pCls = null;
                            pOptional = false;
                            pDefaultValue = null;
                            pShortName = null;
                            pObsolete = false;
                            pAlias = null;
                            pPrimary = false;
                            pMultiple = false;
                            pPassword = false;
                            pPrompt = null;
                            pPromptAgain = null;
                            pName = value;
                            break;
                        }
                        case "class": {
                            if (value.isEmpty()) break;
                            try {
                                pCls = Class.forName(value);
                            }
                            catch (Exception exception) {}
                            break;
                        }
                        case "optional": {
                            pOptional = value.startsWith("t");
                            break;
                        }
                        case "default-value": {
                            pDefaultValue = value;
                            break;
                        }
                        case "short-name": {
                            pShortName = value;
                            break;
                        }
                        case "obsolete": {
                            pObsolete = value.startsWith("t");
                            break;
                        }
                        case "alias": {
                            pAlias = value;
                            break;
                        }
                        case "primary": {
                            pPrimary = value.startsWith("t");
                            break;
                        }
                        case "multiple": {
                            pMultiple = value.startsWith("t");
                            break;
                        }
                        case "password": {
                            pPassword = value.startsWith("t");
                            break;
                        }
                        case "prompt": {
                            pPrompt = this.resolveEndLines(value);
                            break;
                        }
                        case "prompt-again": {
                            pPromptAgain = this.resolveEndLines(value);
                            break;
                        }
                    }
                    continue;
                }
                switch (key) {
                    case "command-model": {
                        name = value;
                        break;
                    }
                    case "e-tag": {
                        eTag = value;
                        break;
                    }
                    case "unknown-are-operands": {
                        unknownAreOperands = value.startsWith("t");
                        break;
                    }
                    case "added-upload-options": {
                        addedUploadOption = value.startsWith("t");
                        break;
                    }
                    case "usage": {
                        usage = this.resolveEndLines(value);
                        break;
                    }
                    case "name": {
                        result = new CachedCommandModel(name, eTag);
                        result.dashOk = unknownAreOperands;
                        result.setUsage(usage);
                        result.setAddedUploadOption(addedUploadOption);
                        inParam = true;
                        pName = value;
                        break;
                    }
                }
            }
            if (inParam) {
                CommandModelData.ParamModelData pmd = new CommandModelData.ParamModelData(pName, pCls, pOptional, pDefaultValue, pShortName, pObsolete, pAlias);
                pmd.param._primary = pPrimary;
                pmd.param._multiple = pMultiple;
                pmd.param._password = pPassword;
                pmd.prompt = pPrompt;
                pmd.promptAgain = pPromptAgain;
                result.add(pmd);
            } else if (result == null && name != null && !name.isEmpty()) {
                result = new CachedCommandModel(name, eTag);
                result.dashOk = unknownAreOperands;
                result.setUsage(usage);
                result.setAddedUploadOption(addedUploadOption);
            }
        }
        return result;
    }
}

