/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool.datastructure;

import com.sun.appserv.connectors.internal.api.PoolingException;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.allocator.ResourceAllocator;
import com.sun.enterprise.resource.pool.ResourceHandler;
import com.sun.enterprise.resource.pool.datastructure.DataStructure;
import com.sun.logging.LogDomains;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RWLockDataStructure
implements DataStructure {
    private final ResourceHandler handler;
    private int maxSize;
    private final List<ResourceHandle> allResources;
    private final Deque<ResourceHandle> freeResources;
    private final ReentrantReadWriteLock reentrantLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.reentrantLock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.reentrantLock.writeLock();
    private final AtomicInteger remainingCapacity;
    protected static final Logger _logger = LogDomains.getLogger(RWLockDataStructure.class, (String)"javax.enterprise.resource.resourceadapter");

    public RWLockDataStructure(int maxSize, ResourceHandler handler) {
        this.allResources = new ArrayList<ResourceHandle>(Math.min(maxSize, 1000));
        this.freeResources = new ArrayDeque<ResourceHandle>(Math.min(maxSize, 1000));
        this.maxSize = maxSize;
        this.handler = handler;
        this.remainingCapacity = new AtomicInteger(maxSize);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "pool.datastructure.rwlockds.init");
        }
    }

    @Override
    public int addResource(ResourceAllocator allocator, int count) throws PoolingException {
        int numResAdded = 0;
        for (int i = 0; i < count && this.canGrow(); ++i) {
            try {
                ResourceHandle handle = this.handler.createResource(allocator);
                this.doLockSecured(() -> {
                    this.allResources.add(handle);
                    this.freeResources.offerLast(handle);
                }, (Lock)this.writeLock);
                ++numResAdded;
                continue;
            }
            catch (Exception e) {
                this.increaseRemainingCapacity();
                throw new PoolingException(e.getMessage(), e);
            }
        }
        return numResAdded;
    }

    private boolean canGrow() {
        int capacity = this.remainingCapacity.getAndUpdate(x -> x > 0 ? x - 1 : 0);
        return capacity > 0;
    }

    private void increaseRemainingCapacity() {
        this.remainingCapacity.incrementAndGet();
    }

    @Override
    public ResourceHandle getResource() {
        return this.doLockSecured(() -> {
            ResourceHandle resourceHandle = this.freeResources.pollFirst();
            if (resourceHandle != null) {
                resourceHandle.setBusy(true);
            }
            return resourceHandle;
        }, (Lock)this.writeLock);
    }

    @Override
    public void removeResource(ResourceHandle resource) {
        boolean removed = this.doLockSecured(() -> {
            boolean removedResource = this.allResources.remove(resource);
            if (removedResource) {
                this.freeResources.remove(resource);
                this.increaseRemainingCapacity();
            }
            return removedResource;
        }, (Lock)this.writeLock);
        if (removed) {
            this.handler.deleteResource(resource);
        }
    }

    @Override
    public void returnResource(ResourceHandle resource) {
        this.doLockSecured(() -> {
            resource.setBusy(false);
            this.freeResources.offerFirst(resource);
        }, (Lock)this.writeLock);
    }

    @Override
    public int getFreeListSize() {
        return this.doLockSecured(this.freeResources::size, (Lock)this.readLock);
    }

    @Override
    public void removeAll() {
        ArrayList removedResources = new ArrayList();
        this.doLockSecured(() -> {
            removedResources.addAll(this.allResources);
            this.allResources.clear();
            this.freeResources.clear();
            this.remainingCapacity.set(this.maxSize);
        }, (Lock)this.writeLock);
        for (ResourceHandle resourceHandle : removedResources) {
            this.handler.deleteResource(resourceHandle);
        }
    }

    @Override
    public int getResourcesSize() {
        return this.doLockSecured(this.allResources::size, (Lock)this.readLock);
    }

    @Override
    public void setMaxSize(int maxSize) {
        this.doLockSecured(() -> {
            int delta = maxSize - this.maxSize;
            this.remainingCapacity.getAndUpdate(x -> x + delta);
            this.maxSize = maxSize;
        }, (Lock)this.writeLock);
    }

    @Override
    public ArrayList<ResourceHandle> getAllResources() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void doLockSecured(Runnable lockSecuredProc, Lock lock) {
        lock.lock();
        try {
            lockSecuredProc.run();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T doLockSecured(Supplier<T> lockSecuredFunc, Lock lock) {
        lock.lock();
        try {
            T t = lockSecuredFunc.get();
            return t;
        }
        finally {
            lock.unlock();
        }
    }
}

