/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.rm;

import com.sun.appserv.connectors.internal.api.PoolingException;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.pool.PoolManager;
import com.sun.enterprise.resource.rm.ResourceManagerImpl;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.enterprise.transaction.spi.TransactionalResource;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ManagedConnection;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import org.glassfish.api.invocation.ComponentInvocation;

public class LazyEnlistableResourceManagerImpl
extends ResourceManagerImpl {
    @Override
    protected void enlist(JavaEETransactionManager tm, Transaction tran, ResourceHandle h) {
    }

    @Override
    public void registerResource(ResourceHandle handle) throws PoolingException {
        handle.setEnlistmentSuspended(true);
        super.registerResource(handle);
    }

    public void lazyEnlist(ManagedConnection mc) throws ResourceException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Entering lazyEnlist");
        }
        JavaEETransactionManager tm = ConnectorRuntime.getRuntime().getTransactionManager();
        Transaction tran = null;
        try {
            tran = tm.getTransaction();
            if (tran == null) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine(" Transaction null - not enlisting ");
                }
                return;
            }
        }
        catch (SystemException se) {
            ResourceException re = new ResourceException(se.getMessage());
            re.initCause((Throwable)se);
            throw re;
        }
        List invList = ConnectorRuntime.getRuntime().getInvocationManager().getAllInvocations();
        ResourceHandle h = null;
        block4: for (int j = invList.size(); j > 0; --j) {
            ComponentInvocation inv = (ComponentInvocation)invList.get(j - 1);
            Object comp = inv.getInstance();
            List l = tm.getResourceList(comp, inv);
            ListIterator it = l.listIterator();
            while (it.hasNext()) {
                ResourceHandle hand = (ResourceHandle)it.next();
                ManagedConnection toEnlist = (ManagedConnection)hand.getResource();
                if (!mc.equals(toEnlist)) continue;
                h = hand;
                continue block4;
            }
        }
        if (h != null && h.getResourceState().isUnenlisted()) {
            try {
                h.setEnlistmentSuspended(false);
                tm.enlistResource(tran, (TransactionalResource)h);
                h.setEnlistmentSuspended(true);
            }
            catch (Exception e) {
                PoolManager mgr = ConnectorRuntime.getRuntime().getPoolManager();
                mgr.putbackBadResourceToPool(h);
                _logger.log(Level.WARNING, "poolmgr.err_enlisting_res_in_getconn", h.getResourceSpec().getPoolInfo());
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("rm.enlistResource threw Exception. Evicting resource from pool");
                }
                throw new ResourceException((Throwable)e);
            }
        }
    }
}

