/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.opentracingshim;

import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.context.Context;
import io.opentelemetry.opentracingshim.ScopeShim;
import io.opentelemetry.opentracingshim.ShimUtil;
import io.opentelemetry.opentracingshim.SpanShim;
import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import io.opentracing.Span;
import javax.annotation.Nullable;

final class ScopeManagerShim
implements ScopeManager {
    private static final SpanShim NOOP_SPANSHIM = new SpanShim(io.opentelemetry.api.trace.Span.getInvalid());

    ScopeManagerShim() {
    }

    @Nullable
    public Span activeSpan() {
        SpanShim spanShim = SpanShim.current();
        io.opentelemetry.api.trace.Span span = io.opentelemetry.api.trace.Span.current();
        Baggage baggage = Baggage.current();
        if (!span.getSpanContext().isValid()) {
            if (baggage.isEmpty()) {
                return null;
            }
            return new SpanShim(io.opentelemetry.api.trace.Span.getInvalid(), baggage);
        }
        if (spanShim != null && spanShim.getSpan() == span) {
            return spanShim;
        }
        return new SpanShim(span, baggage);
    }

    public Scope activate(@Nullable Span span) {
        SpanShim spanShim = ShimUtil.getSpanShim(span);
        if (spanShim == null) {
            return new ScopeShim(Context.current().with(NOOP_SPANSHIM).makeCurrent());
        }
        return new ScopeShim(Context.current().with(spanShim).makeCurrent());
    }
}

