/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.microprofile.config.admin;

import com.sun.enterprise.config.serverbeans.Config;
import fish.payara.nucleus.microprofile.config.spi.MicroprofileConfigConfiguration;
import jakarta.inject.Inject;
import java.util.logging.Logger;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="set-config-ordinal")
@PerLookup
@ExecuteOn
@TargetType
@RestEndpoints(value={@RestEndpoint(configBean=MicroprofileConfigConfiguration.class, opType=RestEndpoint.OpType.POST, path="set-config-ordinal", description="Sets the Ordinal of a builtin Config Source")})
public class SetConfigOrdinal
implements AdminCommand {
    @Param
    int ordinal;
    @Param(optional=true, acceptableValues="domain,config,server,application,module,cluster,jndi,secrets,toml,password,jdbc,cloud,ldap", defaultValue="domain")
    String source;
    @Param(optional=true, defaultValue="server")
    String target;
    @Inject
    Target targetUtil;

    public void execute(AdminCommandContext context) {
        Config configVal = this.targetUtil.getConfig(this.target);
        MicroprofileConfigConfiguration serviceConfig = (MicroprofileConfigConfiguration)configVal.getExtensionByType(MicroprofileConfigConfiguration.class);
        if (serviceConfig != null) {
            try {
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<MicroprofileConfigConfiguration>(){

                    public Object run(MicroprofileConfigConfiguration config) {
                        switch (SetConfigOrdinal.this.source) {
                            case "domain": {
                                config.setDomainOrdinality(Integer.toString(SetConfigOrdinal.this.ordinal));
                                break;
                            }
                            case "config": {
                                config.setConfigOrdinality(Integer.toString(SetConfigOrdinal.this.ordinal));
                                break;
                            }
                            case "server": {
                                config.setServerOrdinality(Integer.toString(SetConfigOrdinal.this.ordinal));
                                break;
                            }
                            case "application": {
                                config.setApplicationOrdinality(Integer.toString(SetConfigOrdinal.this.ordinal));
                                break;
                            }
                            case "module": {
                                config.setModuleOrdinality(Integer.toString(SetConfigOrdinal.this.ordinal));
                                break;
                            }
                            case "cluster": {
                                config.setClusterOrdinality(Integer.toString(SetConfigOrdinal.this.ordinal));
                                break;
                            }
                            case "jndi": {
                                config.setJndiOrdinality(Integer.toString(SetConfigOrdinal.this.ordinal));
                                break;
                            }
                            case "secrets": {
                                config.setSecretDirOrdinality(Integer.toString(SetConfigOrdinal.this.ordinal));
                                break;
                            }
                            case "toml": {
                                config.setTomlOrdinality(Integer.toString(SetConfigOrdinal.this.ordinal));
                                break;
                            }
                            case "password": {
                                config.setPasswordOrdinality(Integer.toString(SetConfigOrdinal.this.ordinal));
                                break;
                            }
                            case "jdbc": {
                                config.setJdbcOrdinality(Integer.toString(SetConfigOrdinal.this.ordinal));
                                break;
                            }
                            case "cloud": {
                                config.setCloudOrdinality(Integer.toString(SetConfigOrdinal.this.ordinal));
                                break;
                            }
                            case "ldap": {
                                config.setLdapOrdinality(Integer.toString(SetConfigOrdinal.this.ordinal));
                            }
                        }
                        return null;
                    }
                }, (ConfigBeanProxy)serviceConfig);
            }
            catch (TransactionFailure ex) {
                context.getActionReport().failure(Logger.getLogger(SetConfigOrdinal.class.getName()), "Failed to update message", (Throwable)ex);
            }
        } else {
            context.getActionReport().failure(Logger.getLogger(SetConfigOrdinal.class.getName()), "No configuration with name " + this.target);
        }
    }
}

