/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.RestUtil;

public class LoggingHandlers {
    public static void getLoggerLevels(HandlerContext handlerCtx) {
        Map loggerLevels = (Map)handlerCtx.getInputValue("loggerLevels");
        ArrayList result = new ArrayList();
        if (loggerLevels != null) {
            ArrayList keys = new ArrayList(loggerLevels.keySet());
            Collections.sort(keys);
            for (String key : keys) {
                HashMap<String, Object> oneRow = new HashMap<String, Object>();
                oneRow.put("loggerName", key);
                oneRow.put("level", loggerLevels.get(key));
                oneRow.put("selected", false);
                result.add(oneRow);
            }
        }
        handlerCtx.setOutputValue("loggerList", result);
    }

    public static void changeLoggerLevels(HandlerContext handlerCtx) {
        List obj;
        String newLogLevel = (String)handlerCtx.getInputValue("newLogLevel");
        List allRows = obj = (List)handlerCtx.getInputValue("allRows");
        if (GuiUtil.isEmpty(newLogLevel)) {
            handlerCtx.setOutputValue("newList", (Object)allRows);
            return;
        }
        for (Map oneRow : allRows) {
            boolean selected = (Boolean)oneRow.get("selected");
            if (!selected) continue;
            oneRow.put("level", newLogLevel);
            oneRow.put("selected", false);
        }
        handlerCtx.setOutputValue("newList", (Object)allRows);
    }

    public static void updateLoggerLevels(HandlerContext handlerCtx) {
        block4: {
            List allRows = (List)handlerCtx.getInputValue("allRows");
            String config = (String)handlerCtx.getInputValue("config");
            HashMap<String, Object> props = new HashMap<String, Object>();
            try {
                StringBuilder sb = new StringBuilder();
                String sep = "";
                for (Map oneRow : allRows) {
                    String loggerName = (String)oneRow.get("loggerName");
                    if (GuiUtil.isEmpty(loggerName)) continue;
                    if (loggerName.contains(":")) {
                        loggerName = loggerName.replace(":", "\\:");
                    }
                    sb.append(sep).append(loggerName).append("=").append(oneRow.get("level"));
                    sep = ":";
                }
                props.put("id", sb.toString());
                props.put("target", config);
                RestUtil.restRequest((String)GuiUtil.getSessionValue("REST_URL") + "/set-log-levels.json", props, "POST", null, false, true);
                LoggingHandlers.deleteLoggers(allRows, config);
            }
            catch (Exception ex) {
                GuiUtil.handleException(handlerCtx, ex);
                if (!GuiUtil.getLogger().isLoggable(Level.FINE)) break block4;
                ex.printStackTrace();
            }
        }
    }

    public static void deleteLoggers(List<Map<String, Object>> allRows, String configName) {
        ArrayList<String> newLoggers = new ArrayList<String>();
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("target", configName);
        Map<String, Object> result = RestUtil.restRequest((String)GuiUtil.getSessionValue("REST_URL") + "/list-log-levels.json", attrs, "GET", null, false);
        List oldLoggers = (List)((HashMap)((HashMap)result.get("data")).get("extraProperties")).get("loggers");
        for (Map<String, Object> oneRow : allRows) {
            newLoggers.add((String)oneRow.get("loggerName"));
        }
        StringBuilder sb = new StringBuilder();
        String sep = "";
        for (String logger : oldLoggers) {
            if (newLoggers.contains(logger)) continue;
            if (logger.contains(":")) {
                logger = logger.replace(":", "\\:");
            }
            sb.append(sep).append(logger);
            sep = ":";
        }
        if (sb.length() > 0) {
            attrs = new HashMap();
            attrs.put("id", sb.toString());
            attrs.put("target", configName);
            RestUtil.restRequest((String)GuiUtil.getSessionValue("REST_URL") + "/delete-log-levels", attrs, "POST", null, false);
        }
    }

    public static void saveLoggingAttributes(HandlerContext handlerCtx) {
        block5: {
            Map attrs = (Map)handlerCtx.getInputValue("attrs");
            String config = (String)handlerCtx.getInputValue("config");
            HashMap<String, Object> props = new HashMap<String, Object>();
            try {
                StringBuilder data = new StringBuilder();
                for (Map.Entry e : attrs.entrySet()) {
                    String key = (String)e.getKey();
                    if ((key.equals("com.sun.enterprise.server.logging.SyslogHandler.useSystemLogging") || key.equals("com.sun.enterprise.server.logging.GFFileHandler.logtoFile") || key.equals("com.sun.enterprise.server.logging.GFFileHandler.logtoConsole") || key.equals("com.sun.enterprise.server.logging.GFFileHandler.multiLineMode") || key.equals("com.sun.enterprise.server.logging.GFFileHandler.rotationOnDateChange") || key.equals("com.sun.enterprise.server.logging.GFFileHandler.compressOnRotation") || key.equals("com.sun.enterprise.server.logging.GFFileHandler.logStandardStreams") || key.equals("com.sun.enterprise.server.logging.GFFileHandler.fastLogging") || key.equals("fish.payara.enterprise.server.logging.PayaraNotificationFileHandler.logtoFile") || key.equals("fish.payara.enterprise.server.logging.PayaraNotificationFileHandler.rotationOnDateChange") || key.equals("fish.payara.enterprise.server.logging.PayaraNotificationFileHandler.compressOnRotation")) && e.getValue() == null) {
                        attrs.put(key, "false");
                    }
                    if (data.length() > 0) {
                        data.append(":");
                    }
                    data.append(key).append("='").append(attrs.get(key)).append("'");
                }
                props.put("id", data.toString());
                props.put("target", config);
                RestUtil.restRequest((String)GuiUtil.getSessionValue("REST_URL") + "/set-log-attributes", props, "POST", null, false, true);
            }
            catch (Exception ex) {
                GuiUtil.handleException(handlerCtx, ex);
                if (!GuiUtil.getLogger().isLoggable(Level.FINE)) break block5;
                ex.printStackTrace();
            }
        }
    }
}

