/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.util;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.JsonUtil;
import org.glassfish.admingui.common.util.RestResponse;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class JerseyRestResponse
extends RestResponse {
    private static final Logger LOG = Logger.getLogger(JerseyRestResponse.class.getName());
    protected Response response;
    private String body = null;

    public JerseyRestResponse(Response response) {
        this.response = response;
    }

    @Override
    public String getResponseBody() {
        if (this.body == null) {
            this.body = (String)this.response.readEntity(String.class);
        }
        return this.body;
    }

    @Override
    public int getResponseCode() {
        return this.response.getStatus();
    }

    @Override
    public Map<String, Object> getResponse() {
        LOG.finest("getResponse()");
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        result.put("responseCode", this.getResponseCode());
        result.put("responseBody", this.getResponseBody());
        String contentType = this.response.getHeaderString("Content-type");
        if (contentType != null) {
            String responseBody = this.getResponseBody();
            if ((contentType = contentType.toLowerCase(GuiUtil.guiLocale)).startsWith("application/xml")) {
                InputStream input = null;
                try {
                    XMLInputFactory inputFactory = XMLInputFactory.newInstance();
                    inputFactory.setProperty("javax.xml.stream.isValidating", false);
                    input = new ByteArrayInputStream(responseBody.trim().getBytes("UTF-8"));
                    XMLStreamReader parser = inputFactory.createXMLStreamReader(input);
                    while (parser.hasNext()) {
                        int event = parser.next();
                        switch (event) {
                            case 1: {
                                if (!"map".equals(parser.getLocalName())) break;
                                result.put("data", JerseyRestResponse.processXmlMap(parser));
                                break;
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(RestResponse.class.getName()).log(Level.SEVERE, null, ex);
                    throw new RuntimeException(ex);
                }
                finally {
                    try {
                        if (input != null) {
                            input.close();
                        }
                    }
                    catch (IOException ex) {
                        Logger.getLogger(RestResponse.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
            if (contentType.startsWith("application/json")) {
                JsonReader reader = Json.createReader(new StringReader(responseBody));
                JsonObject object = reader.readObject();
                result.put("data", JsonUtil.jsonObjectToMap(object));
            } else {
                LOG.severe("Unsupported Response Format: '" + contentType + "'!");
            }
        }
        return result;
    }

    private Map<String, Object> getJavaFromXML(Element element) {
        HashMap<String, Object> result = new HashMap<String, Object>(10);
        NamedNodeMap attributes = element.getAttributes();
        int attLen = attributes.getLength();
        for (int attIdx = 0; attIdx < attLen; ++attIdx) {
            Node attribute = attributes.item(attIdx);
            result.put(attribute.getNodeName(), attribute.getNodeValue());
        }
        NodeList nl = element.getChildNodes();
        int len = nl.getLength();
        for (int idx = 0; idx < len; ++idx) {
            ArrayList<Map<String, Object>> childList;
            Node child = nl.item(idx);
            if (child.getNodeType() != 1) continue;
            String childName = child.getNodeName();
            if (result.containsKey(childName)) {
                childList = (ArrayList<Map<String, Object>>)result.get(childName);
            } else {
                childList = new ArrayList<Map<String, Object>>(5);
                result.put(childName, childList);
            }
            childList.add(this.getJavaFromXML((Element)child));
        }
        return result;
    }

    private Map<String, Object> processMessagePart(Node messageNode) {
        HashMap<String, Object> message = new HashMap<String, Object>(5);
        NamedNodeMap attributes = messageNode.getAttributes();
        int attLen = attributes.getLength();
        for (int attIdx = 0; attIdx < attLen; ++attIdx) {
            Node attribute = attributes.item(attIdx);
            message.put(attribute.getNodeName(), attribute.getNodeValue());
        }
        NodeList nl = messageNode.getChildNodes();
        int len = nl.getLength();
        boolean hasChildMessages = false;
        boolean hasProperty = false;
        ArrayList<Map<String, Object>> properties = null;
        ArrayList<Map<String, Object>> messages = null;
        for (int idx = 0; idx < len; ++idx) {
            Node child = nl.item(idx);
            if (child.getNodeType() != 1) continue;
            if (child.getNodeName().equals("message-part")) {
                if (!hasChildMessages) {
                    messages = new ArrayList<Map<String, Object>>(2);
                    message.put("messages", messages);
                    hasChildMessages = true;
                }
                messages.add(this.processMessagePart(child));
                continue;
            }
            if (!child.getNodeName().equals("property")) continue;
            if (!hasProperty) {
                properties = new ArrayList<Map<String, Object>>(10);
                message.put("properties", properties);
                hasProperty = true;
            }
            properties.add(this.processProperty(child));
        }
        return message;
    }

    private Map<String, Object> processProperty(Node propertyNode) {
        HashMap<String, Object> property = new HashMap<String, Object>(5);
        NamedNodeMap attributes = propertyNode.getAttributes();
        int attLen = attributes.getLength();
        for (int attIdx = 0; attIdx < attLen; ++attIdx) {
            Node attribute = attributes.item(attIdx);
            property.put(attribute.getNodeName(), attribute.getNodeValue());
        }
        NodeList nl = propertyNode.getChildNodes();
        int len = nl.getLength();
        boolean hasProperty = false;
        ArrayList<Map<String, Object>> properties = null;
        for (int idx = 0; idx < len; ++idx) {
            Node child = nl.item(idx);
            if (child.getNodeType() != 1 || !child.getNodeName().equals("property")) continue;
            if (!hasProperty) {
                properties = new ArrayList<Map<String, Object>>(10);
                property.put("properties", properties);
                hasProperty = true;
            }
            properties.add(this.processProperty(child));
        }
        return property;
    }

    private static Map<String, Object> processXmlMap(XMLStreamReader parser) throws XMLStreamException {
        boolean endOfMap = false;
        HashMap<String, Object> entry = new HashMap<String, Object>();
        String key = null;
        String element = null;
        block4: while (!endOfMap) {
            int event = parser.next();
            switch (event) {
                case 1: {
                    Object value;
                    if ("entry".equals(parser.getLocalName())) {
                        key = parser.getAttributeValue(null, "key");
                        value = parser.getAttributeValue(null, "value");
                        if (value == null) continue block4;
                        entry.put(key, value);
                        key = null;
                        break;
                    }
                    if ("map".equals(parser.getLocalName())) {
                        value = JerseyRestResponse.processXmlMap(parser);
                        entry.put(key, value);
                        break;
                    }
                    if ("list".equals(parser.getLocalName())) {
                        value = JerseyRestResponse.processXmlList(parser);
                        entry.put(key, value);
                        break;
                    }
                    element = parser.getLocalName();
                    break;
                }
                case 2: {
                    if ("map".equals(parser.getLocalName())) {
                        endOfMap = true;
                    }
                    element = null;
                    break;
                }
                default: {
                    String text = parser.getText();
                    if (element == null) continue block4;
                    if ("number".equals(element)) {
                        if (text.contains(".")) {
                            entry.put(key, Double.parseDouble(text));
                        } else {
                            entry.put(key, Long.parseLong(text));
                        }
                    } else if ("string".equals(element)) {
                        entry.put(key, text);
                    }
                    element = null;
                }
            }
        }
        return entry;
    }

    private static List<Object> processXmlList(XMLStreamReader parser) throws XMLStreamException {
        ArrayList<Object> list = new ArrayList<Object>();
        boolean endOfList = false;
        String element = null;
        block4: while (!endOfList) {
            int event = parser.next();
            switch (event) {
                case 1: {
                    if ("map".equals(parser.getLocalName())) {
                        list.add(JerseyRestResponse.processXmlMap(parser));
                        continue block4;
                    }
                    element = parser.getLocalName();
                    continue block4;
                }
                case 2: {
                    if ("list".equals(parser.getLocalName())) {
                        endOfList = true;
                    }
                    element = null;
                    continue block4;
                }
            }
            String text = parser.getText();
            if (element == null) continue;
            if ("number".equals(element)) {
                if (text.contains(".")) {
                    list.add(Double.parseDouble(text));
                } else {
                    list.add(Long.parseLong(text));
                }
            } else if ("string".equals(element)) {
                list.add(text);
            }
            element = null;
        }
        return list;
    }

    @Override
    public void close() {
        this.response.close();
    }
}

