/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.util;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonException;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JsonUtil {
    private JsonUtil() {
    }

    public static JsonValue getJsonValue(Object object) throws JsonException {
        JsonValue result;
        if (object == null) {
            result = JsonValue.NULL;
        } else if (object instanceof Collection) {
            result = JsonUtil.processCollection((Collection)object);
        } else if (object instanceof Map) {
            result = JsonUtil.processMap((Map)object);
        } else if (object instanceof String) {
            result = Json.createValue((String)object);
        } else if (object instanceof Boolean) {
            Boolean value = (Boolean)object;
            result = value.booleanValue() ? JsonValue.TRUE : JsonValue.FALSE;
        } else if (object instanceof Double) {
            result = Json.createValue((Double)object);
        } else if (object instanceof Integer) {
            result = Json.createValue((Integer)object);
        } else if (object instanceof Long) {
            result = Json.createValue((Long)object);
        } else if (object instanceof JsonValue) {
            result = (JsonValue)object;
        } else if (object instanceof BigInteger) {
            result = Json.createValue((BigInteger)object);
        } else if (object instanceof BigDecimal) {
            result = Json.createValue((BigDecimal)object);
        } else if (object.getClass().isEnum()) {
            result = Json.createValue(object.toString());
        } else if (object instanceof InetAddress) {
            result = Json.createValue(object.toString());
        } else {
            Class<?> clazz = object.getClass();
            if (clazz.isArray()) {
                JsonArrayBuilder array = Json.createArrayBuilder();
                int length = Array.getLength(object);
                for (int i = 0; i < length; ++i) {
                    array.add(JsonUtil.getJsonValue(Array.get(object, i)));
                }
                result = array.build();
            } else {
                throw new JsonException("Unable to convert object to JsonValue: " + object);
            }
        }
        return result;
    }

    private static JsonArray processCollection(Collection c) throws JsonException {
        JsonArrayBuilder result = Json.createArrayBuilder();
        for (Object item : c) {
            result.add(JsonUtil.getJsonValue(item));
        }
        return result.build();
    }

    private static JsonObject processMap(Map map) throws JsonException {
        JsonObjectBuilder result = Json.createObjectBuilder();
        for (Map.Entry entry : map.entrySet()) {
            result.add(entry.getKey().toString(), JsonUtil.getJsonValue(entry.getValue()));
        }
        return result.build();
    }

    public static void appendUnicodeEscaped(char ch, StringBuilder builder) {
        if (ch > '~' || ch < ' ') {
            builder.append("\\u");
            String chStr = Integer.toHexString(ch);
            int len = chStr.length();
            for (int idx = 4; idx > len; --idx) {
                builder.append('0');
            }
            builder.append(chStr);
        } else {
            builder.append(ch);
        }
    }

    public static Map<String, Object> jsonObjectToMap(JsonObject object) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Set keys = object.keySet();
        for (String key : keys) {
            result.put(key, JsonUtil.jsonValueToRaw((JsonValue)object.get(key)));
        }
        return result;
    }

    private static Object jsonValueToRaw(JsonValue value) {
        JsonValue.ValueType type = value.getValueType();
        switch (type) {
            case STRING: {
                return ((JsonString)value).getString();
            }
            case NUMBER: {
                return ((JsonNumber)value).bigDecimalValue();
            }
            case TRUE: {
                return Boolean.TRUE;
            }
            case FALSE: {
                return Boolean.FALSE;
            }
            case NULL: {
                return null;
            }
            case OBJECT: {
                return JsonUtil.jsonObjectToMap((JsonObject)value);
            }
            case ARRAY: {
                return JsonUtil.jsonArraytoArray((JsonArray)value);
            }
        }
        throw new JsonException("JsonValue is not a recognised ValueType");
    }

    private static List<Object> jsonArraytoArray(JsonArray array) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (JsonValue instance : array) {
            result.add(JsonUtil.jsonValueToRaw(instance));
        }
        return result;
    }
}

