/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.api.impl;

import com.ibm.jbatch.container.api.impl.JobOperatorImplDelegate;
import jakarta.batch.operations.BatchRuntimeException;
import jakarta.batch.operations.JobExecutionAlreadyCompleteException;
import jakarta.batch.operations.JobExecutionIsRunningException;
import jakarta.batch.operations.JobExecutionNotMostRecentException;
import jakarta.batch.operations.JobExecutionNotRunningException;
import jakarta.batch.operations.JobOperator;
import jakarta.batch.operations.JobRestartException;
import jakarta.batch.operations.JobSecurityException;
import jakarta.batch.operations.JobStartException;
import jakarta.batch.operations.NoSuchJobException;
import jakarta.batch.operations.NoSuchJobExecutionException;
import jakarta.batch.operations.NoSuchJobInstanceException;
import jakarta.batch.runtime.JobExecution;
import jakarta.batch.runtime.JobInstance;
import jakarta.batch.runtime.StepExecution;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class JobOperatorImpl
implements JobOperator {
    private static final String sourceClass = JobOperatorImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private TransactionManager tranMgr;
    private JobOperator jobOperator = new JobOperatorImplDelegate();

    public JobOperatorImpl() {
        this.tranMgr = this.jndiLookup();
    }

    private TransactionManager jndiLookup() {
        logger.entering(sourceClass, "jndiLookup");
        String jndi = "java:appserver/TransactionManager";
        TransactionManager retVal = null;
        try {
            InitialContext ctxt = new InitialContext();
            retVal = (TransactionManager)ctxt.lookup(jndi);
            logger.fine("JNDI transaction manager found");
        }
        catch (NamingException ne) {
            logger.info("JNDI transaction manager not found at: " + jndi);
        }
        logger.exiting(sourceClass, "jndiLookup");
        return retVal;
    }

    private Transaction suspendTran() {
        if (this.tranMgr == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("JobOperator suspend, return null since tranManager is null");
            }
            return null;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("JobOperator suspending transaction");
        }
        try {
            Transaction suspended = this.tranMgr.suspend();
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("JobOperator suspending transaction: " + suspended);
            }
            return suspended;
        }
        catch (SystemException se) {
            logger.severe("Failed to suspend current transaction before JobOperator method");
            throw new BatchRuntimeException("Failed to suspend current transaction before JobOperator method", se);
        }
    }

    private void resumeTran(Transaction tran) {
        if (tran != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("JobOperator resuming transaction = " + tran);
            }
            try {
                this.tranMgr.resume(tran);
            }
            catch (Exception e) {
                logger.severe("Failed to resume transaction before JobOperator method, tran = " + tran);
                throw new BatchRuntimeException("Failed to resume transaction after JobOperator method", e);
            }
        } else if (logger.isLoggable(Level.FINER)) {
            logger.finer("No-op on JobOperator resume, transaction = <null>");
        }
    }

    @Override
    public Set<String> getJobNames() throws JobSecurityException {
        Transaction tran = this.suspendTran();
        try {
            Set<String> set = this.jobOperator.getJobNames();
            return set;
        }
        finally {
            this.resumeTran(tran);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getJobInstanceCount(String jobName) throws NoSuchJobException, JobSecurityException {
        Transaction tran = this.suspendTran();
        try {
            int n = this.jobOperator.getJobInstanceCount(jobName);
            return n;
        }
        finally {
            this.resumeTran(tran);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<JobInstance> getJobInstances(String jobName, int start, int count) throws NoSuchJobException, JobSecurityException {
        Transaction tran = this.suspendTran();
        try {
            List<JobInstance> list = this.jobOperator.getJobInstances(jobName, start, count);
            return list;
        }
        finally {
            this.resumeTran(tran);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Long> getRunningExecutions(String jobName) throws NoSuchJobException, JobSecurityException {
        Transaction tran = this.suspendTran();
        try {
            List<Long> list = this.jobOperator.getRunningExecutions(jobName);
            return list;
        }
        finally {
            this.resumeTran(tran);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getParameters(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        Transaction tran = this.suspendTran();
        try {
            Properties properties = this.jobOperator.getParameters(executionId);
            return properties;
        }
        finally {
            this.resumeTran(tran);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long start(String jobXMLName, Properties jobParameters) throws JobStartException, JobSecurityException {
        Transaction tran = this.suspendTran();
        try {
            long l = this.jobOperator.start(jobXMLName, jobParameters);
            return l;
        }
        finally {
            this.resumeTran(tran);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long restart(long executionId, Properties restartParameters) throws JobExecutionAlreadyCompleteException, NoSuchJobExecutionException, JobExecutionNotMostRecentException, JobRestartException, JobSecurityException {
        Transaction tran = this.suspendTran();
        try {
            long l = this.jobOperator.restart(executionId, restartParameters);
            return l;
        }
        finally {
            this.resumeTran(tran);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(long executionId) throws NoSuchJobExecutionException, JobExecutionNotRunningException, JobSecurityException {
        Transaction tran = this.suspendTran();
        try {
            this.jobOperator.stop(executionId);
        }
        finally {
            this.resumeTran(tran);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abandon(long executionId) throws NoSuchJobExecutionException, JobExecutionIsRunningException, JobSecurityException {
        Transaction tran = this.suspendTran();
        try {
            this.jobOperator.abandon(executionId);
        }
        finally {
            this.resumeTran(tran);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobInstance getJobInstance(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        Transaction tran = this.suspendTran();
        try {
            JobInstance jobInstance = this.jobOperator.getJobInstance(executionId);
            return jobInstance;
        }
        finally {
            this.resumeTran(tran);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<JobExecution> getJobExecutions(JobInstance instance) throws NoSuchJobInstanceException, JobSecurityException {
        Transaction tran = this.suspendTran();
        try {
            List<JobExecution> list = this.jobOperator.getJobExecutions(instance);
            return list;
        }
        finally {
            this.resumeTran(tran);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobExecution getJobExecution(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        Transaction tran = this.suspendTran();
        try {
            JobExecution jobExecution = this.jobOperator.getJobExecution(executionId);
            return jobExecution;
        }
        finally {
            this.resumeTran(tran);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<StepExecution> getStepExecutions(long jobExecutionId) throws NoSuchJobExecutionException, JobSecurityException {
        Transaction tran = this.suspendTran();
        try {
            List<StepExecution> list = this.jobOperator.getStepExecutions(jobExecutionId);
            return list;
        }
        finally {
            this.resumeTran(tran);
        }
    }
}

