/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.hazelcast;

import com.hazelcast.internal.serialization.impl.defaultserializers.JavaDefaultSerializers;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.StreamSerializer;
import com.sun.enterprise.util.ExceptionUtil;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.internal.api.JavaEEContextUtil;

public class PayaraHazelcastSerializer
implements StreamSerializer<Object> {
    private static final Logger log = Logger.getLogger(PayaraHazelcastSerializer.class.getName());
    private final JavaEEContextUtil ctxUtil;
    private final StreamSerializer<Object> delegate;

    public PayaraHazelcastSerializer(JavaEEContextUtil ctxUtil, StreamSerializer<?> delegate) {
        this.ctxUtil = ctxUtil;
        this.delegate = delegate != null ? delegate : new JavaDefaultSerializers.JavaSerializer(true, false, null);
    }

    public void write(ObjectDataOutput out, Object object) throws IOException {
        this.delegate.write(out, (Object)this.ctxUtil.getInvocationComponentId());
        this.delegate.write(out, object);
    }

    public Object read(ObjectDataInput in) throws IOException {
        Object object;
        block9: {
            String componentId = (String)this.delegate.read(in);
            JavaEEContextUtil.Instance context = componentId != null ? this.ctxUtil.fromComponentId(componentId) : this.ctxUtil.empty();
            JavaEEContextUtil.Context ctx = context.setApplicationClassLoader();
            try {
                object = this.delegate.read(in);
                if (ctx == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (ctx != null) {
                        try {
                            ctx.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable ex) {
                    if (ExceptionUtil.getRootCause((Throwable)ex) instanceof ClassNotFoundException && !context.isLoaded()) {
                        log.log(Level.FINE, "Unable to Deserialize - No tenant", ex);
                        return null;
                    }
                    throw ex;
                }
            }
            ctx.close();
        }
        return object;
    }

    public int getTypeId() {
        return 1;
    }

    public void destroy() {
        this.delegate.destroy();
    }
}

