/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.cli;

import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.launcher.GFLauncher;
import com.sun.enterprise.admin.launcher.GFLauncherException;
import com.sun.enterprise.admin.launcher.GFLauncherFactory;
import com.sun.enterprise.admin.launcher.GFLauncherInfo;
import com.sun.enterprise.admin.servermgmt.cli.LocalDomainCommand;
import com.sun.enterprise.admin.servermgmt.cli.StartServerCommand;
import com.sun.enterprise.admin.servermgmt.cli.StartServerHelper;
import com.sun.enterprise.admin.servermgmt.cli.Strings;
import com.sun.enterprise.admin.util.CommandModelData;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.process.ProcessStreamDrainer;
import com.sun.enterprise.universal.xml.MiniXmlParserException;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.security.common.FileRealmStorageManager;
import org.jvnet.hk2.annotations.Service;

@Service(name="start-domain")
@PerLookup
public class StartDomainCommand
extends LocalDomainCommand
implements StartServerCommand {
    private GFLauncherInfo info;
    private GFLauncher launcher;
    @Param(optional=true, shortName="v", defaultValue="false")
    private boolean verbose;
    @Param(optional=true, defaultValue="false")
    private boolean upgrade;
    @Param(optional=true, shortName="w", defaultValue="false")
    private boolean watchdog;
    @Param(optional=true, shortName="d", defaultValue="false")
    private boolean debug;
    @Param(name="domain_name", primary=true, optional=true)
    private String domainName0;
    @Param(name="dry-run", shortName="n", optional=true, defaultValue="false")
    private boolean dry_run;
    @Param(name="drop-interrupted-commands", optional=true, defaultValue="false")
    private boolean drop_interrupted_commands;
    @Param(name="prebootcommandfile", optional=true)
    private String preBootCommand;
    @Param(name="postbootcommandfile", optional=true)
    private String postBootCommand;
    @Param(defaultValue="600", optional=true)
    protected int timeout;
    @Param(optional=true, defaultValue="false")
    private boolean warmup;
    @Inject
    ServerEnvironment senv;
    private static final LocalStringsImpl STRINGS = new LocalStringsImpl(StartDomainCommand.class);
    private StartServerHelper helper;
    private String newpwName = Environment.getPrefix() + "NEWPASSWORD";

    @Override
    public List<String> getLauncherArgs() {
        return this.launcher.getCommandLine();
    }

    @Override
    public RuntimeType getType() {
        return RuntimeType.DAS;
    }

    @Override
    protected void validate() throws CommandException, CommandValidationException {
        File postbootFile;
        File prebootfile;
        this.setDomainName(this.domainName0);
        if (this.preBootCommand != null && !(prebootfile = new File(this.preBootCommand)).exists()) {
            throw new CommandValidationException("preboot commands file does not exist: " + prebootfile.getAbsolutePath());
        }
        if (this.postBootCommand != null && !(postbootFile = new File(this.postBootCommand)).exists()) {
            throw new CommandValidationException("postboot commands file does not exist: " + postbootFile.getAbsolutePath());
        }
        if (this.timeout < 1) {
            throw new CommandValidationException("Timeout must be at least 1 second long.");
        }
        super.validate();
    }

    protected int executeCommand() throws CommandException {
        try {
            this.createLauncher();
            String mpv = this.getMasterPassword();
            this.helper = new StartServerHelper(logger, this.programOpts.isTerse(), this.getServerDirs(), this.launcher, mpv);
            if (!this.helper.prepareForLaunch()) {
                return 1;
            }
            if (!this.upgrade && this.launcher.needsManualUpgrade()) {
                logger.info(STRINGS.get("manualUpgradeNeeded"));
                return 1;
            }
            this.doAutoUpgrade(mpv);
            if (this.dry_run) {
                logger.fine(Strings.get("dry_run_msg"));
                List cmd = this.launcher.getCommandLine();
                StringBuilder sb = new StringBuilder();
                for (String s : cmd) {
                    sb.append(s);
                    sb.append('\n');
                }
                logger.info(sb.toString());
                return 0;
            }
            this.doAdminPasswordCheck();
            if (this.warmup) {
                this.info.setWarmup(this.warmup);
                this.helper.setWarmup(this.warmup);
            }
            this.launcher.launch();
            if (this.verbose || this.upgrade || this.watchdog) {
                while (true) {
                    int returnValue = this.launcher.getExitValue();
                    switch (returnValue) {
                        case 10: {
                            logger.info(STRINGS.get("restart"));
                            break;
                        }
                        case 11: {
                            logger.info(STRINGS.get("restartChangeDebug", new Object[]{"on"}));
                            this.info.setDebug(true);
                            break;
                        }
                        case 12: {
                            logger.info(STRINGS.get("restartChangeDebug", new Object[]{"off"}));
                            this.info.setDebug(false);
                            break;
                        }
                        default: {
                            return returnValue;
                        }
                    }
                    if (this.env.debug()) {
                        System.setProperty("WALL_CLOCK_START", "" + System.currentTimeMillis());
                    }
                    this.launcher.relaunch();
                }
            }
            this.helper.waitForServer(this.timeout, TimeUnit.SECONDS);
            this.helper.report();
            return 0;
        }
        catch (GFLauncherException gfle) {
            throw new CommandException(gfle.getMessage());
        }
        catch (MiniXmlParserException me) {
            throw new CommandException((Throwable)me);
        }
    }

    @Override
    public void createLauncher() throws GFLauncherException, MiniXmlParserException {
        this.launcher = GFLauncherFactory.getInstance((RuntimeType)this.getType());
        this.info = this.launcher.getInfo();
        this.info.setDomainName(this.getDomainName());
        this.info.setDomainParentDir(this.getDomainsDir().getPath());
        this.info.setVerbose(this.verbose || this.upgrade);
        this.info.setDebug(this.debug);
        this.info.setUpgrade(this.upgrade);
        this.info.setWatchdog(this.watchdog);
        this.info.setWarmup(this.warmup);
        this.info.setDropInterruptedCommands(this.drop_interrupted_commands);
        this.info.setPrebootCommandsFile(this.preBootCommand);
        this.info.setpostbootCommandsFile(this.postBootCommand);
        this.info.setRespawnInfo(this.programOpts.getClassName(), this.programOpts.getClassPath(), this.respawnArgs());
        this.launcher.setup();
    }

    private String[] respawnArgs() {
        ArrayList<Object> args = new ArrayList<Object>(15);
        args.addAll(Arrays.asList(this.programOpts.getProgramArguments()));
        args.add(this.getName());
        args.add("--verbose=" + this.verbose);
        args.add("--watchdog=" + this.watchdog);
        args.add("--debug=" + this.debug);
        args.add("--warmup=" + this.warmup);
        args.add("--domaindir");
        args.add(this.getDomainsDir().toString());
        if (StartDomainCommand.ok((String)this.getDomainName())) {
            args.add(this.getDomainName());
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Respawn args: {0}", args);
        }
        String[] a = new String[args.size()];
        args.toArray(a);
        return a;
    }

    private void doAutoUpgrade(String mpv) throws GFLauncherException, MiniXmlParserException, CommandException {
        if (this.upgrade || !this.launcher.needsAutoUpgrade()) {
            return;
        }
        logger.info(STRINGS.get("upgradeNeeded"));
        this.info.setUpgrade(true);
        this.launcher.setup();
        this.launcher.launch();
        Process p = this.launcher.getProcess();
        int exitCode = -1;
        try {
            exitCode = p.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (exitCode != 0) {
            ProcessStreamDrainer psd = this.launcher.getProcessStreamDrainer();
            String output = psd.getOutErrString();
            if (StartDomainCommand.ok((String)output)) {
                throw new CommandException(STRINGS.get("upgradeFailedOutput", new Object[]{this.info.getDomainName(), exitCode, output}));
            }
            throw new CommandException(STRINGS.get("upgradeFailed", new Object[]{this.info.getDomainName(), exitCode}));
        }
        logger.info(STRINGS.get("upgradeSuccessful"));
        this.createLauncher();
    }

    private void doAdminPasswordCheck() throws CommandException {
        String adminKeyFile = this.launcher.getAdminRealmKeyFile();
        if (adminKeyFile != null) {
            try {
                FileRealmStorageManager fileStorageManager = new FileRealmStorageManager(adminKeyFile);
                if (!fileStorageManager.hasAuthenticatableUser()) {
                    String passwordCopy;
                    Set names = fileStorageManager.getUserNames();
                    if (names == null || names.isEmpty()) {
                        throw new CommandException("no admin users");
                    }
                    String adminUsername = (String)names.iterator().next();
                    CommandModelData.ParamModelData paramModelData = new CommandModelData.ParamModelData(this.newpwName, String.class, false, null);
                    paramModelData.prompt = STRINGS.get("new.adminpw", new Object[]{adminUsername});
                    paramModelData.promptAgain = STRINGS.get("new.adminpw.again", new Object[]{adminUsername});
                    paramModelData.param._password = true;
                    logger.info(STRINGS.get("new.adminpw.prompt"));
                    char[] password = super.getPassword((CommandModel.ParamModel)paramModelData, null, true);
                    String string = passwordCopy = password != null ? new String(password) : null;
                    if (passwordCopy == null) {
                        throw new CommandException(STRINGS.get("no.console"));
                    }
                    fileStorageManager.updateUser(adminUsername, adminUsername, passwordCopy.toCharArray(), null);
                    fileStorageManager.persist();
                }
            }
            catch (IOException ioe) {
                throw new CommandException((Throwable)ioe);
            }
        }
    }
}

