/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.stringsubs.impl;

import com.sun.enterprise.admin.servermgmt.SLogger;
import com.sun.enterprise.admin.servermgmt.stringsubs.impl.ArchiveEntryWrapper;
import com.sun.enterprise.admin.servermgmt.stringsubs.impl.ArchiveMember;
import com.sun.enterprise.admin.servermgmt.stringsubs.impl.ArchiveMemberHandler;
import com.sun.enterprise.admin.servermgmt.stringsubs.impl.SubstitutionFileUtil;
import com.sun.enterprise.admin.servermgmt.xml.stringsubs.Archive;
import com.sun.enterprise.admin.servermgmt.xml.stringsubs.MemberEntry;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.JarEntry;
import java.util.jar.JarException;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipOutputStream;
import org.glassfish.api.logging.LogHelper;

public class ArchiveEntryWrapperImpl
implements ArchiveEntryWrapper {
    private static final Logger LOGGER = SLogger.getLogger();
    private static final LocalStringsImpl STRINGS = new LocalStringsImpl(ArchiveEntryWrapperImpl.class);
    private static final String EXTRACTION_DIR_PREFIX = "ext";
    private static final byte[] BUFFER = new byte[10000];
    private Archive archive;
    private ArchiveEntryWrapperImpl parent = null;
    private File extractDir = null;
    private JarFile jar = null;
    private List<ArchiveMember> allArchiveMembers;
    private final Map<String, File> extractedEntries = new HashMap<String, File>();
    private final AtomicInteger noOfExtractedEntries = new AtomicInteger();

    ArchiveEntryWrapperImpl(Archive archive) throws IOException {
        this(archive, null, null);
    }

    private ArchiveEntryWrapperImpl(Archive archive, String archivePath, ArchiveEntryWrapperImpl parent) throws IOException {
        this.archive = archive;
        this.jar = archivePath == null || archivePath.isEmpty() ? new JarFile(archive.getName()) : new JarFile(archivePath + archive.getName());
        this.parent = parent;
        this.extractDir = SubstitutionFileUtil.setupDir(EXTRACTION_DIR_PREFIX);
        this.extract();
    }

    @Override
    public ArchiveEntryWrapper getParentArchive() {
        return this.parent;
    }

    @Override
    public List<? extends ArchiveMember> getSubstitutables() {
        return this.allArchiveMembers != null ? this.allArchiveMembers : new ArrayList(1);
    }

    @Override
    public void notifyCompletion() {
        if (this.noOfExtractedEntries.decrementAndGet() <= 0) {
            try {
                this.updateArchive();
                SubstitutionFileUtil.removeDir(this.extractDir);
                if (this.parent != null) {
                    this.parent.notifyCompletion();
                }
            }
            catch (IOException e) {
                SubstitutionFileUtil.removeDir(this.extractDir);
                LogHelper.log((Logger)LOGGER, (Level)Level.WARNING, (String)"NCLS-SRVRMGMT-00021", (Throwable)e, (Object[])new Object[]{this.archive.getName()});
            }
        }
    }

    private void extract() throws IOException {
        for (Object object : this.archive.getArchiveOrMemberEntry()) {
            File file;
            String extratFilePath = this.extractDir.getAbsolutePath() + File.separator;
            if (object instanceof Archive) {
                Archive archive = (Archive)object;
                file = new File(extratFilePath + archive.getName());
                try {
                    this.extractEntry(archive.getName(), file);
                }
                catch (IllegalArgumentException e) {
                    continue;
                }
                this.extractedEntries.put(archive.getName(), file);
                new ArchiveEntryWrapperImpl(archive, extratFilePath, this);
                this.noOfExtractedEntries.incrementAndGet();
                continue;
            }
            if (object instanceof MemberEntry) {
                MemberEntry entry = (MemberEntry)object;
                file = new File(extratFilePath + entry.getName());
                try {
                    this.extractEntry(entry.getName(), file);
                }
                catch (IllegalArgumentException e) {
                    continue;
                }
                this.extractedEntries.put(entry.getName(), file);
                this.getAllArchiveMemberList().add(new ArchiveMemberHandler(file, this));
                this.noOfExtractedEntries.incrementAndGet();
                continue;
            }
            LOGGER.log(Level.WARNING, "NCLS-SRVRMGMT-00022", new Object[]{object, this.archive.getName()});
        }
    }

    private List<ArchiveMember> getAllArchiveMemberList() {
        ArchiveEntryWrapperImpl current = this;
        while (current.parent != null) {
            current = current.parent;
        }
        if (current.allArchiveMembers == null) {
            current.allArchiveMembers = new ArrayList<ArchiveMember>();
        }
        return current.allArchiveMembers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractEntry(String name, File file) throws IOException {
        FilterOutputStream outputStream;
        block19: {
            if (this.jar == null) {
                throw new JarException("Jar file is closed.");
            }
            JarEntry jarEntry = this.jar.getJarEntry(name);
            if (jarEntry == null) {
                String msg = STRINGS.get("invalidArchiveEntry", new Object[]{name, this.jar.getName()});
                throw new IllegalArgumentException(msg);
            }
            if (jarEntry.isDirectory() && !file.exists()) {
                if (!file.mkdirs()) {
                    LOGGER.log(Level.INFO, "NCLS-SRVRMGMT-00011", file.getAbsolutePath());
                }
                return;
            }
            InputStream in = null;
            outputStream = null;
            try {
                in = this.jar.getInputStream(jarEntry);
                outputStream = new BufferedOutputStream(new FileOutputStream(file));
                int i = 0;
                while ((i = in.read(BUFFER)) != -1) {
                    ((BufferedOutputStream)outputStream).write(BUFFER, 0, i);
                }
                if (in == null) break block19;
            }
            catch (Throwable throwable) {
                block21: {
                    block20: {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Exception e) {
                                if (!LOGGER.isLoggable(Level.FINER)) break block20;
                                LOGGER.log(Level.FINER, STRINGS.get("errorInClosingStream", new Object[]{this.jar.getName()}), e);
                            }
                        }
                    }
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (Exception e) {
                            if (!LOGGER.isLoggable(Level.FINER)) break block21;
                            LOGGER.log(Level.FINER, STRINGS.get("errorInClosingStream", new Object[]{file.getPath()}), e);
                        }
                    }
                }
                throw throwable;
            }
            try {
                in.close();
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.FINER)) break block19;
                LOGGER.log(Level.FINER, STRINGS.get("errorInClosingStream", new Object[]{this.jar.getName()}), e);
            }
        }
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.log(Level.FINER, STRINGS.get("errorInClosingStream", new Object[]{file.getPath()}), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void updateArchive() throws IOException {
        block58: {
            boolean success;
            ZipOutputStream jos;
            FileOutputStream fos;
            File jarFile;
            File tempJarFile;
            block51: {
                block50: {
                    block49: {
                        if (this.extractedEntries.isEmpty()) {
                            if (LOGGER.isLoggable(Level.FINER)) {
                                LOGGER.log(Level.FINER, STRINGS.get("noArchiveEntryToUpdate", new Object[]{this.archive.getName()}));
                            }
                            return;
                        }
                        if (this.jar == null) {
                            throw new JarException("Jar file is not in open state, jar path.");
                        }
                        tempJarFile = null;
                        jarFile = null;
                        fos = null;
                        jos = null;
                        success = false;
                        String jarEntryName = null;
                        jarFile = new File(this.jar.getName());
                        tempJarFile = File.createTempFile("helper", ".jar", jarFile.getParentFile());
                        fos = new FileOutputStream(tempJarFile);
                        jos = new JarOutputStream(fos);
                        InputStream is = null;
                        Set<String> extractedJarEntries = this.extractedEntries.keySet();
                        Enumeration<JarEntry> e = this.jar.entries();
                        while (e.hasMoreElements()) {
                            jarEntryName = e.nextElement().getName();
                            if (extractedJarEntries.contains(jarEntryName)) {
                                File file = this.extractedEntries.get(jarEntryName);
                                if (file == null) continue;
                                JarEntry entry = new JarEntry(jarEntryName);
                                is = new FileInputStream(file);
                                this.appendEntry((JarOutputStream)jos, entry, is);
                                continue;
                            }
                            JarEntry je = this.jar.getJarEntry(jarEntryName);
                            is = this.jar.getInputStream(je);
                            this.appendEntry((JarOutputStream)jos, je, is);
                        }
                        success = true;
                        if (jos == null) break block49;
                        try {
                            jos.close();
                        }
                        catch (IOException e2) {
                            if (!LOGGER.isLoggable(Level.FINER)) break block49;
                            LOGGER.log(Level.FINER, STRINGS.get("errorInClosingStream", new Object[]{jarFile.getPath()}), e2);
                        }
                    }
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException e) {
                            if (!LOGGER.isLoggable(Level.FINER)) break block50;
                            LOGGER.log(Level.FINER, STRINGS.get("errorInClosingStream", new Object[]{jarFile.getPath()}), e);
                        }
                    }
                }
                try {
                    this.jar.close();
                }
                catch (IOException e) {
                    if (!LOGGER.isLoggable(Level.FINER)) break block51;
                    LOGGER.log(Level.FINER, "Problem occurred while closing the jar file : " + jarFile.getPath(), e);
                }
            }
            if (jarFile != null && !jarFile.delete()) {
                if (tempJarFile != null && !tempJarFile.delete()) {
                    LOGGER.log(Level.SEVERE, "NCLS-SRVRMGMT-00023", tempJarFile.getAbsolutePath());
                }
                throw new IOException(jarFile.getPath() + " did not get updated. Unable to delete.");
            }
            if (!success) {
                if (tempJarFile != null && !tempJarFile.delete()) {
                    LOGGER.log(Level.INFO, STRINGS.get("errorInClosingStream", new Object[]{tempJarFile.getAbsolutePath()}));
                }
            } else if (tempJarFile != null && !tempJarFile.renameTo(jarFile)) {
                LOGGER.log(Level.SEVERE, "NCLS-SRVRMGMT-00024", new Object[]{tempJarFile.getName(), jarFile.getName()});
            }
            break block58;
            catch (Exception e) {
                block54: {
                    block53: {
                        block52: {
                            try {
                                LogHelper.log((Logger)LOGGER, (Level)Level.SEVERE, (String)"NCLS-SRVRMGMT-00023", (Throwable)e, (Object[])new Object[]{this.archive.getName()});
                                if (jos == null) break block52;
                            }
                            catch (Throwable throwable) {
                                block57: {
                                    block56: {
                                        block55: {
                                            if (jos != null) {
                                                try {
                                                    jos.close();
                                                }
                                                catch (IOException e3) {
                                                    if (!LOGGER.isLoggable(Level.FINER)) break block55;
                                                    LOGGER.log(Level.FINER, STRINGS.get("errorInClosingStream", new Object[]{jarFile.getPath()}), e3);
                                                }
                                            }
                                        }
                                        if (fos != null) {
                                            try {
                                                fos.close();
                                            }
                                            catch (IOException e4) {
                                                if (!LOGGER.isLoggable(Level.FINER)) break block56;
                                                LOGGER.log(Level.FINER, STRINGS.get("errorInClosingStream", new Object[]{jarFile.getPath()}), e4);
                                            }
                                        }
                                    }
                                    try {
                                        this.jar.close();
                                    }
                                    catch (IOException e5) {
                                        if (!LOGGER.isLoggable(Level.FINER)) break block57;
                                        LOGGER.log(Level.FINER, "Problem occurred while closing the jar file : " + jarFile.getPath(), e5);
                                    }
                                }
                                if (jarFile != null && !jarFile.delete()) {
                                    if (tempJarFile != null && !tempJarFile.delete()) {
                                        LOGGER.log(Level.SEVERE, "NCLS-SRVRMGMT-00023", tempJarFile.getAbsolutePath());
                                    }
                                    throw new IOException(jarFile.getPath() + " did not get updated. Unable to delete.");
                                }
                                if (!success) {
                                    if (tempJarFile != null && !tempJarFile.delete()) {
                                        LOGGER.log(Level.INFO, STRINGS.get("errorInClosingStream", new Object[]{tempJarFile.getAbsolutePath()}));
                                    }
                                } else if (tempJarFile != null && !tempJarFile.renameTo(jarFile)) {
                                    LOGGER.log(Level.SEVERE, "NCLS-SRVRMGMT-00024", new Object[]{tempJarFile.getName(), jarFile.getName()});
                                }
                                throw throwable;
                            }
                            try {
                                jos.close();
                            }
                            catch (IOException e6) {
                                if (!LOGGER.isLoggable(Level.FINER)) break block52;
                                LOGGER.log(Level.FINER, STRINGS.get("errorInClosingStream", new Object[]{jarFile.getPath()}), e6);
                            }
                        }
                        if (fos != null) {
                            try {
                                fos.close();
                            }
                            catch (IOException e7) {
                                if (!LOGGER.isLoggable(Level.FINER)) break block53;
                                LOGGER.log(Level.FINER, STRINGS.get("errorInClosingStream", new Object[]{jarFile.getPath()}), e7);
                            }
                        }
                    }
                    try {
                        this.jar.close();
                    }
                    catch (IOException e8) {
                        if (!LOGGER.isLoggable(Level.FINER)) break block54;
                        LOGGER.log(Level.FINER, "Problem occurred while closing the jar file : " + jarFile.getPath(), e8);
                    }
                }
                if (jarFile != null && !jarFile.delete()) {
                    if (tempJarFile != null && !tempJarFile.delete()) {
                        LOGGER.log(Level.SEVERE, "NCLS-SRVRMGMT-00023", tempJarFile.getAbsolutePath());
                    }
                    throw new IOException(jarFile.getPath() + " did not get updated. Unable to delete.");
                }
                if (!success) {
                    if (tempJarFile != null && !tempJarFile.delete()) {
                        LOGGER.log(Level.INFO, STRINGS.get("errorInClosingStream", new Object[]{tempJarFile.getAbsolutePath()}));
                    }
                } else if (tempJarFile != null && !tempJarFile.renameTo(jarFile)) {
                    LOGGER.log(Level.SEVERE, "NCLS-SRVRMGMT-00024", new Object[]{tempJarFile.getName(), jarFile.getName()});
                }
            }
        }
    }

    private void appendEntry(JarOutputStream jos, JarEntry jarEntry, InputStream is) throws IOException {
        jos.putNextEntry(jarEntry);
        if (!jarEntry.isDirectory()) {
            int i = 0;
            while ((i = is.read(BUFFER)) != -1) {
                jos.write(BUFFER, 0, i);
            }
            is.close();
            jos.flush();
        }
        jos.closeEntry();
    }
}

