/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.util;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.Producer;
import com.sun.messaging.jmq.jmsserver.core.ProducerUID;
import com.sun.messaging.jmq.jmsserver.management.util.ConnectionUtil;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.admin.ConnectionInfo;
import com.sun.messaging.jmq.util.net.IPAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public class ProducerUtil {
    private static volatile CompositeType monitorCompType = null;

    public static ConnectionUID getConnectionUID(ProducerUID pid) {
        Producer p = (Producer)Producer.getProducer(pid);
        if (p == null) {
            return null;
        }
        ConnectionUID cxnId = p.getConnectionUID();
        return cxnId;
    }

    public static String[] getProducerIDs() {
        int numProducers = Producer.getNumProducers();
        if (numProducers <= 0) {
            return null;
        }
        String[] ids = new String[numProducers];
        Iterator producers = Producer.getAllProducers();
        int i = 0;
        while (producers.hasNext()) {
            Producer oneProd = (Producer)producers.next();
            long prodID = oneProd.getProducerUID().longValue();
            ids[i] = Long.toString(prodID);
            ++i;
        }
        return ids;
    }

    public static CompositeData[] getProducerInfo() throws BrokerException, OpenDataException {
        String[] ids = ProducerUtil.getProducerIDs();
        if (ids == null) {
            return null;
        }
        CompositeData[] cds = new CompositeData[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            cds[i] = ProducerUtil.getProducerInfo(ids[i]);
        }
        return cds;
    }

    public static CompositeData getProducerInfo(String producerID) throws BrokerException, OpenDataException {
        CompositeData cd = null;
        ProducerUID pid = null;
        BrokerResources rb = Globals.getBrokerResources();
        if (producerID == null) {
            throw new IllegalArgumentException(rb.getString("B4266"));
        }
        long longPid = 0L;
        try {
            longPid = Long.parseLong(producerID);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(rb.getString("B4267", producerID));
        }
        pid = new ProducerUID(longPid);
        cd = ProducerUtil.getProducerInfo(pid);
        return cd;
    }

    public static String getConnectionID(ProducerUID pid) {
        ConnectionUID cxnId = ProducerUtil.getConnectionUID(pid);
        if (cxnId == null) {
            return null;
        }
        return Long.toString(cxnId.longValue());
    }

    public static String getDestinationName(ProducerUID pid) {
        Producer p = (Producer)Producer.getProducer(pid);
        if (p != null) {
            DestinationUID did = p.getDestinationUID();
            if (did == null) {
                return null;
            }
            return did.getName();
        }
        return null;
    }

    private static String[] getDestinationNames(ProducerUID pid) {
        Producer p = (Producer)Producer.getProducer(pid);
        String[] ret = null;
        if (p == null) {
            return null;
        }
        ArrayList<String> al = new ArrayList<String>();
        Set dests = p.getDestinations();
        for (DestinationUID duid : dests) {
            al.add(duid.getName());
        }
        if (al.size() > 0) {
            ret = new String[al.size()];
            ret = al.toArray(ret);
        }
        return ret;
    }

    public static String getDestinationType(ProducerUID pid) {
        Producer p = (Producer)Producer.getProducer(pid);
        if (p != null) {
            DestinationUID did = p.getDestinationUID();
            return did.isQueue() ? "q" : "t";
        }
        return null;
    }

    public static Boolean getFlowPaused(ProducerUID pid) {
        Producer p = (Producer)Producer.getProducer(pid);
        if (p == null) {
            return null;
        }
        return p.isPaused();
    }

    public static String getHost(ProducerUID pid) {
        Producer p = (Producer)Producer.getProducer(pid);
        ConnectionUID cxnId = null;
        if (p == null) {
            return null;
        }
        cxnId = p.getConnectionUID();
        if (cxnId == null) {
            return null;
        }
        ConnectionInfo cxnInfo = ConnectionUtil.getConnectionInfo(cxnId.longValue());
        if (cxnInfo == null) {
            return null;
        }
        String host = null;
        if (cxnInfo.remoteIP != null) {
            host = String.valueOf(IPAddress.rawIPToString((byte[])cxnInfo.remoteIP, (boolean)true, (boolean)true));
        }
        return host;
    }

    public static Long getCreationTime(ProducerUID pid) {
        long currentTime = System.currentTimeMillis();
        return currentTime - pid.age(currentTime);
    }

    public static Long getNumMsgs(ProducerUID pid) {
        Producer p = (Producer)Producer.getProducer(pid);
        if (p == null) {
            return null;
        }
        return p.getMsgCnt();
    }

    public static String getServiceName(ProducerUID pid) {
        Producer p = (Producer)Producer.getProducer(pid);
        ConnectionUID cxnId = null;
        if (p == null) {
            return null;
        }
        cxnId = p.getConnectionUID();
        if (cxnId == null) {
            return null;
        }
        return ConnectionUtil.getServiceOfConnection(cxnId.longValue());
    }

    public static String getUser(ProducerUID pid) {
        Producer p = (Producer)Producer.getProducer(pid);
        ConnectionUID cxnId = null;
        if (p == null) {
            return null;
        }
        cxnId = p.getConnectionUID();
        if (cxnId == null) {
            return null;
        }
        ConnectionInfo cxnInfo = ConnectionUtil.getConnectionInfo(cxnId.longValue());
        return cxnInfo.user;
    }

    public static boolean isWildcard(ProducerUID pid) {
        Producer p = (Producer)Producer.getProducer(pid);
        if (p != null) {
            return p.isWildcard();
        }
        return false;
    }

    private static Boolean getWildcard(ProducerUID pid) {
        return ProducerUtil.isWildcard(pid);
    }

    private static CompositeData getProducerInfo(ProducerUID pid) throws OpenDataException {
        String[] producerInfoMonitorItemNames;
        String[] producerInfoMonitorItemDesc = producerInfoMonitorItemNames = new String[]{"ConnectionID", "CreationTime", "DestinationName", "DestinationNames", "DestinationType", "FlowPaused", "Host", "NumMsgs", "ProducerID", "ServiceName", "User", "Wildcard"};
        OpenType[] producerInfoMonitorItemTypes = new OpenType[]{SimpleType.STRING, SimpleType.LONG, SimpleType.STRING, new ArrayType(1, SimpleType.STRING), SimpleType.STRING, SimpleType.BOOLEAN, SimpleType.STRING, SimpleType.LONG, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.BOOLEAN};
        Object[] producerInfoMonitorItemValues = new Object[]{ProducerUtil.getConnectionID(pid), ProducerUtil.getCreationTime(pid), ProducerUtil.getDestinationName(pid), ProducerUtil.getDestinationNames(pid), ProducerUtil.getDestinationType(pid), ProducerUtil.getFlowPaused(pid), ProducerUtil.getHost(pid), ProducerUtil.getNumMsgs(pid), Long.toString(pid.longValue()), ProducerUtil.getServiceName(pid), ProducerUtil.getUser(pid), ProducerUtil.getWildcard(pid)};
        CompositeDataSupport cd = null;
        if (monitorCompType == null) {
            monitorCompType = new CompositeType("ProducerMonitorInfo", "ProducerMonitorInfo", producerInfoMonitorItemNames, producerInfoMonitorItemDesc, producerInfoMonitorItemTypes);
        }
        cd = new CompositeDataSupport(monitorCompType, producerInfoMonitorItemNames, producerInfoMonitorItemValues);
        return cd;
    }
}

