/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.appserver.micro.services;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.v3.services.impl.GrizzlyService;
import fish.payara.appserver.micro.services.PayaraClusteredCDIEventImpl;
import fish.payara.appserver.micro.services.PayaraInternalEvent;
import fish.payara.appserver.micro.services.command.AsAdminCallable;
import fish.payara.appserver.micro.services.command.ClusterCommandResultImpl;
import fish.payara.appserver.micro.services.data.ApplicationDescriptorImpl;
import fish.payara.appserver.micro.services.data.InstanceDescriptorImpl;
import fish.payara.micro.ClusterCommandResult;
import fish.payara.micro.PayaraInstance;
import fish.payara.micro.data.ApplicationDescriptor;
import fish.payara.micro.data.InstanceDescriptor;
import fish.payara.micro.event.CDIEventListener;
import fish.payara.micro.event.PayaraClusterListener;
import fish.payara.micro.event.PayaraClusteredCDIEvent;
import fish.payara.nucleus.cluster.PayaraCluster;
import fish.payara.nucleus.eventbus.ClusterMessage;
import fish.payara.nucleus.eventbus.MessageReceiver;
import fish.payara.nucleus.events.HazelcastEvents;
import fish.payara.nucleus.executorservice.PayaraExecutorService;
import fish.payara.nucleus.hazelcast.HazelcastCore;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.embeddable.CommandRunner;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.utils.Holder;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.deployment.Deployment;
import org.jvnet.hk2.annotations.Contract;
import org.jvnet.hk2.annotations.Service;

@Service(name="payara-instance")
@RunLevel(value=10)
@Contract
public class PayaraInstanceImpl
implements EventListener,
MessageReceiver,
PayaraInstance {
    public static final String INSTANCE_STORE_NAME = "payara.instance.store";
    public static final String INTERNAL_EVENTS_NAME = "payara.micro.cluster.event";
    public static final String CDI_EVENTS_NAME = "payara.micro.cdi.event";
    public static final String APPLICATIONS_STORE_NAME = "payara.micro.applications.store";
    private static final String APP_UNIQUE_ID_PROP = "org.glassfish.ejb.container.application_unique_id";
    private static final Logger logger = Logger.getLogger(PayaraInstanceImpl.class.getName());
    @Inject
    private ServiceLocator habitat;
    @Inject
    private PayaraCluster cluster;
    @Inject
    private ServerContext context;
    @Inject
    private Events events;
    @Inject
    private CommandRunner commandRunner;
    private HashSet<PayaraClusterListener> myListeners;
    private HashSet<CDIEventListener> myCDIListeners;
    private UUID myCurrentID;
    private Holder.LazyHolder<InstanceDescriptorImpl> descriptor = Holder.lazyHolder(this::initialiseInstanceDescriptor);
    @Inject
    private ServerEnvironment environment;
    @Inject
    private HazelcastCore hazelcast;
    @Inject
    private ApplicationRegistry appRegistry;
    @Inject
    private PayaraExecutorService executor;

    public String getInstanceName() {
        return ((InstanceDescriptorImpl)this.descriptor.get()).getInstanceName();
    }

    public void setInstanceName(String instanceName) {
        ((InstanceDescriptorImpl)this.descriptor.get()).setInstanceName(instanceName);
    }

    public <T extends Serializable> Map<UUID, Future<T>> runCallable(Collection<UUID> memberUUIDS, Callable<T> callable) {
        return this.cluster.getExecService().runCallable(memberUUIDS, callable);
    }

    public <T extends Serializable> Map<UUID, Future<T>> runCallable(Callable<T> callable) {
        return this.cluster.getExecService().runCallableAllMembers(callable);
    }

    public ClusterCommandResult executeLocalAsAdmin(String command, String ... parameters) {
        return new ClusterCommandResultImpl(this.commandRunner.run(command, parameters));
    }

    public Map<UUID, Future<ClusterCommandResult>> executeClusteredASAdmin(String command, String ... parameters) {
        AsAdminCallable callable = new AsAdminCallable(command, parameters);
        Map result = this.cluster.getExecService().runCallableAllMembers((Callable)callable);
        return result;
    }

    public Map<UUID, Future<ClusterCommandResult>> executeClusteredASAdmin(Collection<UUID> memberGUIDs, String command, String ... parameters) {
        AsAdminCallable callable = new AsAdminCallable(command, parameters);
        Map result = this.cluster.getExecService().runCallable(memberGUIDs, (Callable)callable);
        return result;
    }

    public void receiveMessage(ClusterMessage msg) {
        block9: {
            block8: {
                if (!(msg.getPayload() instanceof PayaraInternalEvent)) break block8;
                PayaraInternalEvent pie = (PayaraInternalEvent)PayaraInternalEvent.class.cast(msg.getPayload());
                switch (pie.getMessageType()) {
                    case ADDED: {
                        for (PayaraClusterListener myListener : this.myListeners) {
                            myListener.memberAdded(pie.getId());
                        }
                        break block9;
                    }
                    case REMOVED: {
                        for (PayaraClusterListener myListener : this.myListeners) {
                            myListener.memberRemoved(pie.getId());
                        }
                        break;
                    }
                }
                break block9;
            }
            if (msg.getPayload() instanceof PayaraClusteredCDIEventImpl) {
                PayaraClusteredCDIEventImpl cast = (PayaraClusteredCDIEventImpl)PayaraClusteredCDIEventImpl.class.cast(msg.getPayload());
                for (CDIEventListener myListener : this.myCDIListeners) {
                    if (!cast.isLoopBack() && cast.getInstanceDescriptor().getMemberUUID().equals(this.myCurrentID)) continue;
                    myListener.eventReceived((PayaraClusteredCDIEvent)cast);
                }
            }
        }
    }

    @PostConstruct
    void postConstruct() {
        this.events.register((EventListener)this);
        this.myListeners = new HashSet(1);
        this.myCDIListeners = new HashSet(1);
    }

    public void event(EventListener.Event event) {
        if (event.is(EventTypes.SERVER_READY)) {
            PayaraInternalEvent pie = new PayaraInternalEvent(PayaraInternalEvent.MESSAGE.ADDED, (InstanceDescriptor)this.descriptor.get());
            ClusterMessage message = new ClusterMessage((Serializable)pie);
            this.cluster.getEventBus().publish(INTERNAL_EVENTS_NAME, message);
            for (String appName : this.appRegistry.getAllApplicationNames()) {
                ((InstanceDescriptorImpl)this.descriptor.get()).addApplication(new ApplicationDescriptorImpl(this.appRegistry.get(appName)));
            }
            this.cluster.getClusteredStore().set(INSTANCE_STORE_NAME, (Serializable)this.myCurrentID, (Serializable)this.descriptor.get());
            this.executor.scheduleAtFixedRate(() -> {
                ((InstanceDescriptorImpl)this.descriptor.get()).setLastHeartBeat(System.currentTimeMillis());
                if (this.myCurrentID != null) {
                    this.cluster.getClusteredStore().set(INSTANCE_STORE_NAME, (Serializable)this.myCurrentID, (Serializable)this.descriptor.get());
                }
            }, 0L, 5L, TimeUnit.SECONDS);
        } else if (event.is(Deployment.APPLICATION_STARTED)) {
            if (event.hook() != null && event.hook() instanceof ApplicationInfo) {
                ApplicationInfo applicationInfo = (ApplicationInfo)event.hook();
                ((InstanceDescriptorImpl)this.descriptor.get()).addApplication(new ApplicationDescriptorImpl(applicationInfo));
                logger.log(Level.FINE, "App Loaded: {2}, Enabled: {0}, my ID: {1}", new Object[]{this.hazelcast.isEnabled(), this.myCurrentID, applicationInfo.getName()});
                this.cluster.getClusteredStore().set(INSTANCE_STORE_NAME, (Serializable)this.myCurrentID, (Serializable)this.descriptor.get());
            }
        } else if (event.is(Deployment.APPLICATION_PREPARED)) {
            DeploymentContext deploymentContext;
            Application app;
            if (event.hook() != null && event.hook() instanceof DeploymentContext && (app = (Application)(deploymentContext = (DeploymentContext)event.hook()).getModuleMetaData(Application.class)) != null) {
                Long appID = (Long)this.cluster.getClusteredStore().get(APPLICATIONS_STORE_NAME, (Serializable)((Object)app.getName()));
                if (appID != null) {
                    app.setUniqueId(appID.longValue());
                    deploymentContext.getAppProps().setProperty(APP_UNIQUE_ID_PROP, String.valueOf(appID));
                } else {
                    this.cluster.getClusteredStore().set(APPLICATIONS_STORE_NAME, (Serializable)((Object)app.getName()), (Serializable)Long.valueOf(app.getUniqueId()));
                    deploymentContext.getAppProps().setProperty(APP_UNIQUE_ID_PROP, String.valueOf(app.getUniqueId()));
                }
            }
        } else if (event.is(Deployment.APPLICATION_UNLOADED)) {
            if (event.hook() != null && event.hook() instanceof ApplicationInfo) {
                ApplicationInfo applicationInfo = (ApplicationInfo)event.hook();
                ((InstanceDescriptorImpl)this.descriptor.get()).removeApplication(new ApplicationDescriptorImpl(applicationInfo));
                this.cluster.getClusteredStore().set(INSTANCE_STORE_NAME, (Serializable)this.myCurrentID, (Serializable)this.descriptor.get());
            }
        } else if (event.is(HazelcastEvents.HAZELCAST_SHUTDOWN_STARTED)) {
            this.myCurrentID = null;
            PayaraInternalEvent pie = new PayaraInternalEvent(PayaraInternalEvent.MESSAGE.REMOVED, (InstanceDescriptor)this.descriptor.get());
            ClusterMessage message = new ClusterMessage((Serializable)pie);
            this.cluster.getClusteredStore().remove(INSTANCE_STORE_NAME, (Serializable)this.myCurrentID);
            this.cluster.getEventBus().publish(INTERNAL_EVENTS_NAME, message);
            this.descriptor = Holder.lazyHolder(this::initialiseInstanceDescriptor);
        }
        if (event.is(HazelcastEvents.HAZELCAST_BOOTSTRAP_COMPLETE)) {
            this.descriptor.get();
            logger.log(Level.FINE, "Hz Bootstrap Complete, Enabled: {0}, my ID: {1}", new Object[]{this.hazelcast.isEnabled(), this.myCurrentID});
            this.cluster.getEventBus().removeMessageReceiver(INTERNAL_EVENTS_NAME, (MessageReceiver)this);
            this.cluster.getEventBus().removeMessageReceiver(CDI_EVENTS_NAME, (MessageReceiver)this);
            this.cluster.getEventBus().addMessageReceiver(INTERNAL_EVENTS_NAME, (MessageReceiver)this);
            this.cluster.getEventBus().addMessageReceiver(CDI_EVENTS_NAME, (MessageReceiver)this);
        }
        if (event.is(HazelcastEvents.HAZELCAST_GENERATED_NAME_CHANGE)) {
            this.descriptor.get();
        }
    }

    public Set<InstanceDescriptor> getClusteredPayaras() {
        Set members = this.cluster.getClusterMembers();
        HashSet<InstanceDescriptor> result = new HashSet<InstanceDescriptor>(members.size());
        for (UUID member : members) {
            InstanceDescriptor id = (InstanceDescriptor)this.cluster.getClusteredStore().get(INSTANCE_STORE_NAME, (Serializable)member);
            if (id == null) continue;
            result.add(id);
        }
        return result;
    }

    public void publishCDIEvent(PayaraClusteredCDIEvent event) {
        if (event.getInstanceDescriptor() == null) {
            event.setId((InstanceDescriptor)this.descriptor.get());
        }
        ClusterMessage message = new ClusterMessage((Serializable)event);
        this.cluster.getEventBus().publish(CDI_EVENTS_NAME, message);
    }

    public void removeBootstrapListener(PayaraClusterListener listener) {
        this.myListeners.remove(listener);
    }

    public void addBootstrapListener(PayaraClusterListener listener) {
        this.myListeners.add(listener);
    }

    public void removeCDIListener(CDIEventListener listener) {
        this.myCDIListeners.remove(listener);
    }

    public void addCDIListener(CDIEventListener listener) {
        this.myCDIListeners.add(listener);
    }

    public InstanceDescriptor getLocalDescriptor() {
        return (InstanceDescriptor)this.descriptor.get();
    }

    public InstanceDescriptorImpl getDescriptor(UUID member) {
        InstanceDescriptorImpl result = null;
        if (this.cluster.isEnabled()) {
            result = (InstanceDescriptorImpl)((Object)this.cluster.getClusteredStore().get(INSTANCE_STORE_NAME, (Serializable)member));
        }
        return result;
    }

    private InstanceDescriptorImpl initialiseInstanceDescriptor() {
        String instanceName = "payara-micro";
        String instanceGroup = "no-cluster";
        boolean liteMember = false;
        int hazelcastPort = 5900;
        InetAddress hostname = null;
        if (this.hazelcast.isEnabled()) {
            instanceName = this.hazelcast.getMemberName();
            instanceGroup = this.hazelcast.getMemberGroup();
            this.myCurrentID = this.hazelcast.getUUID();
            liteMember = this.hazelcast.isLite();
            hazelcastPort = this.hazelcast.getPort();
            hostname = this.hazelcast.getInstance().getCluster().getLocalMember().getSocketAddress().getAddress();
        }
        String instanceType = this.environment.getRuntimeType().toString();
        ArrayList<Integer> ports = new ArrayList<Integer>();
        ArrayList<Integer> sslPorts = new ArrayList<Integer>();
        int adminPort = 0;
        for (NetworkListener networkListener : this.context.getConfigBean().getConfig().getNetworkConfig().getNetworkListeners().getNetworkListener()) {
            int port = Integer.parseInt(networkListener.getPort());
            try {
                port = ((GrizzlyService)this.habitat.getService(GrizzlyService.class, new Annotation[0])).getRealPort(networkListener);
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "Failed to get running Grizzly listener.", ex);
            }
            if (!Boolean.parseBoolean(networkListener.getEnabled())) continue;
            if (networkListener.findProtocol().getSecurityEnabled().equals("false")) {
                if (networkListener.getName().equals(this.context.getConfigBean().getConfig().getAdminListener().getName())) {
                    if (instanceType.equals("MICRO")) {
                        ports.add(port);
                    }
                    adminPort = port;
                    continue;
                }
                ports.add(port);
                continue;
            }
            if (!networkListener.findProtocol().getSecurityEnabled().equals("true")) continue;
            if (networkListener.getName().equals(this.context.getConfigBean().getConfig().getAdminListener().getName())) {
                if (instanceType.equals("MICRO")) {
                    ports.add(port);
                }
                adminPort = port;
                continue;
            }
            sslPorts.add(port);
        }
        try {
            InstanceDescriptorImpl instanceDescriptor = new InstanceDescriptorImpl(this.myCurrentID);
            Collection<ApplicationDescriptor> deployedApplications = instanceDescriptor.getDeployedApplications();
            instanceDescriptor.setInstanceName(instanceName);
            instanceDescriptor.setInstanceGroup(instanceGroup);
            Iterator<Object> iterator = ports.iterator();
            while (iterator.hasNext()) {
                int port = (Integer)iterator.next();
                instanceDescriptor.addHttpPort(port);
            }
            iterator = sslPorts.iterator();
            while (iterator.hasNext()) {
                int sslPort = (Integer)iterator.next();
                instanceDescriptor.addHttpsPort(sslPort);
            }
            instanceDescriptor.setAdminPort(adminPort);
            instanceDescriptor.setHazelcastPort(hazelcastPort);
            instanceDescriptor.setLiteMember(liteMember);
            instanceDescriptor.setInstanceType(instanceType);
            if (hostname != null) {
                instanceDescriptor.setHostName(hostname);
            }
            if (!deployedApplications.isEmpty()) {
                for (ApplicationDescriptor application : deployedApplications) {
                    instanceDescriptor.addApplication(application);
                }
            }
            if (this.cluster.isEnabled()) {
                this.cluster.getClusteredStore().set(INSTANCE_STORE_NAME, (Serializable)this.myCurrentID, (Serializable)((Object)instanceDescriptor));
            }
            return instanceDescriptor;
        }
        catch (UnknownHostException ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean isClustered() {
        return this.cluster.isEnabled();
    }
}

