/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.healthcheck;

import fish.payara.nucleus.healthcheck.HistoricHealthCheckEvent;
import fish.payara.nucleus.healthcheck.HistoricHealthCheckEventStore;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.concurrent.TimeUnit;
import org.glassfish.internal.api.Globals;

final class HistoricHealthCheckCleanupTask
implements Runnable {
    private final long timeLimit;

    HistoricHealthCheckCleanupTask(long timeLimit) {
        this.timeLimit = timeLimit;
    }

    @Override
    public void run() {
        HistoricHealthCheckEventStore store = (HistoricHealthCheckEventStore)Globals.getDefaultHabitat().getService(HistoricHealthCheckEventStore.class, new Annotation[0]);
        NavigableSet<HistoricHealthCheckEvent> historicStore = store.getHistoricStore();
        Iterator<HistoricHealthCheckEvent> iterator = historicStore.descendingIterator();
        while (iterator.hasNext()) {
            HistoricHealthCheckEvent event = iterator.next();
            long upTimeInMillis = System.currentTimeMillis() - event.getOccurringTime();
            if (TimeUnit.MILLISECONDS.toSeconds(upTimeInMillis) <= this.timeLimit) continue;
            historicStore.remove(event);
        }
    }
}

