/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.healthcheck.preliminary;

import com.sun.enterprise.util.LocalStringManagerImpl;
import fish.payara.internal.notification.EventLevel;
import fish.payara.internal.notification.PayaraNotification;
import fish.payara.internal.notification.PayaraNotificationFactory;
import fish.payara.notification.healthcheck.HealthCheckNotificationData;
import fish.payara.notification.healthcheck.HealthCheckResultEntry;
import fish.payara.notification.healthcheck.HealthCheckResultStatus;
import fish.payara.nucleus.healthcheck.HealthCheckConstants;
import fish.payara.nucleus.healthcheck.HealthCheckExecutionOptions;
import fish.payara.nucleus.healthcheck.HealthCheckResult;
import fish.payara.nucleus.healthcheck.HealthCheckService;
import fish.payara.nucleus.healthcheck.HistoricHealthCheckEventStore;
import fish.payara.nucleus.healthcheck.configuration.Checker;
import fish.payara.nucleus.healthcheck.configuration.HealthCheckServiceConfiguration;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.glassfish.hk2.api.messaging.Topic;
import org.jvnet.hk2.annotations.Contract;
import org.jvnet.hk2.annotations.Optional;

@Contract
public abstract class BaseHealthCheck<O extends HealthCheckExecutionOptions, C extends Checker>
implements HealthCheckConstants {
    private static final LocalStringManagerImpl strings = new LocalStringManagerImpl(BaseHealthCheck.class);
    @Inject
    protected HealthCheckService healthCheckService;
    @Inject
    @Named(value="default-instance-name")
    @Optional
    HealthCheckServiceConfiguration configuration;
    @Inject
    private Topic<PayaraNotification> notificationEventBus;
    @Inject
    private PayaraNotificationFactory notificationFactory;
    @Inject
    private HistoricHealthCheckEventStore healthCheckEventStore;
    protected O options;
    protected Class<C> checkerType;
    private final AtomicInteger checksDone = new AtomicInteger();
    private final AtomicInteger checksFailed = new AtomicInteger();
    private final AtomicBoolean inProcess = new AtomicBoolean(false);
    private volatile HealthCheckResult mostRecentResult;

    public final HealthCheckResult doCheck() {
        if (!((HealthCheckExecutionOptions)this.getOptions()).isEnabled() || this.inProcess.compareAndSet(false, true)) {
            return null;
        }
        try {
            HealthCheckResult result;
            this.mostRecentResult = result = this.doCheckInternal();
            HealthCheckResult healthCheckResult = result;
            return healthCheckResult;
        }
        catch (Exception ex) {
            this.checksFailed.incrementAndGet();
            throw ex;
        }
        finally {
            this.inProcess.set(false);
            this.checksDone.incrementAndGet();
        }
    }

    protected abstract HealthCheckResult doCheckInternal();

    protected abstract EventLevel createNotificationEventLevel(HealthCheckResultStatus var1);

    public abstract O constructOptions(C var1);

    public HealthCheckResultStatus getMostRecentCumulativeStatus() {
        return this.mostRecentResult.getCumulativeStatus();
    }

    public HealthCheckResult getMostRecentResult() {
        return this.mostRecentResult;
    }

    public boolean isInProgress() {
        return this.inProcess.get();
    }

    public int getChecksDone() {
        return this.checksDone.get();
    }

    public int getChecksFailed() {
        return this.checksFailed.get();
    }

    public boolean isReady() {
        O options = this.getOptions();
        return !this.isInProgress() && options != null && ((HealthCheckExecutionOptions)options).isEnabled();
    }

    public boolean isEnabled() {
        return ((HealthCheckExecutionOptions)this.getOptions()).isEnabled();
    }

    protected <T extends BaseHealthCheck> O postConstruct(T t, Class<C> checkerType) {
        this.checkerType = checkerType;
        if (this.configuration == null) {
            return null;
        }
        C checker = this.configuration.getCheckerByType(this.checkerType);
        if (checker != null) {
            this.options = this.constructOptions(checker);
            this.healthCheckService.registerCheck(checker.getName(), t);
        }
        return this.options;
    }

    protected HealthCheckExecutionOptions constructBaseOptions(Checker checker) {
        return new HealthCheckExecutionOptions(Boolean.valueOf(checker.getEnabled()), Long.parseLong(checker.getTime()), this.asTimeUnit(checker.getUnit()), Boolean.valueOf(checker.getAddToMicroProfileHealth()));
    }

    protected TimeUnit asTimeUnit(String unit) {
        return TimeUnit.valueOf(unit);
    }

    protected HealthCheckResultStatus decideOnStatusWithDuration(long duration) {
        if (duration > 300000L) {
            return HealthCheckResultStatus.CRITICAL;
        }
        if (duration > 60000L) {
            return HealthCheckResultStatus.WARNING;
        }
        if (duration > 0L) {
            return HealthCheckResultStatus.GOOD;
        }
        return HealthCheckResultStatus.CHECK_ERROR;
    }

    protected String prettyPrintBytes(long value) {
        DecimalFormat format = new DecimalFormat("#.00");
        String result = value / 0x40000000L > 0L ? format.format((double)value / 1.073741824E9) + " Gb" : (value / 0x100000L > 0L ? format.format((double)value / 1048576.0) + " Mb" : (value / 1024L > 0L ? format.format((double)value / 1024.0) + " Kb" : value + " bytes"));
        return result;
    }

    protected String prettyPrintStackTrace(StackTraceElement[] elements) {
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement traceElement : elements) {
            sb.append("\tat ").append(traceElement);
        }
        return sb.toString();
    }

    public String resolveDescription() {
        return strings.getLocalString(this.getDescription(), "");
    }

    protected abstract String getDescription();

    public O getOptions() {
        return this.options;
    }

    public void setOptions(O options) {
        this.options = options;
    }

    public Class<C> getCheckerType() {
        return this.checkerType;
    }

    public void sendNotification(String name, HealthCheckResult checkResult, Level level) {
        String message = "{0}:{1}";
        String subject = "Health Check notification with severity level: " + level.getName();
        String messageFormatted = this.getMessageFormatted(new Object[]{name, this.getCumulativeMessages(checkResult.getEntries())});
        Set<String> enabledNotifiers = this.healthCheckService.getEnabledNotifiers();
        PayaraNotification notification = this.notificationFactory.newBuilder().whitelist(enabledNotifiers.toArray(new String[0])).subject(name).message(messageFormatted).data((Serializable)new HealthCheckNotificationData(checkResult.getEntries())).eventType(level.getName()).level(this.createNotificationEventLevel(checkResult.getCumulativeStatus())).build();
        this.notificationEventBus.publish((Object)notification);
        if (this.healthCheckService.isHistoricalTraceEnabled()) {
            this.healthCheckEventStore.addTrace(new Date().getTime(), level, subject, message, new Object[]{name, checkResult.getEntries().toString()});
        }
    }

    private String getMessageFormatted(Object[] parameters) {
        String formattedMessage = null;
        if (parameters != null && parameters.length > 0) {
            formattedMessage = MessageFormat.format("{0}:{1}", parameters);
        }
        return formattedMessage;
    }

    private String getCumulativeMessages(List<HealthCheckResultEntry> entries) {
        return "Health Check Result:" + entries.toString();
    }
}

