/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.healthcheck.preliminary;

import fish.payara.internal.notification.EventLevel;
import fish.payara.monitoring.collect.MonitoringWatchCollector;
import fish.payara.notification.healthcheck.HealthCheckResultStatus;
import fish.payara.nucleus.healthcheck.HealthCheckWithThresholdExecutionOptions;
import fish.payara.nucleus.healthcheck.configuration.ThresholdDiagnosticsChecker;
import fish.payara.nucleus.healthcheck.preliminary.BaseHealthCheck;
import org.jvnet.hk2.annotations.Contract;

@Contract
public abstract class BaseThresholdHealthCheck<O extends HealthCheckWithThresholdExecutionOptions, C extends ThresholdDiagnosticsChecker>
extends BaseHealthCheck<O, C> {
    public HealthCheckWithThresholdExecutionOptions constructThresholdOptions(ThresholdDiagnosticsChecker checker) {
        return new HealthCheckWithThresholdExecutionOptions(Boolean.valueOf(checker.getEnabled()), Long.parseLong(checker.getTime()), this.asTimeUnit(checker.getUnit()), Boolean.valueOf(checker.getAddToMicroProfileHealth()), checker.getPropertyValue("threshold-critical", "80"), checker.getPropertyValue("threshold-warning", "50"), checker.getPropertyValue("threshold-good", "0"));
    }

    protected HealthCheckResultStatus decideOnStatusWithRatio(double percentage) {
        if (percentage > (double)((HealthCheckWithThresholdExecutionOptions)this.options).getThresholdCritical()) {
            return HealthCheckResultStatus.CRITICAL;
        }
        if (percentage > (double)((HealthCheckWithThresholdExecutionOptions)this.options).getThresholdWarning()) {
            return HealthCheckResultStatus.WARNING;
        }
        if (percentage >= (double)((HealthCheckWithThresholdExecutionOptions)this.options).getThresholdGood()) {
            return HealthCheckResultStatus.GOOD;
        }
        return HealthCheckResultStatus.FINE;
    }

    @Override
    protected EventLevel createNotificationEventLevel(HealthCheckResultStatus checkResult) {
        if (checkResult == HealthCheckResultStatus.GOOD || checkResult == HealthCheckResultStatus.FINE) {
            return EventLevel.INFO;
        }
        if (checkResult == HealthCheckResultStatus.WARNING) {
            return EventLevel.WARNING;
        }
        return EventLevel.SEVERE;
    }

    @Override
    public O getOptions() {
        return (O)((HealthCheckWithThresholdExecutionOptions)this.options);
    }

    protected final void collectUsage(MonitoringWatchCollector collector, String series, String name, Number forLast, boolean onAverage) {
        if (this.options == null || !((HealthCheckWithThresholdExecutionOptions)this.options).isEnabled()) {
            return;
        }
        int red = ((HealthCheckWithThresholdExecutionOptions)this.options).getThresholdCritical();
        int amber = ((HealthCheckWithThresholdExecutionOptions)this.options).getThresholdWarning();
        int green = ((HealthCheckWithThresholdExecutionOptions)this.options).getThresholdGood();
        long amber2red = Math.min(5, (red - amber) / 2);
        long green2amber = Math.min(5, (amber - green) / 2);
        collector.watch((CharSequence)series, name, "percent").red((long)red, forLast, onAverage, Long.valueOf((long)red - amber2red), forLast, onAverage).amber((long)amber, forLast, onAverage, Long.valueOf((long)amber - green2amber), forLast, onAverage).green((long)green, null, false, null, null, false);
    }
}

