/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.connectioncache.impl.concurrent;

import com.sun.xml.ws.transport.tcp.connectioncache.spi.concurrent.ConcurrentQueue;

public class ConcurrentQueueImpl<V>
implements ConcurrentQueue<V> {
    final Entry<V> head = new Entry<Object>(null);
    int count = 0;

    public ConcurrentQueueImpl() {
        this.head.next = this.head;
        this.head.prev = this.head;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public ConcurrentQueue.Handle<V> offer(V arg) {
        if (arg == null) {
            throw new IllegalArgumentException("Argument cannot be null");
        }
        Entry<V> entry = new Entry<V>(arg);
        entry.next = this.head;
        entry.prev = this.head.prev;
        this.head.prev.next = entry;
        this.head.prev = entry;
        ++this.count;
        return entry.handle();
    }

    @Override
    public V poll() {
        Entry first = null;
        V value = null;
        first = this.head.next;
        if (first == this.head) {
            return null;
        }
        value = first.handle().value();
        first.handle().remove();
        first.next = null;
        first.prev = null;
        return value;
    }

    private final class HandleImpl<V>
    implements ConcurrentQueue.Handle<V> {
        private Entry<V> entry;
        private final V value;
        private boolean valid;

        HandleImpl(Entry<V> entry, V value) {
            this.entry = entry;
            this.value = value;
            this.valid = true;
        }

        Entry<V> entry() {
            return this.entry;
        }

        @Override
        public V value() {
            return this.value;
        }

        @Override
        public boolean remove() {
            if (!this.valid) {
                return false;
            }
            this.valid = false;
            this.entry.next.prev = this.entry.prev;
            this.entry.prev.next = this.entry.next;
            --ConcurrentQueueImpl.this.count;
            this.entry.prev = null;
            this.entry.next = null;
            this.entry.handle = null;
            this.entry = null;
            this.valid = false;
            return true;
        }
    }

    private final class Entry<V> {
        Entry<V> next = null;
        Entry<V> prev = null;
        private HandleImpl<V> handle;

        Entry(V value) {
            this.handle = new HandleImpl<V>(this, value);
        }

        HandleImpl<V> handle() {
            return this.handle;
        }
    }
}

