/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core.jws.servedcontent;

import com.sun.enterprise.server.pluggable.SecuritySupport;
import com.sun.enterprise.util.i18n.StringManager;
import jakarta.inject.Singleton;
import java.io.File;
import java.io.FileOutputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipOutputStream;
import jdk.security.jarsigner.JarSigner;
import org.glassfish.hk2.api.PostConstruct;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class ASJarSigner
implements PostConstruct {
    public static final String USER_SPECIFIED_ALIAS_PROPERTYNAME = "com.sun.aas.jws.signing.alias";
    private static final String DEFAULT_ALIAS_VALUE = "s1as";
    private static final String DEFAULT_DIGEST_ALGORITHM = "SHA1";
    private static final String DEFAULT_KEY_ALGORITHM = "RSA";
    private static final SecuritySupport securitySupport = SecuritySupport.getDefaultInstance();
    private static final StringManager localStrings = StringManager.getManager(ASJarSigner.class);
    private Logger logger;

    public void postConstruct() {
        this.logger = Logger.getLogger("javax.enterprise.system.container.appclient", "org.glassfish.appclient.server.LogMessages");
    }

    public long signJar(File unsignedJar, File signedJar, String alias, Attributes attrs) throws Exception {
        try (ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(signedJar));){
            long result;
            long l = result = this.signJar(unsignedJar, zout, alias, attrs, Collections.EMPTY_MAP);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long signJar(File unsignedJar, ZipOutputStream signedJar, String alias, Attributes attrs, Map<String, byte[]> additionalContent) throws Exception {
        if (alias == null) {
            alias = DEFAULT_ALIAS_VALUE;
        }
        long startTime = System.currentTimeMillis();
        long duration = 0L;
        ASJarSigner aSJarSigner = this;
        synchronized (aSJarSigner) {
            try {
                Certificate[] certificates = null;
                PrivateKey privateKey = null;
                KeyStore[] keyStores = securitySupport.getKeyStores();
                for (int i = 0; i < keyStores.length; ++i) {
                    privateKey = securitySupport.getPrivateKeyForAlias(alias, i);
                    if (privateKey == null) continue;
                    certificates = keyStores[i].getCertificateChain(alias);
                }
                CertPath certPath = CertificateFactory.getInstance("X.509").generateCertPath(Arrays.asList(certificates));
                JarSigner signer = new JarSigner.Builder(privateKey, certPath).digestAlgorithm(DEFAULT_DIGEST_ALGORITHM).signatureAlgorithm(DEFAULT_KEY_ALGORITHM).build();
                signer.sign(new JarFile(unsignedJar), signedJar);
            }
            catch (Throwable t) {
                try {
                    throw new Exception(localStrings.getString("jws.sign.errorSigning", (Object)unsignedJar.getAbsolutePath(), (Object)alias), t);
                }
                catch (Throwable throwable) {
                    duration = System.currentTimeMillis() - startTime;
                    this.logger.log(Level.FINE, "Signing {0} took {1} ms", new Object[]{unsignedJar.getAbsolutePath(), duration});
                    throw throwable;
                }
            }
            duration = System.currentTimeMillis() - startTime;
            this.logger.log(Level.FINE, "Signing {0} took {1} ms", new Object[]{unsignedJar.getAbsolutePath(), duration});
        }
        return duration;
    }

    public static class ASJarSignerException
    extends Exception {
        public ASJarSignerException(String msg, Throwable t) {
            super(msg, t);
        }
    }
}

