/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.deployment.archivist;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.annotation.impl.ModuleScanner;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFor;
import com.sun.enterprise.deployment.archivist.ExtensionsArchivist;
import com.sun.enterprise.deployment.io.ConfigurationDeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.DeploymentDescriptorFile;
import com.sun.enterprise.deployment.util.DOLUtils;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.archive.Archive;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.common.RootDeploymentDescriptor;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.web.LogFacade;
import org.glassfish.web.deployment.annotation.impl.WarScanner;
import org.glassfish.web.deployment.archivist.WebFragmentArchivist;
import org.glassfish.web.deployment.descriptor.OrderingDescriptor;
import org.glassfish.web.deployment.descriptor.WebBundleDescriptorImpl;
import org.glassfish.web.deployment.descriptor.WebComponentDescriptorStub;
import org.glassfish.web.deployment.descriptor.WebFragmentDescriptor;
import org.glassfish.web.deployment.io.WebDeploymentDescriptorFile;
import org.glassfish.web.deployment.util.WebBundleValidator;
import org.jvnet.hk2.annotations.Service;
import org.xml.sax.SAXParseException;

@Service
@PerLookup
@ArchivistFor(value="war")
public class WebArchivist
extends Archivist<WebBundleDescriptorImpl> {
    private static final Logger logger = LogFacade.getLogger();
    private static final String DEFAULT_WEB_XML = "default-web.xml";
    @Inject
    private ServerEnvironment env;
    private WebBundleDescriptorImpl defaultWebXmlBundleDescriptor = null;

    public ArchiveType getModuleType() {
        return DOLUtils.warType();
    }

    public void setDescriptor(Application descriptor) {
        Set webBundles = descriptor.getBundleDescriptors(WebBundleDescriptorImpl.class);
        if (webBundles.size() > 0) {
            this.descriptor = (WebBundleDescriptorImpl)((Object)webBundles.iterator().next());
            if (!((WebBundleDescriptorImpl)this.descriptor).getModuleDescriptor().isStandalone()) {
                this.descriptor = null;
            }
        }
    }

    public DeploymentDescriptorFile<WebBundleDescriptorImpl> getStandardDDFile() {
        if (this.standardDD == null) {
            this.standardDD = new WebDeploymentDescriptorFile();
        }
        return this.standardDD;
    }

    public List<ConfigurationDeploymentDescriptorFile> getConfigurationDDFiles() {
        if (this.confDDFiles == null) {
            this.confDDFiles = DOLUtils.getConfigurationDeploymentDescriptorFiles((ServiceLocator)this.habitat, (String)"war");
        }
        return this.confDDFiles;
    }

    public WebBundleDescriptorImpl getDefaultBundleDescriptor() {
        return new WebBundleDescriptorImpl();
    }

    public synchronized WebBundleDescriptorImpl getDefaultWebXmlBundleDescriptor() {
        if (this.defaultWebXmlBundleDescriptor == null) {
            this.defaultWebXmlBundleDescriptor = this.getPlainDefaultWebXmlBundleDescriptor();
            WebBundleValidator validator = new WebBundleValidator();
            validator.accept(this.defaultWebXmlBundleDescriptor);
        }
        return this.defaultWebXmlBundleDescriptor;
    }

    protected void postStandardDDsRead(WebBundleDescriptorImpl descriptor, ReadableArchive archive, Map<ExtensionsArchivist, RootDeploymentDescriptor> extensions) throws IOException {
        for (RootDeploymentDescriptor rd : extensions.values()) {
            if (!(rd instanceof EjbBundleDescriptor)) continue;
            EjbBundleDescriptor eb = (EjbBundleDescriptor)rd;
            descriptor.addJndiNameEnvironment((JndiNameEnvironment)eb);
            for (EjbDescriptor ejb : eb.getEjbs()) {
                ejb.notifyNewModule((WebBundleDescriptor)descriptor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WebBundleDescriptorImpl getPlainDefaultWebXmlBundleDescriptor() {
        WebBundleDescriptorImpl defaultWebBundleDesc = new WebBundleDescriptorImpl();
        InputStream fis = null;
        try {
            URL defaultWebXml = this.getDefaultWebXML();
            if (defaultWebXml != null) {
                fis = defaultWebXml.openStream();
                WebDeploymentDescriptorFile wddf = new WebDeploymentDescriptorFile();
                wddf.setXMLValidation(false);
                defaultWebBundleDesc.addWebBundleDescriptor((WebBundleDescriptor)wddf.read(fis));
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "AS-WEB-GLUE-00276");
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
        return defaultWebBundleDesc;
    }

    protected URL getDefaultWebXML() throws IOException {
        File file = new File(this.env.getConfigDirPath(), DEFAULT_WEB_XML);
        if (file.exists()) {
            return file.toURI().toURL();
        }
        return null;
    }

    protected void postOpen(WebBundleDescriptorImpl descriptor, ReadableArchive archive) throws IOException {
        super.postOpen((BundleDescriptor)descriptor, archive);
        this.postValidate((BundleDescriptor)descriptor, archive);
    }

    public void validate(ClassLoader aClassLoader) {
        ClassLoader cl = aClassLoader;
        if (cl == null) {
            cl = this.classLoader;
        }
        if (cl == null) {
            return;
        }
        ((WebBundleDescriptorImpl)this.descriptor).setClassLoader(cl);
        ((WebBundleDescriptorImpl)this.descriptor).visit(new WebBundleValidator());
    }

    protected boolean postHandles(ReadableArchive abstractArchive) throws IOException {
        return DeploymentUtils.isArchiveOfType((ReadableArchive)abstractArchive, (ArchiveType)this.getModuleType(), (ServiceLocator)this.locator);
    }

    protected String getArchiveExtension() {
        return ".war";
    }

    public Set<String> getLibraries(ReadableArchive archive) throws IOException {
        LinkedHashSet<String> libraries = new LinkedHashSet<String>();
        WebArchivist.extractLibraries((Archive)archive, true, libraries);
        ReadableArchive parentArchive = archive.getParentArchive();
        if (parentArchive != null && ((ArchiveType)parentArchive.getExtraData(ArchiveType.class)).toString().equals("ear")) {
            WebArchivist.extractLibraries((Archive)parentArchive.getSubArchive("lib"), false, libraries);
        }
        return libraries;
    }

    private static void extractLibraries(Archive archive, boolean hasWebInfPrefix, Set<String> libs) {
        Enumeration entries;
        Enumeration enumeration = entries = archive != null ? archive.entries() : null;
        if (entries == null) {
            return;
        }
        while (entries.hasMoreElements()) {
            String entryName = (String)entries.nextElement();
            if (hasWebInfPrefix && !entryName.startsWith("WEB-INF/lib") || !entryName.endsWith(".jar")) continue;
            libs.add(entryName);
        }
    }

    protected void postAnnotationProcess(WebBundleDescriptorImpl descriptor, ReadableArchive archive) throws IOException {
        super.postAnnotationProcess((BundleDescriptor)descriptor, archive);
        List<WebFragmentDescriptor> wfList = this.readStandardFragments(descriptor, archive);
        if (this.isProcessAnnotation((BundleDescriptor)descriptor)) {
            HashMap localExtensions = new HashMap();
            for (WebFragmentDescriptor wfDesc : wfList) {
                if (descriptor.isFullAttribute()) {
                    wfDesc.setFullAttribute(String.valueOf(descriptor.isFullAttribute()));
                }
                super.readAnnotations(archive, (BundleDescriptor)wfDesc, localExtensions);
            }
            ModuleScanner scanner = this.getScanner();
            if (scanner instanceof WarScanner) {
                ((WarScanner)scanner).setScanOtherLibraries(true);
                this.readAnnotations(archive, (BundleDescriptor)descriptor, localExtensions, scanner);
            }
        }
        WebFragmentDescriptor mergedWebFragment = new WebFragmentDescriptor();
        mergedWebFragment.setExists(false);
        for (WebFragmentDescriptor wf : wfList) {
            if (!mergedWebFragment.isExists() && wf.isExists()) {
                mergedWebFragment.setExists(true);
                mergedWebFragment.setDistributable(wf.isDistributable());
            }
            mergedWebFragment.addWebBundleDescriptor(wf);
        }
        if (!wfList.isEmpty()) {
            descriptor.addWebBundleDescriptor(mergedWebFragment);
            for (WebComponentDescriptor desc : descriptor.getWebComponentDescriptors()) {
                if (!(desc instanceof WebComponentDescriptorStub)) continue;
                throw new RuntimeException(String.format("There is no web component by the name of %s here.", desc.getName()));
            }
        }
        WebBundleDescriptorImpl defaultWebBundleDescriptor = this.getPlainDefaultWebXmlBundleDescriptor();
        descriptor.addDefaultWebBundleDescriptor(defaultWebBundleDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<WebFragmentDescriptor> readStandardFragments(WebBundleDescriptorImpl descriptor, ReadableArchive archive) throws IOException {
        List<WebFragmentDescriptor> wfList = new ArrayList<WebFragmentDescriptor>();
        for (String lib : this.getLibraries(archive)) {
            WebFragmentDescriptor wfDesc;
            block11: {
                WebFragmentArchivist wfArchivist = new WebFragmentArchivist(this, this.habitat);
                wfArchivist.setRuntimeXMLValidation(this.getRuntimeXMLValidation());
                wfArchivist.setRuntimeXMLValidationLevel(this.getRuntimeXMLValidationLevel());
                wfArchivist.setAnnotationProcessingRequested(false);
                wfDesc = null;
                try (ReadableArchive embeddedArchive = lib.startsWith("WEB-INF") ? archive.getSubArchive(lib) : archive.getParentArchive().getSubArchive("lib").getSubArchive(lib);){
                    if (embeddedArchive != null && wfArchivist.hasStandardDeploymentDescriptor(embeddedArchive)) {
                        try {
                            wfDesc = (WebFragmentDescriptor)wfArchivist.open(embeddedArchive);
                            break block11;
                        }
                        catch (SAXParseException ex) {
                            IOException ioex = new IOException();
                            ioex.initCause(ex);
                            throw ioex;
                        }
                    }
                    wfDesc = new WebFragmentDescriptor();
                    wfDesc.setExists(false);
                }
            }
            wfDesc.setJarName(lib.substring(lib.lastIndexOf(47) + 1));
            wfList.add(wfDesc);
            descriptor.putJarNameWebFragmentNamePair(wfDesc.getJarName(), wfDesc.getName());
        }
        if (descriptor.getAbsoluteOrderingDescriptor() != null) {
            wfList = descriptor.getAbsoluteOrderingDescriptor().order(wfList);
        } else {
            OrderingDescriptor.sort(wfList);
        }
        for (WebFragmentDescriptor wf : wfList) {
            descriptor.addOrderedLib(wf.getJarName());
        }
        return wfList;
    }
}

