/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.persistence.eclipselink.cache.coordination;

import fish.payara.nucleus.eventbus.ClusterMessage;
import fish.payara.nucleus.eventbus.EventBus;
import fish.payara.nucleus.eventbus.MessageReceiver;
import fish.payara.nucleus.events.HazelcastEvents;
import fish.payara.nucleus.executorservice.PayaraExecutorService;
import fish.payara.persistence.eclipselink.cache.coordination.HazelcastPayload;
import fish.payara.persistence.eclipselink.cache.coordination.ReceiverMapping;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Service;

@Service(name="hazelcast-topic-storage")
@RunLevel(value=10)
public class HazelcastTopicStorage
implements EventListener {
    private static HazelcastTopicStorage storage;
    private final Map<String, ReceiverMapping> messageReceiver = new ConcurrentHashMap<String, ReceiverMapping>();
    @Inject
    private EventBus eventBus;
    @Inject
    private PayaraExecutorService executorService;
    @Inject
    private Events events;

    @PostConstruct
    public void postConstruct() {
        storage = this;
        this.events.register((EventListener)this);
    }

    @PreDestroy
    public void preDestroy() {
        storage = null;
        this.events.unregister((EventListener)this);
    }

    public static HazelcastTopicStorage getInstance() {
        return storage;
    }

    public void event(EventListener.Event event) {
        if (event.is(EventTypes.SERVER_SHUTDOWN)) {
            this.clearMessageReceivers();
        } else if (event.is(HazelcastEvents.HAZELCAST_SHUTDOWN_STARTED)) {
            this.unregisterRegisteredReceivers();
        } else if (event.is(HazelcastEvents.HAZELCAST_BOOTSTRAP_COMPLETE)) {
            this.registerUnregisteredReceivers();
        }
    }

    private void registerUnregisteredReceivers() {
        this.messageReceiver.values().stream().filter(mapping -> !mapping.isRegistered()).forEach(mapping -> mapping.setRegistered(this.eventBus.addMessageReceiver(mapping.getTopic(), mapping.getMessageReceiver())));
    }

    private void unregisterRegisteredReceivers() {
        this.messageReceiver.values().stream().filter(ReceiverMapping::isRegistered).forEach(mapping -> {
            this.eventBus.removeMessageReceiver(mapping.getTopic(), mapping.getMessageReceiver());
            mapping.setRegistered(false);
        });
    }

    private void clearMessageReceivers() {
        this.messageReceiver.clear();
    }

    Future<?> process(Runnable work) {
        return this.executorService.submit(work);
    }

    String registerMessageReceiver(String topic, MessageReceiver<HazelcastPayload> receiver) {
        ReceiverMapping receiverMapping = new ReceiverMapping(topic, receiver);
        receiverMapping.setRegistered(this.eventBus.addMessageReceiver(topic, receiver));
        this.messageReceiver.put(receiverMapping.getInternalId(), receiverMapping);
        return receiverMapping.getInternalId();
    }

    void removeMessageReceiver(String internalId) {
        ReceiverMapping removedReceiver = this.messageReceiver.remove(internalId);
        if (removedReceiver != null) {
            this.eventBus.removeMessageReceiver(removedReceiver.getTopic(), removedReceiver.getMessageReceiver());
        }
    }

    void publish(String topic, HazelcastPayload payload) {
        this.eventBus.publish(topic, new ClusterMessage((Serializable)payload));
    }
}

