/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.v3.admin.cluster.NodeUtils;
import com.sun.enterprise.v3.admin.cluster.Strings;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service(name="delete-instance")
@I18n(value="delete.instance")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Server.class, opType=RestEndpoint.OpType.DELETE, path="delete-instance", description="Delete Instance", params={@RestParam(name="id", value="$parent")})})
public class DeleteInstanceCommand
implements AdminCommand {
    private static final String NL = System.lineSeparator();
    @Param(name="instance_name", primary=true)
    private String instanceName;
    @Param(defaultValue="false", optional=true)
    private boolean terse;
    @Inject
    private CommandRunner commandRunner;
    @Inject
    private ServiceLocator serviceLocator;
    @Inject
    private Servers servers;
    @Inject
    private Nodes nodes;
    private Server instance;
    private String noderef;
    private String nodedir;
    private Logger logger;
    private String instanceHost;
    private Node theNode;

    public void execute(AdminCommandContext ctx) {
        ActionReport report = ctx.getActionReport();
        this.logger = ctx.getLogger();
        Object msg = "";
        boolean fsfailure = false;
        boolean configfailure = false;
        this.instance = this.servers.getServer(this.instanceName);
        if (this.instance == null) {
            msg = Strings.get("start.instance.noSuchInstance", this.instanceName);
            this.logger.warning((String)msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage((String)msg);
            return;
        }
        this.instanceHost = this.instance.getAdminHost();
        if (this.instance.isRunning()) {
            msg = Strings.get("instance.shutdown", this.instanceName);
            this.logger.warning((String)msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage((String)msg);
            return;
        }
        this.noderef = this.instance.getNodeRef();
        if (!StringUtils.ok((String)this.noderef)) {
            msg = Strings.get("missingNodeRef", this.instanceName);
            fsfailure = true;
        } else {
            this.theNode = this.nodes.getNode(this.noderef);
            if (this.theNode == null) {
                msg = Strings.get("noSuchNode", this.noderef);
                fsfailure = true;
            }
        }
        if (!fsfailure) {
            this.nodedir = this.theNode.getNodeDirAbsolute();
            if (this.theNode.getType().equals("DOCKER")) {
                this.deleteDockerContainer(ctx);
            } else if (!this.theNode.getType().equals("TEMP")) {
                this.deleteInstanceFilesystem(ctx);
            }
            report = ctx.getActionReport();
            if (report.getActionExitCode() != ActionReport.ExitCode.SUCCESS) {
                fsfailure = true;
            }
            msg = report.getMessage();
        }
        CommandRunner.CommandInvocation commandInvocation = this.commandRunner.getCommandInvocation("_unregister-instance", report, ctx.getSubject());
        ParameterMap commandParameters = new ParameterMap();
        commandParameters.add((Object)"DEFAULT", (Object)this.instanceName);
        commandInvocation.parameters(commandParameters);
        commandInvocation.execute();
        if (report.getActionExitCode() != ActionReport.ExitCode.SUCCESS && report.getActionExitCode() != ActionReport.ExitCode.WARNING) {
            configfailure = true;
            msg = fsfailure ? (String)msg + NL + report.getMessage() : report.getMessage();
        }
        if (configfailure && fsfailure) {
            msg = (String)msg + NL + NL + Strings.get("delete.instance.failed", this.instanceName, this.instanceHost);
        } else if (configfailure && !fsfailure) {
            msg = (String)msg + NL + NL + Strings.get("delete.instance.config.failed", this.instanceName, this.instanceHost);
        } else if (!configfailure && fsfailure) {
            report.setActionExitCode(ActionReport.ExitCode.WARNING);
        }
        if (configfailure) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage((String)msg);
        } else if (this.theNode.getType().equals("TEMP") && !this.theNode.nodeInUse()) {
            this.deleteTempNode(ctx);
        }
    }

    private void deleteInstanceFilesystem(AdminCommandContext ctx) {
        NodeUtils nodeUtils = new NodeUtils(this.serviceLocator, this.logger);
        ArrayList<String> command = new ArrayList<String>();
        command.add("_delete-instance-filesystem");
        if (this.nodedir != null) {
            command.add("--nodedir");
            command.add(this.nodedir);
        }
        command.add("--node");
        command.add(this.noderef);
        command.add(this.instanceName);
        String humanCommand = this.makeCommandHuman(command);
        String firstErrorMessage = Strings.get("delete.instance.filesystem.failed", this.instanceName, this.noderef, this.theNode.getNodeHost());
        StringBuilder output = new StringBuilder();
        nodeUtils.runAdminCommandOnNode(this.theNode, command, ctx, firstErrorMessage, humanCommand, output);
        ActionReport report = ctx.getActionReport();
        if (report.getActionExitCode() != ActionReport.ExitCode.SUCCESS) {
            return;
        }
        String msg = Strings.get("delete.instance.success", this.instanceName, this.theNode.getNodeHost());
        if (!this.terse) {
            msg = StringUtils.cat((String)NL, (String[])new String[]{output.toString().trim(), msg});
        }
        report.setMessage(msg);
    }

    private void deleteDockerContainer(AdminCommandContext ctx) {
        ActionReport actionReport = ctx.getActionReport();
        CommandRunner.CommandInvocation commandInvocation = this.commandRunner.getCommandInvocation("_delete-docker-container", actionReport, ctx.getSubject());
        ParameterMap commandParameters = new ParameterMap();
        commandParameters.add((Object)"node", (Object)this.noderef);
        commandParameters.add((Object)"DEFAULT", (Object)this.instanceName);
        commandInvocation.parameters(commandParameters);
        commandInvocation.execute();
        if (actionReport.getActionExitCode() != ActionReport.ExitCode.SUCCESS) {
            actionReport.setMessage(Strings.get("delete.docker.container.failure", this.instanceName, this.noderef, this.theNode.getNodeHost()));
            return;
        }
        actionReport.setMessage(Strings.get("delete.docker.container.success", this.instanceName, this.noderef, this.theNode.getNodeHost()));
    }

    private void deleteTempNode(AdminCommandContext ctx) {
        ActionReport actionReport = ctx.getActionReport().addSubActionsReport();
        if (this.theNode.nodeInUse()) {
            this.logger.log(Level.FINE, "Temporary node " + this.theNode.getName() + " still detected as having instances registered to it, skipping deletion.");
        } else {
            CommandRunner.CommandInvocation commandInvocation = this.commandRunner.getCommandInvocation("_delete-node-temp", actionReport, ctx.getSubject());
            ParameterMap commandParameters = new ParameterMap();
            commandParameters.add((Object)"DEFAULT", (Object)this.theNode.getName());
            commandInvocation.parameters(commandParameters);
            commandInvocation.execute();
        }
    }

    private String makeCommandHuman(List<String> commands) {
        StringBuilder fullCommand = new StringBuilder();
        fullCommand.append("lib");
        fullCommand.append(System.getProperty("file.separator"));
        fullCommand.append("nadmin ");
        for (String command : commands) {
            if (command.equals("_delete-instance-filesystem")) {
                fullCommand.append(" ");
                fullCommand.append("delete-local-instance");
                continue;
            }
            fullCommand.append(" ");
            fullCommand.append(command);
        }
        return fullCommand.toString();
    }
}

