/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.admin.cluster;

import com.sun.enterprise.config.serverbeans.Domain;
import fish.payara.enterprise.config.serverbeans.DeploymentGroup;
import fish.payara.enterprise.config.serverbeans.DeploymentGroups;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="list-deployment-groups")
@I18n(value="list.deployment.group.command")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@RestEndpoints(value={@RestEndpoint(configBean=DeploymentGroups.class, opType=RestEndpoint.OpType.GET, path="list-deployment-groups", description="Command to list Deployment Groups")})
public class ListDeploymentGroupsCommand
implements AdminCommand {
    @Inject
    Domain domain;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        DeploymentGroups deploymentGroups = this.domain.getDeploymentGroups();
        List listOfDeploymentGroup = deploymentGroups.getDeploymentGroup();
        ArrayList<String> deploymentGroupNames = new ArrayList<String>();
        if (listOfDeploymentGroup.isEmpty()) {
            report.appendMessage("No Deployment Group has been created");
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("List of Deployment Groups:\n");
            for (DeploymentGroup deploymentGroup : listOfDeploymentGroup) {
                sb.append("\t" + deploymentGroup.getName() + "\n");
                deploymentGroupNames.add(deploymentGroup.getName());
            }
            report.setMessage(sb.toString());
        }
        Properties extrasProps = new Properties();
        extrasProps.put("listOfDeploymentGroups", deploymentGroupNames);
        report.setExtraProperties(extrasProps);
    }
}

