/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.loader;

import com.sun.enterprise.loader.CachingReflectionUtil;
import com.sun.enterprise.loader.CurrentBeforeParentClassLoader;
import com.sun.enterprise.util.CULoggerInfo;
import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CacheCleaner {
    private static final Logger logger = CULoggerInfo.getLogger();

    public static void clearCaches(ClassLoader classLoader) {
        CacheCleaner.clearOmniFacesCache(classLoader);
        CacheCleaner.clearJNACache(classLoader);
        while (classLoader != null) {
            CacheCleaner.clearJaxRSCache(classLoader);
            classLoader = classLoader.getParent();
        }
    }

    private static void clearJaxRSCache(ClassLoader classLoader) {
        try {
            Class<?> cdiComponentProvider = CachingReflectionUtil.getClassFromCache("org.glassfish.jersey.ext.cdi1x.internal.CdiComponentProvider", classLoader);
            if (cdiComponentProvider != null) {
                Field runtimeSpecificsField = CachingReflectionUtil.getFieldFromCache(cdiComponentProvider, "runtimeSpecifics", true);
                Object runtimeSpecifics = runtimeSpecificsField.get(null);
                CachingReflectionUtil.getMethodFromCache(runtimeSpecifics.getClass(), "clearJaxRsResource", true, ClassLoader.class).invoke(runtimeSpecifics, classLoader);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error clearing Jax-Rs cache", e);
        }
    }

    private static void clearOmniFacesCache(ClassLoader classLoader) {
        try {
            Class<?> eagerBeans = CachingReflectionUtil.getClassFromCache("org.omnifaces.cdi.eager.EagerBeansRepository", classLoader);
            if (eagerBeans != null && eagerBeans.getClassLoader() instanceof CurrentBeforeParentClassLoader) {
                Field instance = CachingReflectionUtil.getFieldFromCache(eagerBeans, "instance", true);
                instance.set(null, null);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error clearing OmniFaces cache", e);
        }
    }

    private static void clearJNACache(ClassLoader classLoader) {
        try {
            Class<?> cleanerClass = CachingReflectionUtil.getClassFromCache("com.sun.jna.internal.Cleaner", classLoader);
            if (cleanerClass != null && cleanerClass.getClassLoader() instanceof CurrentBeforeParentClassLoader) {
                Field instanceField = CachingReflectionUtil.getFieldFromCache(cleanerClass, "INSTANCE", true);
                Object instance = instanceField.get(null);
                CachingReflectionUtil.getFieldFromCache(instance.getClass(), "cleanerThread", true).set(instance, null);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error clearing JNA cache", e);
        }
    }
}

