/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.store;

import com.sun.enterprise.security.store.AsadminTruststore;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.CULoggerInfo;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.UserInterruptException;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class AsadminSecurityUtil {
    private static final File DEFAULT_CLIENT_DIR;
    private static AsadminSecurityUtil instance;
    private static final Logger logger;
    private AsadminTruststore asadminTruststore = null;
    private KeyStore asadminKeystore = null;
    private static final LocalStringsImpl strmgr;

    public static synchronized AsadminSecurityUtil getInstance(char[] commandLineMasterPassword, boolean isPromptable) {
        if (instance == null) {
            instance = new AsadminSecurityUtil(commandLineMasterPassword, isPromptable);
        }
        return instance;
    }

    public static synchronized AsadminSecurityUtil getInstance(boolean isPromptable) {
        return AsadminSecurityUtil.getInstance(null, isPromptable);
    }

    public static char[] getAsadminTruststorePassword() {
        return System.getProperty("javax.net.ssl.trustStorePassword", "changeit").toCharArray();
    }

    public static File getDefaultClientDir() {
        if (!DEFAULT_CLIENT_DIR.isDirectory() && !DEFAULT_CLIENT_DIR.mkdirs()) {
            logger.log(Level.SEVERE, "NCLS-COMUTIL-00024", DEFAULT_CLIENT_DIR);
        }
        return DEFAULT_CLIENT_DIR;
    }

    private AsadminSecurityUtil(char[] commandLineMasterPassword, boolean isPromptable) {
        try {
            this.init(commandLineMasterPassword, isPromptable);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private char[] promptForPassword() {
        LineReader lineReader = null;
        try {
            char mask = '\u0000';
            Terminal terminal = TerminalBuilder.builder().system(true).build();
            lineReader = LineReaderBuilder.builder().terminal(terminal).build();
            String line = lineReader.readLine(strmgr.get("certificateDbPrompt"), Character.valueOf(mask));
            char[] cArray = line.toCharArray();
            return cArray;
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, "Error reading input", ioe);
        }
        catch (EndOfFileException | UserInterruptException ioe) {
        }
        finally {
            if (lineReader != null && lineReader.getTerminal() != null) {
                try {
                    lineReader.getTerminal().close();
                }
                catch (IOException ioe) {
                    logger.log(Level.WARNING, "Error closing terminal", ioe);
                }
            }
        }
        return null;
    }

    public AsadminTruststore getAsadminTruststore() {
        return this.asadminTruststore;
    }

    public KeyStore getAsadminKeystore() {
        return this.asadminKeystore;
    }

    private void init(char[] commandLineMasterPassword, boolean isPromptable) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        char[] passwordToUse = this.chooseMasterPassword(commandLineMasterPassword);
        try {
            this.asadminKeystore = this.openKeystore(passwordToUse);
            if (this.asadminKeystore == null) {
                logger.finer("Skipped loading keystore - location null");
            } else {
                logger.finer("Loaded keystore using command or default master password");
            }
        }
        catch (IOException ex) {
            if (ex.getCause() instanceof UnrecoverableKeyException) {
                if (!isPromptable) {
                    throw ex;
                }
                passwordToUse = this.promptForPassword();
                if (passwordToUse == null) {
                    throw new IllegalArgumentException();
                }
                this.asadminKeystore = this.openKeystore(passwordToUse);
                logger.finer("Loaded keystore using prompted master password");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            this.asadminTruststore = this.openTruststore(passwordToUse);
        }
        catch (IOException e) {
            if (System.getProperty("javax.net.ssl.trustStore") == null) {
                logger.log(Level.WARNING, String.format("Error when reading truststore, exception:%s. Now recreating file", e));
                this.recreateDefaultTrustStore(passwordToUse);
            }
            throw e;
        }
    }

    protected void recreateDefaultTrustStore(char[] passwordToUse) throws IOException {
        File trustStoreFile = new File(AsadminSecurityUtil.getDefaultClientDir(), "truststore");
        logger.log(Level.INFO, String.format("Recreating default truststore file: %s", trustStoreFile.getPath()));
        try {
            Files.deleteIfExists(trustStoreFile.toPath());
            this.asadminTruststore = this.openTruststore(passwordToUse);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            logger.log(Level.WARNING, String.format("Error when processing truststore with path:%s and exception:%s", trustStoreFile.getPath(), e));
            throw new RuntimeException(e);
        }
    }

    private AsadminTruststore openTruststore(char[] password) throws CertificateException, KeyStoreException, NoSuchAlgorithmException, IOException {
        return new AsadminTruststore(password);
    }

    private KeyStore openKeystore(char[] candidateMasterPassword) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore permanentKS = KeyStore.getInstance("JKS");
        try (InputStream keyStoreStream = this.asadminKeyStoreStream();){
            if (keyStoreStream == null) {
                KeyStore keyStore = null;
                return keyStore;
            }
            permanentKS.load(keyStoreStream, candidateMasterPassword);
            KeyStore keyStore = permanentKS;
            return keyStore;
        }
    }

    private char[] chooseMasterPassword(char[] commandMasterPassword) {
        return commandMasterPassword == null ? this.defaultMasterPassword() : commandMasterPassword;
    }

    private InputStream asadminKeyStoreStream() throws FileNotFoundException {
        String location = System.getProperty("javax.net.ssl.keyStore");
        if (location == null) {
            return null;
        }
        return new BufferedInputStream(new FileInputStream(location));
    }

    private char[] defaultMasterPassword() {
        return System.getProperty("javax.net.ssl.trustStorePassword", "changeit").toCharArray();
    }

    static {
        instance = null;
        logger = CULoggerInfo.getLogger();
        String AS_GFCLIENT = System.getenv("AS_GFCLIENT");
        logger.log(Level.FINER, "AS_GFCLIENT: {0}", AS_GFCLIENT);
        DEFAULT_CLIENT_DIR = AS_GFCLIENT != null ? new File(AS_GFCLIENT) : new File(System.getProperty("user.home"), ".gfclient");
        logger.log(Level.FINER, "Set .gfclient directory to: {0}", DEFAULT_CLIENT_DIR);
        strmgr = new LocalStringsImpl(AsadminSecurityUtil.class);
    }
}

