/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.universal.process;

import com.sun.enterprise.universal.process.ProcessManagerException;
import com.sun.enterprise.universal.process.ProcessManagerTimeoutException;
import com.sun.enterprise.universal.process.Strings;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ProcessManager {
    private String[] cmdline;
    private String[] env = null;
    private final StringBuffer sb_out;
    private final StringBuffer sb_err;
    private int exit = -1;
    private int timeout;
    private Process process;
    private boolean echo = true;
    private static final boolean debugOn = false;
    private String[] stdinLines;
    private List<Thread> threads = new ArrayList<Thread>(2);
    private boolean waitForReaderThreads = true;

    public ProcessManager(String ... cmds) {
        this.cmdline = cmds;
        this.sb_out = new StringBuffer();
        this.sb_err = new StringBuffer();
    }

    public ProcessManager(List<String> Cmdline) {
        this.cmdline = new String[Cmdline.size()];
        this.cmdline = Cmdline.toArray(this.cmdline);
        this.sb_out = new StringBuffer();
        this.sb_err = new StringBuffer();
    }

    public final void setTimeoutMsec(int num) {
        if (num > 0) {
            this.timeout = num;
        }
    }

    public final void setEnvironment(String[] env) {
        this.env = env;
    }

    public final void setStdinLines(List<String> list) {
        if (list != null && !list.isEmpty()) {
            this.stdinLines = list.toArray(new String[0]);
        }
    }

    public final void waitForReaderThreads(boolean b) {
        this.waitForReaderThreads = b;
    }

    public final void setEcho(boolean newEcho) {
        this.echo = newEcho;
    }

    public final int execute() throws ProcessManagerException {
        try {
            Runtime rt = Runtime.getRuntime();
            this.process = rt.exec(this.cmdline, this.env);
            this.readStream("stderr", this.process.getErrorStream(), this.sb_err);
            this.readStream("stdout", this.process.getInputStream(), this.sb_out);
            this.writeStdin();
            this.await();
            try {
                this.exit = this.process.exitValue();
            }
            catch (IllegalThreadStateException tse) {
                this.process.destroy();
                throw new ProcessManagerTimeoutException(tse);
            }
        }
        catch (ProcessManagerException pme) {
            throw pme;
        }
        catch (Exception e) {
            if (this.process != null) {
                this.process.destroy();
            }
            throw new ProcessManagerException(e);
        }
        finally {
            this.doWaitForReaderThreads();
        }
        return this.exit;
    }

    public final String getStdout() {
        return this.sb_out.toString();
    }

    public final String getStderr() {
        return this.sb_err.toString();
    }

    public final int getExitValue() {
        return this.exit;
    }

    public String toString() {
        return Arrays.toString(this.cmdline);
    }

    private void writeStdin() throws ProcessManagerException {
        if (this.stdinLines == null || this.stdinLines.length <= 0) {
            return;
        }
        if (this.process == null) {
            throw new ProcessManagerException(Strings.get("null.process"));
        }
        try (PrintWriter pipe = new PrintWriter(new BufferedWriter(new OutputStreamWriter(this.process.getOutputStream(), StandardCharsets.UTF_8)));){
            for (String stdinLine : this.stdinLines) {
                ProcessManager.debug("InputLine ->" + stdinLine + "<-");
                pipe.println(stdinLine);
            }
            pipe.flush();
        }
        catch (Exception e) {
            throw new ProcessManagerException(e);
        }
    }

    private void readStream(String name, InputStream stream, StringBuffer sb) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
        Thread thread = new Thread((Runnable)new ReaderThread(reader, sb, this.echo), name);
        this.threads.add(thread);
        thread.start();
    }

    private void await() throws InterruptedException, ProcessManagerException {
        if (this.timeout <= 0) {
            this.waitForever();
        } else {
            this.waitAwhile();
        }
    }

    private void waitForever() throws InterruptedException, ProcessManagerException {
        if (this.process == null) {
            throw new ProcessManagerException(Strings.get("null.process"));
        }
        this.process.waitFor();
    }

    private void waitAwhile() throws InterruptedException {
        Thread processWaiter = new Thread(new TimeoutThread(this.process));
        processWaiter.start();
        processWaiter.join(this.timeout);
    }

    private void doWaitForReaderThreads() {
        if (this.waitForReaderThreads) {
            for (Thread t : this.threads) {
                try {
                    t.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private static void debug(String s) {
    }

    public static void main(String[] args) {
        try {
            if (args.length <= 0) {
                System.out.println("Usage: ProcessManager cmd arg1 arg2 ... argn");
                System.exit(1);
            }
            ArrayList<String> cmds = new ArrayList<String>(Arrays.asList(args));
            ProcessManager pm = new ProcessManager(cmds);
            pm.execute();
            System.out.println("*********** STDOUT ***********\n" + pm.getStdout());
            System.out.println("*********** STDERR ***********\n" + pm.getStderr());
            System.out.println("*********** EXIT VALUE: " + pm.getExitValue());
        }
        catch (ProcessManagerException pme) {
            pme.printStackTrace();
        }
    }

    static class TimeoutThread
    implements Runnable {
        private Process process;

        TimeoutThread(Process p) {
            this.process = p;
        }

        @Override
        public void run() {
            try {
                this.process.waitFor();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ProcessManager.debug("TimeoutThread exiting...");
        }
    }

    static class ReaderThread
    implements Runnable {
        private final BufferedReader reader;
        private final StringBuffer sb;
        private final boolean echo;

        ReaderThread(BufferedReader Reader2, StringBuffer SB, boolean echo) {
            this.reader = Reader2;
            this.sb = SB;
            this.echo = echo;
        }

        @Override
        public void run() {
            try {
                String line = this.reader.readLine();
                while (line != null) {
                    this.sb.append(line).append('\n');
                    if (this.echo) {
                        System.out.println(line);
                    }
                    line = this.reader.readLine();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ProcessManager.debug("ReaderThread exiting...");
        }
    }
}

