/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class FlusherThread
extends Thread {
    InputStream mInStream;
    OutputStream mOutStream;

    FlusherThread(InputStream in, OutputStream out) {
        this.mInStream = in;
        this.mOutStream = out;
    }

    @Override
    public void run() {
        if (this.mInStream == null) {
            return;
        }
        try (OutputStream outputStream = this.mOutStream;){
            int byteCnt;
            byte[] buffer = new byte[4096];
            while ((byteCnt = this.mInStream.read(buffer)) != -1) {
                if (outputStream != null && byteCnt > 0) {
                    outputStream.write(buffer, 0, byteCnt);
                    outputStream.flush();
                }
                Thread.yield();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

