/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.enterprise.util.i18n.StringManager;
import com.sun.jts.CosTransactions.LogException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.RandomAccessFile;
import org.glassfish.hk2.utilities.CleanerFactory;

class LogFileHandle {
    private static final StringManager sm = StringManager.getManager(LogFileHandle.class);
    static final int OPEN_RDONLY = 1;
    static final int OPEN_RDWR = 2;
    static final int OPEN_CREAT = 4;
    static final int OPEN_SYNC = 8;
    static final int SEEK_RELATIVE = 0;
    static final int SEEK_ABSOLUTE = 1;
    static final String MODE_READONLY = "r";
    static String MODE_READWRITEOLD = "rw";
    static String MODE_READWRITENEW = "rw";
    static String dsyncProp = null;
    static final String DSYNC_PROPERTY = "com.sun.appserv.transaction.nofdsync";
    static final int LOG_FNAME_MAX = 252;
    static final int FILESYSTEM_BLOCKSIZE = 4096;
    private RandomAccessFile fhandle;
    private FileDescriptor fd;
    private byte[] bufferData;
    boolean buffered;
    int bufferUpdateStart;
    int bufferUpdateEnd;
    int buffPos;

    LogFileHandle() {
        this.fhandle = null;
        this.fd = null;
        this.bufferData = null;
        this.buffered = false;
        this.bufferUpdateStart = -1;
        this.bufferUpdateEnd = -1;
        this.buffPos = 0;
        this.fhandle = null;
        this.fd = null;
        this.registerDestroyEvent();
    }

    LogFileHandle(File file, int openOptions) throws LogException {
        block5: {
            this.fhandle = null;
            this.fd = null;
            this.bufferData = null;
            this.buffered = false;
            this.bufferUpdateStart = -1;
            this.bufferUpdateEnd = -1;
            this.buffPos = 0;
            if (dsyncProp == null && (openOptions & 8) == 0) {
                this.buffered = true;
            }
            if ((openOptions & 1) != 0) {
                this.fileOpen(file, MODE_READONLY);
            } else {
                try {
                    this.fileOpen(file, MODE_READWRITEOLD);
                }
                catch (LogException e) {
                    if ((openOptions & 4) == 0) break block5;
                    this.fileOpen(file, MODE_READWRITENEW);
                }
            }
        }
        this.registerDestroyEvent();
    }

    void destroy() throws LogException {
        if (this.fhandle != null) {
            this.fileClose();
        }
    }

    public final void registerDestroyEvent() {
        CleanerFactory.create().register(this, () -> {
            try {
                this.destroy();
            }
            catch (LogException logException) {
                // empty catch block
            }
        });
    }

    int fileRead(byte[] buffer) throws LogException {
        int bytesRead = 0;
        if (buffer.length > 0) {
            try {
                if (this.buffered) {
                    if (this.buffPos >= this.bufferData.length) {
                        bytesRead = -1;
                    } else {
                        bytesRead = this.buffPos + buffer.length >= this.bufferData.length ? this.bufferData.length - this.buffPos : buffer.length;
                        System.arraycopy(this.bufferData, this.buffPos, buffer, 0, bytesRead);
                        this.buffPos += bytesRead;
                    }
                } else {
                    bytesRead = this.fhandle.read(buffer);
                    if (bytesRead == -1) {
                        bytesRead = 0;
                    }
                }
            }
            catch (Throwable exc) {
                throw new LogException(3, 1, sm.getString("jts.log_read_failed_bytes", (Object)bytesRead), exc);
            }
        }
        return bytesRead;
    }

    int fileWrite(byte[] buffer) throws LogException {
        if (buffer.length > 0) {
            try {
                if (this.buffered) {
                    if (this.buffPos + buffer.length >= this.bufferData.length) {
                        byte[] newBufferData = new byte[this.buffPos + buffer.length];
                        if (this.bufferData.length > 0) {
                            System.arraycopy(this.bufferData, 0, newBufferData, 0, this.bufferData.length);
                        }
                        this.bufferData = newBufferData;
                    }
                    System.arraycopy(buffer, 0, this.bufferData, this.buffPos, buffer.length);
                    if (this.bufferUpdateStart == -1 || this.buffPos < this.bufferUpdateStart) {
                        this.bufferUpdateStart = this.buffPos;
                    }
                    this.buffPos += buffer.length;
                    if (this.buffPos > this.bufferUpdateEnd) {
                        this.bufferUpdateEnd = this.buffPos;
                    }
                } else {
                    this.fhandle.write(buffer);
                    if (dsyncProp == null) {
                        this.fd.sync();
                    }
                }
            }
            catch (Throwable e) {
                int errCode = 7;
                throw new LogException(errCode, 1, sm.getString("jts.log_write_failed"), e);
            }
        }
        return buffer.length;
    }

    void fileOpen(File file, String fileMode) throws LogException {
        this.fhandle = null;
        try {
            this.fhandle = new RandomAccessFile(file, fileMode);
            this.fd = this.fhandle.getFD();
            if (this.buffered) {
                if (this.fhandle.length() > 0L) {
                    this.bufferData = new byte[(int)this.fhandle.length()];
                    this.fhandle.readFully(this.bufferData);
                } else {
                    this.bufferData = new byte[0];
                }
            }
        }
        catch (Throwable e) {
            throw new LogException(2, 1, sm.getString("jts.log_open_failed", (Object)file), e);
        }
    }

    void fileClose() throws LogException {
        try {
            if (this.bufferUpdateStart != -1) {
                this.fileSync();
            }
            this.fhandle.close();
        }
        catch (Throwable e) {
            throw new LogException(8, 1, sm.getString("jts.log_close_failed"), e);
        }
        this.fhandle = null;
        this.fd = null;
    }

    void fileSeek(long position, int seekMode) throws LogException {
        long absPos = position;
        try {
            if (this.buffered) {
                if (seekMode == 0) {
                    absPos = (long)this.buffPos + position;
                }
                this.buffPos = (int)absPos;
            } else {
                if (seekMode == 0) {
                    absPos = this.fhandle.getFilePointer() + position;
                }
                this.fhandle.seek(absPos);
            }
        }
        catch (Throwable e) {
            throw new LogException(3, 1, sm.getString("jts.log_file_seek_failed"), e);
        }
    }

    void fileSync() throws LogException {
        if (this.bufferUpdateStart != -1) {
            try {
                this.fhandle.seek(this.bufferUpdateStart);
                this.fhandle.write(this.bufferData, this.bufferUpdateStart, this.bufferUpdateEnd - this.bufferUpdateStart);
                if (dsyncProp == null) {
                    this.fd.sync();
                }
                this.bufferUpdateStart = -1;
                this.bufferUpdateEnd = -1;
            }
            catch (Throwable e) {
                throw new LogException(3, 1, sm.getString("jts.log_file_sync_failed"), e);
            }
        }
    }

    int readVector(byte[][] vector) throws LogException {
        int bytesRead = 0;
        for (int i = 0; i < vector.length; ++i) {
            bytesRead += this.fileRead(vector[i]);
        }
        return bytesRead;
    }

    void allocFileStorage(int bytesToClear) throws LogException {
        byte[] singleChar2 = new byte[1];
        if (bytesToClear == 0) {
            return;
        }
        this.fileSeek(bytesToClear - 1, 0);
        this.fileWrite(singleChar2);
        this.fileSeek(-bytesToClear, 0);
        if (this.buffered) {
            this.fileSync();
        }
    }

    static {
        dsyncProp = System.getProperty(DSYNC_PROPERTY);
        if (dsyncProp != null) {
            MODE_READWRITEOLD = "rwd";
            MODE_READWRITENEW = "rwd";
        }
    }
}

