/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import java.beans.PropertyVetoException;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.connectors.config.AdminObjectResource;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.resourcebase.resources.admin.cli.ResourceUtil;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@TargetType(value={CommandTarget.DAS, CommandTarget.CONFIG, CommandTarget.CLUSTER, CommandTarget.STANDALONE_INSTANCE, CommandTarget.DEPLOYMENT_GROUP})
@ExecuteOn(value={RuntimeType.ALL})
@Service(name="delete-admin-object")
@PerLookup
@I18n(value="delete.admin.ojbect")
public class DeleteAdminObject
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteAdminObject.class);
    @Param(optional=true)
    private String target = "server";
    @Param(name="jndi_name", primary=true)
    private String jndiName;
    @Inject
    private ResourceUtil resourceUtil;
    @Inject
    private Domain domain;
    @Inject
    private ServerEnvironment environment;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (this.jndiName == null) {
            report.setMessage(localStrings.getLocalString("delete.admin.object.noJndiName", "No JNDI name defined for administered object."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (!this.isResourceExists(this.domain.getResources(), this.jndiName)) {
            report.setMessage(localStrings.getLocalString("delete.admin.object.notfound", "An administered object named {0} does not exist.", new Object[]{this.jndiName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (this.environment.isDas()) {
            if (this.domain.getConfigNamed(this.target) != null) {
                if (this.resourceUtil.getTargetsReferringResourceRef(this.jndiName).size() > 0) {
                    report.setMessage(localStrings.getLocalString("delete.admin.object.resource-ref.exist", "admin-object [ {0} ] is referenced in aninstance/cluster target, Use delete-resource-ref on appropriate target", new Object[]{this.jndiName}));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
            } else {
                if (!this.resourceUtil.isResourceRefInTarget(this.jndiName, this.target)) {
                    report.setMessage(localStrings.getLocalString("delete.admin.object.no.resource-ref", "admin-object [ {0} ] is not referenced in target [ {1} ]", new Object[]{this.jndiName, this.target}));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
                if (this.resourceUtil.getTargetsReferringResourceRef(this.jndiName).size() > 1) {
                    report.setMessage(localStrings.getLocalString("delete.admin.object.multiple.resource-refs", "admin-object [ {0} ] is referenced in multiple instance/cluster targets, Use delete-resource-ref on appropriate target", new Object[]{this.jndiName}));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
            }
        }
        try {
            this.resourceUtil.deleteResourceRef(this.jndiName, this.target);
            if (ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    Resource resource = ConnectorsUtil.getResourceByName((Resources)DeleteAdminObject.this.domain.getResources(), AdminObjectResource.class, (String)DeleteAdminObject.this.jndiName);
                    return param.getResources().remove(resource);
                }
            }, (ConfigBeanProxy)this.domain.getResources()) == null) {
                report.setMessage(localStrings.getLocalString("delete.admin.object.fail", "Unable to delete administered object {0}", new Object[]{this.jndiName}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        catch (TransactionFailure tfe) {
            report.setMessage(localStrings.getLocalString("delete.admin.object.fail", "Unable to delete administered object {0}", new Object[]{this.jndiName}) + " " + tfe.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)tfe);
        }
        report.setMessage(localStrings.getLocalString("delete.admin.object.success", "Administered object {0} deleted", new Object[]{this.jndiName}));
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private boolean isResourceExists(Resources resources, String jndiName) {
        return ConnectorsUtil.getResourceByName((Resources)resources, AdminObjectResource.class, (String)jndiName) != null;
    }
}

