/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.notification.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.util.ColumnFormatter;
import fish.payara.internal.notification.NotifierUtils;
import fish.payara.internal.notification.PayaraConfiguredNotifier;
import fish.payara.internal.notification.PayaraNotifier;
import fish.payara.internal.notification.PayaraNotifierConfiguration;
import fish.payara.internal.notification.admin.NotificationServiceConfiguration;
import fish.payara.nucleus.notification.log.LogNotifierConfiguration;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;

@Service(name="get-notification-configuration")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="get.notification.configuration")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.CONFIG, CommandTarget.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=NotificationServiceConfiguration.class, opType=RestEndpoint.OpType.GET, path="get-notification-configuration", description="List New Notification Configuration")})
public class GetNotificationConfigurationCommand
implements AdminCommand {
    @Inject
    private Target targetUtil;
    @Inject
    ServiceLocator habitat;
    @Param(name="target", optional=true, defaultValue="server")
    String target;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Config targetConfig = this.targetUtil.getConfig(this.target);
        if (targetConfig == null) {
            report.setMessage("No such config named: " + this.target);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        NotificationServiceConfiguration configuration = (NotificationServiceConfiguration)targetConfig.getExtensionByType(NotificationServiceConfiguration.class);
        String notificationServiceEnabled = configuration.getEnabled();
        List notifierHandles = this.habitat.getAllServiceHandles(PayaraNotifier.class, new Annotation[0]);
        if (notifierHandles.isEmpty()) {
            report.setMessage("No notifiers defined");
            report.setActionExitCode(ActionReport.ExitCode.WARNING);
            return;
        }
        String[] headers = new String[]{"Notifier Name", "Enabled", "Notifier Enabled", "Filter Level"};
        ColumnFormatter columnFormatter = new ColumnFormatter(headers);
        Properties extraProps = new Properties();
        for (ServiceHandle serviceHandle : notifierHandles) {
            Class notifierClass = serviceHandle.getActiveDescriptor().getImplementationClass();
            Object[] values = new Object[4];
            values[0] = NotifierUtils.getNotifierName(serviceHandle.getActiveDescriptor());
            values[1] = notificationServiceEnabled;
            PayaraNotifierConfiguration notifierConfig = null;
            if (serviceHandle.getService() instanceof PayaraConfiguredNotifier) {
                notifierConfig = (PayaraNotifierConfiguration)configuration.getNotifierConfigurationByType(NotifierUtils.getConfigurationClass(notifierClass));
            }
            if (notifierConfig == null) {
                values[2] = "false";
                values[3] = "WARNING";
            } else {
                values[2] = notifierConfig.getEnabled();
                values[3] = notifierConfig.getFilter();
            }
            columnFormatter.addRow(values);
            HashMap<String, Object> map = new HashMap<String, Object>(3);
            map.put("enabled", values[1]);
            map.put("notifierEnabled", values[2]);
            map.put("filter", values[3]);
            if (notifierConfig instanceof LogNotifierConfiguration) {
                map.put("useSeparateLogFile", ((LogNotifierConfiguration)notifierConfig).getUseSeparateLogFile());
            }
            extraProps.put("getNotificationConfiguration" + notifierClass.getSimpleName(), map);
        }
        report.setMessage(columnFormatter.toString());
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        report.setExtraProperties(extraProps);
    }
}

