/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.notification.admin;

import fish.payara.internal.notification.EventLevel;
import fish.payara.internal.notification.PayaraNotification;
import fish.payara.internal.notification.PayaraNotificationBuilder;
import fish.payara.internal.notification.PayaraNotificationFactory;
import fish.payara.internal.notification.admin.NotificationServiceConfiguration;
import jakarta.inject.Inject;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.messaging.Topic;
import org.jvnet.hk2.annotations.Service;

@Service(name="test-notifier-configuration")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=NotificationServiceConfiguration.class, opType=RestEndpoint.OpType.GET, path="test-notifier-configuration", description="Tests Notifier Configuration")})
public class TestNotifier
implements AdminCommand {
    private static final String EVENT_TYPE = "TEST";
    private static final String SUBJECT = "Test Notification";
    private static final String MESSAGE = "This is a test notification";
    @Param(name="all", shortName="a", optional=true)
    private Boolean all;
    @Param(name="notifiers", shortName="n", optional=true)
    private List<String> notifiers;
    @Inject
    private Topic<PayaraNotification> topic;
    @Inject
    private PayaraNotificationFactory factory;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        PayaraNotificationBuilder builder = this.factory.newBuilder().eventType(EVENT_TYPE).subject(SUBJECT).message(MESSAGE).level(EventLevel.SEVERE);
        if (this.all == null || !this.all.booleanValue()) {
            if (this.notifiers == null || this.notifiers.isEmpty()) {
                report.setMessage("Must either specify all notifiers or a select list");
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            builder = builder.whitelist(this.notifiers.toArray(new String[0]));
        }
        PayaraNotification event = builder.build();
        try {
            this.topic.publish((Object)event);
            report.setMessage("SUCCESS");
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (Exception ex) {
            report.setMessage(ex.getMessage());
            report.setFailureCause((Throwable)ex);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }
}

