/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.healthcheck;

import jakarta.enterprise.util.AnnotationLiteral;
import java.lang.annotation.Annotation;
import java.util.Set;
import org.eclipse.microprofile.health.Liveness;
import org.eclipse.microprofile.health.Readiness;
import org.eclipse.microprofile.health.Startup;

public enum HealthCheckType {
    READINESS("/ready", new Readiness.Literal()),
    LIVENESS("/live", new Liveness.Literal()),
    STARTUP("/started", new Startup.Literal()),
    UNKNOWN(null, null);

    private String path;
    private AnnotationLiteral<?> literal;

    private HealthCheckType(String path, AnnotationLiteral<?> literal) {
        this.path = path;
        this.literal = literal;
    }

    public AnnotationLiteral<?> getLiteral() {
        return this.literal;
    }

    public static HealthCheckType fromPath(String path) {
        for (HealthCheckType value : HealthCheckType.values()) {
            if (value.path == null || !value.path.equals(path) && !value.path.substring(1).equals(path)) continue;
            return value;
        }
        return UNKNOWN;
    }

    public static HealthCheckType fromQualifiers(Set<Annotation> qualifiers) {
        for (HealthCheckType value : HealthCheckType.values()) {
            if (qualifiers == null || !qualifiers.contains(value.literal)) continue;
            return value;
        }
        throw new IllegalStateException("HealthCheckType not found for : " + qualifiers);
    }
}

